/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.model;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpeldesigner.models.schema.SchemaResolvedObj;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.MessageType;
import oracle.tip.tools.ide.common.utils.URIUtil;
import oracle.tip.tools.ide.common.utils.WSDLImport;
import oracle.tip.tools.ide.common.utils.WSDLMessage;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;

public class WSDLModel {
    private JDevBPELProject m_bpelProject;

    public WSDLModel(JDevBPELProject bpelProject) {
        this.m_bpelProject = bpelProject;
    }

    public WSDLMessage[] getMessages() throws Exception {
        return WSDLUtil.getWSDLMessages((Definition)this.m_bpelProject.getWSDLFileDefinition());
    }

    public void saveMessageType(MessageType type) throws Exception {
        BPELProjectUtil.saveMessageType((BPELProject)this.m_bpelProject, (URL)this.m_bpelProject.getBPELDirectoryURL(), (Definition)this.m_bpelProject.getWSDLFileDefinition(), (URL)this.m_bpelProject.getWSDLFileURL(this.m_bpelProject.getProcessName()), (MessageType)type);
    }

    public Map getNamespaceMapFromWSDL() {
        Definition def = this.m_bpelProject.getWSDLFileDefinition();
        if (def == null) {
            return null;
        }
        return def.getNamespaces();
    }

    public SchemaResolvedObj resolveNamespace(Process process, String namespaceURI, String elementName, boolean bIsElement) throws Exception {
        return SchemaResolvedObj.resolveNamespace((Project)this.m_bpelProject.getProject(), (URL)this.m_bpelProject.getWSDLFileURL(this.m_bpelProject.getProcessName()), (Process)process, (DeploymentFile)this.m_bpelProject.getDeploymentFile(), (String)namespaceURI, (String)elementName, (boolean)bIsElement);
    }

    public List<URI> getURIForNamespaceURI(String namespaceURI) {
        URL xsdRoot = this.m_bpelProject.getXSDRoot();
        URL wsdlRoot = this.m_bpelProject.getWSDLRoot();
        ArrayList<URL> xsdList = new ArrayList<URL>();
        ArrayList<URL> wsdlList = new ArrayList<URL>();
        try {
            FilenameFilter filter;
            File wsdlDir;
            File[] wsdlFiles;
            File xsdDir = new File(new URI(xsdRoot.toString()));
            File[] xsdFiles = xsdDir.listFiles();
            if (xsdFiles != null) {
                for (File f : xsdFiles) {
                    if (!f.isFile() || f.isHidden()) continue;
                    xsdList.add(Helper.getURL((File)f));
                }
            }
            if ((wsdlFiles = (wsdlDir = new File(new URI(wsdlRoot.toString()))).listFiles(filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".wsdl");
                }
            })) != null) {
                for (File f : wsdlFiles) {
                    if (!f.isFile() || f.isHidden()) continue;
                    wsdlList.add(Helper.getURL((File)f));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        URL[] xsdUrls = null;
        URL[] wsdlUrls = null;
        if (xsdList.size() > 0) {
            xsdUrls = new URL[xsdList.size()];
            xsdList.toArray(xsdUrls);
        }
        if (wsdlList.size() > 0) {
            wsdlUrls = new URL[wsdlList.size()];
            wsdlList.toArray(wsdlUrls);
        }
        return SchemaResolvedObj.getURIForNamespaceURI((String)namespaceURI, (URL[])xsdUrls, (URL[])wsdlUrls);
    }

    public void setPartnerLinkWSDLLocations(Process p) {
        BPELProjectUtil.setPartnerLinkWSDLLocations((BPELProject)this.m_bpelProject, (Process)p);
    }

    public List<WSDLImport> getImports() throws Exception {
        return WSDLUtil.getImports((Definition)this.m_bpelProject.getWSDLFileDefinition());
    }

    public boolean canPartnerLinkWSDLBeDeleted(PartnerLink link) {
        int projectUsageCount;
        URL bpelURL;
        JDevBPELProject prj = this.m_bpelProject;
        URL wsdlURL = BPELModelUtil.getPartnerLinkWSDLAsURL((PartnerLink)link);
        if (wsdlURL == null) {
            return false;
        }
        URL dirURL = Helper.getParent((URL)wsdlURL);
        if (!Helper.equals((URL)dirURL, (URL)(bpelURL = prj.getBPELDirectoryURL()))) {
            return false;
        }
        int partnerLinkUsage = 0;
        String rolename = link.getMyRole();
        if (rolename != null && rolename.length() > 0) {
            partnerLinkUsage = 1;
        }
        if ((rolename = link.getPartnerRole()) != null && rolename.length() > 0) {
            partnerLinkUsage = 1;
        }
        return (projectUsageCount = prj.getResourceUsageCount(wsdlURL)) - partnerLinkUsage <= 0;
    }

    public void deleteMessage(String name) throws Exception {
        BPELProjectUtil.deleteMessage((BPELProject)this.m_bpelProject, (String)name);
    }

    public void deletePartnerLinkWSDL(PartnerLink link) {
        URL wsdlURL = BPELModelUtil.getPartnerLinkWSDLAsURL((PartnerLink)link);
        if (wsdlURL != null) {
            this.m_bpelProject.deleteProjectResource(wsdlURL);
        }
    }

    public List getWSDLFilesWithNamespace(String namespaceURI, BPELProject prj, Process process) {
        List<URI> l;
        List plList;
        DeploymentFile depFile = prj.getDeploymentFile();
        List<URI> list = this.getWSDLFromNamespaceURI(process, depFile, namespaceURI);
        if (list == null) {
            list = new ArrayList<URI>();
        }
        List<WSDLImport> implist = null;
        try {
            implist = this.getImports();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (implist != null) {
            for (int i = 0; i < implist.size(); ++i) {
                WSDLImport imp = implist.get(i);
                if (!imp.getNamespaceURI().equals(namespaceURI)) continue;
                try {
                    list.add(new URI(URIUtil.escapeURIString((String)imp.getLocationURI())));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((plList = WSDLModel.getWSDLURIsOfPartnerLinks(process, prj.getDeploymentFile())) != null) {
            for (int i = 0; i < plList.size(); ++i) {
                try {
                    URI uri = (URI)plList.get(i);
                    URI retURI = WSDLUtil.getSchemaURI((URI)uri, (String)namespaceURI);
                    if (retURI != null) {
                        list.add(retURI);
                        continue;
                    }
                    List wlist = WSDLUtil.getAllWsdlByNS((String)namespaceURI, (URI)uri);
                    if (wlist == null) continue;
                    list.addAll(wlist);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((l = this.getURIForNamespaceURI(namespaceURI)) != null) {
            list.addAll(l);
        }
        ArrayList<URI> normalizedLst = new ArrayList<URI>();
        for (URI o : list) {
            URI uri = o;
            if (!Helper.hasValue((String)uri.toString()) || normalizedLst.contains(uri)) continue;
            normalizedLst.add(uri);
        }
        return normalizedLst;
    }

    public List<URI> getWSDLFromNamespaceURI(Process process, DeploymentFile depFile, String namespaceURI) {
        PartnerLinks plnks = process.getPartnerLinks();
        ArrayList<URI> list = null;
        if (plnks != null) {
            list = new ArrayList<URI>();
            for (PartnerLink plnk : plnks.getPartnerLinks()) {
                String ns;
                QName type = plnk.getPartnerLinkType();
                if (type == null || (ns = type.getNamespaceURI()) == null || !ns.equals(namespaceURI)) continue;
                try {
                    String wsdlLoc = depFile.getWSDLLocation(plnk.getName());
                    if (wsdlLoc == null) {
                        wsdlLoc = plnk.getWSDLLocation();
                    }
                    list.add(new URI(URIUtil.escapeURIString((String)wsdlLoc)));
                }
                catch (Exception ex) {}
            }
        }
        return list;
    }

    public static List getWSDLURIsOfPartnerLinks(Process process, DeploymentFile depFile) {
        PartnerLinks plnks = process.getPartnerLinks();
        ArrayList<URI> list = null;
        if (plnks != null) {
            list = new ArrayList<URI>();
            for (PartnerLink plnk : plnks.getPartnerLinks()) {
                try {
                    String wsdlLoc = depFile.getWSDLLocation(plnk.getName());
                    if (wsdlLoc == null) {
                        wsdlLoc = plnk.getWSDLLocation();
                    }
                    list.add(new URI(URIUtil.escapeURIString((String)wsdlLoc)));
                }
                catch (Exception ex) {}
            }
        }
        return list;
    }
}

