/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationPropertyAlias;
import oracle.tip.tools.ide.common.bpeldesigner.models.bpel.CorrelationSetProperty;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpeldesigner.util.WSDLPropertyUtil;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.WSDLUtil;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;

public class PropertyModel {
    private JDevBPELProject m_bpelProject;

    public PropertyModel(JDevBPELProject bpelProject) {
        this.m_bpelProject = bpelProject;
    }

    public List<CorrelationPropertyAlias> getPropertyAliases() throws Exception {
        return BPELProjectUtil.getPropertyAlias((BPELProject)this.m_bpelProject);
    }

    public void removeProperty(String name) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        WSDLPropertyUtil.removeProperty((BPELProject)this.m_bpelProject, list);
    }

    public void saveProperty(CorrelationSetProperty prop) throws Exception {
        WSDLPropertyUtil.saveProperty((BPELProject)this.m_bpelProject, (CorrelationSetProperty)prop);
    }

    public void saveProperties(List propList) throws Exception {
        Project p = this.m_bpelProject.getProject();
        URL url = this.m_bpelProject.getPropertiesWSDLURL();
        boolean bExist = Helper.exists((URL)url);
        if (bExist) {
            WSDLUtil.parseWSDL((URL)url);
        } else {
            Definition def = WSDLUtil.newDefinition();
            def.setQName(new QName("http://schemas.xmlsoap.org/wsdl/", "properties"));
        }
        BPELProjectUtil.saveProperties((List)propList, (BPELProject)this.m_bpelProject);
        if (!bExist) {
            try {
                Node wsdlNode = NodeFactory.findOrCreate(BPELWSDLNode.class, (URL)url);
                p.add((Element)wsdlNode, true);
                p.save();
            }
            catch (Exception mex) {
                mex.printStackTrace();
            }
        }
    }

    public List<Object> getProperties() throws Exception {
        return WSDLPropertyUtil.getBPELProperties((BPELProject)this.m_bpelProject);
    }

    public void deleteProperties(List props) throws Exception {
        BPELProjectUtil.removeProperty((BPELProject)this.m_bpelProject, (List)props);
    }

    public void deleteProperty(String name) throws Exception {
        BPELProjectUtil.deleteProperty((BPELProject)this.m_bpelProject, (String)name);
    }

    public void deletePropertyAlias(CorrelationPropertyAlias alias) throws Exception {
        BPELProjectUtil.deletePropertyAlias((BPELProject)this.m_bpelProject, (CorrelationPropertyAlias)alias);
    }
}

