/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelListener;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.bpeldesigner.caches.VariableDocumentCache;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.ParserContext;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLink;
import oracle.tip.tools.ide.common.bpelparser.iface.PartnerLinks;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.TransactionManager;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.common.ide.bpel.BPELProjectUtil;
import oracle.tip.tools.ide.common.utils.DeploymentFile;
import oracle.tip.tools.ide.common.utils.XMLIDGenerator;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModelListener;
import oracle.tip.tools.ide.pm.addin.model.ISecondaryModel;
import oracle.tip.tools.ide.pm.addin.model.PartnerLinkHiddenAttributes;
import oracle.tip.tools.ide.pm.addin.model.PropertyModel;
import oracle.tip.tools.ide.pm.addin.model.WSDLModel;
import oracle.tip.tools.ide.pm.addin.model.XmlModelTransactionManager;
import oracle.tip.tools.ide.pm.addin.view.BPELDesignerGUI;
import oracle.tip.tools.ide.pm.addin.view.BPELExplorer;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import org.w3c.dom.Document;

public class BPELXmlModel
extends XmlModel {
    protected BPELDesignerGUI m_gui;
    protected Document m_parserDocument;
    protected URL m_documentURL;
    protected EventListenerList m_listenerList = new EventListenerList();
    protected long m_diagramTimeStamp;
    protected HashMap<String, PartnerLinkHiddenAttributes> m_partnerLinkMap;
    protected JDevBPELProject m_bpelProject;
    protected Process m_process;
    protected List<ISecondaryModel> m_secondaryModels = new ArrayList<ISecondaryModel>();
    protected WSDLModel m_wsdlModel;
    protected PropertyModel m_propertyModel;

    public BPELXmlModel(URL url, Project project) {
        super(MetadataRegistry.getInstance().getMetadataProvider("BPEL_METADATA_PROVIDER_ID"));
        String bpelFileName = URLFileSystem.getFileName((URL)url);
        int idx = bpelFileName.indexOf(".bpel");
        String processName = idx != -1 ? bpelFileName.substring(0, idx) : bpelFileName;
        this.m_bpelProject = new JDevBPELProject(project, processName);
        this.m_bpelProject.storeProjectData("bpelFileURL", url);
        this.m_wsdlModel = new WSDLModel(this.m_bpelProject);
        this.m_propertyModel = new PropertyModel(this.m_bpelProject);
        this.m_documentURL = url;
        this.m_diagramTimeStamp = this.getTimestamp();
        this.installXMLModelListeners();
    }

    public void postAttachmentHook() {
        this.createProcessFromDocument();
    }

    public DeploymentFile getDeploymentFile() {
        return this.m_bpelProject.getDeploymentFile();
    }

    public WSDLModel getWSDLModel() {
        return this.m_wsdlModel;
    }

    public PropertyModel getPropertyModel() {
        return this.m_propertyModel;
    }

    public Process getProcess() {
        return this.m_process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEditable() {
        try {
            this.acquireReadLock();
            boolean bl = !this.isReadOnly();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected void installXMLModelListeners() {
        this.addModelListener((XmlModelListener)XMLIDGenerator.getInstance());
    }

    public void addSecondaryModel(ISecondaryModel model) {
        this.m_secondaryModels.add(model);
    }

    public void removeSecondaryModel(ISecondaryModel model) {
        this.m_secondaryModels.remove(model);
    }

    public List<ISecondaryModel> getSecondaryModels() {
        return Collections.unmodifiableList(this.m_secondaryModels);
    }

    public void save() throws Exception {
        this.saveDeploymentFile();
        this.savePluginModels();
        this.saveBPELProject();
        this.saveSecondaryModels();
        this.clearPartnerLinkMap();
        this.fireSaveEvent();
    }

    public void close() {
        this.m_gui = null;
        BPELExplorer explorer = BPELExplorer.getInstance();
        if (explorer != null) {
            explorer.remove(this.m_documentURL);
        }
        VariableDocumentCache.clearVariablesCache((URL)this.m_documentURL);
        this.m_parserDocument = null;
        this.clearPartnerLinkMap();
        this.m_secondaryModels.clear();
    }

    public void newDiagramTimeStamp() {
        this.m_diagramTimeStamp = System.currentTimeMillis();
    }

    public BPELProject getBPELProject() {
        return this.m_bpelProject;
    }

    public Document getParserDocument() {
        return this.m_parserDocument;
    }

    public void addBPELXmlModelListener(BPELXmlModelListener l) {
        this.m_listenerList.add(BPELXmlModelListener.class, l);
    }

    public void removeBPELXmlModelListener(BPELXmlModelListener l) {
        this.m_listenerList.remove(BPELXmlModelListener.class, l);
    }

    public synchronized void saveEditorTransitionData() throws Exception {
        this.saveHiddenAttributesForPartnerLinks();
    }

    public void syncProcessToDOM() {
        if (this.m_process == null || this.m_diagramTimeStamp < this.getTimestamp()) {
            this.createProcessFromDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Process createProcessFromDocument() {
        if (this.m_process != null && this.m_diagramTimeStamp >= this.getTimestamp()) {
            return this.m_process;
        }
        this.acquireReadLock();
        try {
            Document frameworkDOM = this.getDocument();
            XMLIDGenerator.getInstance().mapDocument2URL(frameworkDOM, this.m_documentURL);
            this.m_parserDocument = BPELParser.isXMLEditingFramework() ? frameworkDOM : (Document)frameworkDOM.cloneNode(true);
        }
        finally {
            this.releaseReadLock();
        }
        this.m_process = (Process)BPELParser.createImplementation(Process.class);
        this.m_process.setDOMElement(this.m_parserDocument.getDocumentElement());
        ParserContext parserContext = this.m_process.createParserContext();
        parserContext.setProcessURL(this.m_documentURL);
        this.m_process.setTransactionManager((TransactionManager)new XmlModelTransactionManager(this));
        this.m_process.readFromElement(this.m_parserDocument.getDocumentElement(), parserContext, true);
        this.m_wsdlModel.setPartnerLinkWSDLLocations(this.m_process);
        return this.m_process;
    }

    public URL getDocumentURL() {
        return this.m_documentURL;
    }

    public void setGUI(BPELDesignerGUI gui) {
        this.m_gui = gui;
    }

    public BPELDesignerGUI getGUI() {
        return this.m_gui;
    }

    protected void saveBPELProject() throws Exception {
        this.m_bpelProject.save();
    }

    protected void saveSecondaryModels() {
        for (ISecondaryModel m : this.m_secondaryModels) {
            if (!m.isDirty()) continue;
            try {
                m.save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void savePluginModels() {
        for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
            try {
                plugin.save(this.m_process, this.m_bpelProject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveDeploymentFile() throws Exception {
        BPELProjectUtil.saveDeploymentFile((BPELProject)this.m_bpelProject, (boolean)false, (boolean)false, (Process)this.m_process);
        this.m_bpelProject.refreshResource(BPELProjectUtil.getDeploymentFileURL((BPELProject)this.m_bpelProject));
    }

    private void clearPartnerLinkMap() {
        if (this.m_partnerLinkMap != null) {
            this.m_partnerLinkMap.clear();
            this.m_partnerLinkMap = null;
        }
    }

    private void saveHiddenAttributesForPartnerLinks() {
        PartnerLinks partnerLinks = this.m_process.getPartnerLinks();
        if (partnerLinks == null) {
            return;
        }
        List links = partnerLinks.getPartnerLinks();
        this.m_partnerLinkMap = new HashMap();
        for (PartnerLink link : links) {
            PartnerLinkHiddenAttributes atts = new PartnerLinkHiddenAttributes();
            this.m_partnerLinkMap.put(link.getName(), atts);
            atts.m_loc = link.getWSDLLocation();
            atts.m_bInbport = link.isInbound();
            if (!atts.m_bInbport) continue;
            atts.m_inbountPort = link.getPortType();
        }
    }

    protected void fireSaveEvent() {
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BPELXmlModelListener.class) continue;
            ((BPELXmlModelListener)listeners[i + 1]).saveOccurred(this);
        }
    }

    protected void finalize() throws Throwable {
        this.m_gui = null;
        super.finalize();
    }
}

