/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.model;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfigurationDecorator;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptions;
import oracle.bali.xml.dom.buffer.textsync.TextSyncOptionsDecorator;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.XmlGuiFactory;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.ide.Ide;
import oracle.ide.model.ElementAttributes;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.fabric.soasavecontroller.SOANode;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.view.BPELXmlViewFactory;
import oracle.tip.tools.ide.pm.addin.view.GUIFactory;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BPELNode
extends XMLSourceNode
implements SOANode {
    protected BPELXmlModel m_model;

    public BPELNode() {
        this.getAttributes().set(ElementAttributes.BUILDABLE);
    }

    public Icon getIcon() {
        return ImageCache.getIcon("process_node");
    }

    public XmlModel createXmlModel(JDevXmlContext context, MetadataProvider metaDataProvider) {
        if (this.m_model == null) {
            this.m_model = new BPELXmlModel(this.getURL(), context.getProject());
        }
        return this.m_model;
    }

    public GrammarProvider createGrammarProvider(JDevXmlContext jDevXmlContext) {
        try {
            SchemaGrammarProvider s = new SchemaGrammarProvider();
            for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                List<URL> schemas = plugin.getSchemaGrammers();
                for (URL u : schemas) {
                    s.addSchema(u);
                }
            }
            return s;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return super.createGrammarProvider(jDevXmlContext);
        }
    }

    protected void registerGuiFactories(JDevXmlContext context) {
        context.registerGuiFactory((XmlGuiFactory)GUIFactory.getInstance());
    }

    protected void registerViewFactories(JDevXmlContext context) {
        context.registerViewFactory((XmlViewFactory)BPELXmlViewFactory.getInstance());
    }

    protected void saveImpl() throws IOException {
        URL url = this.getURL();
        if (URLFileSystem.isReadOnly((URL)url)) {
            String file = URLFileSystem.getFileName((URL)url);
            String msg = BPELStringTranslator.formatString("READ_ONLY_ERROR_MESSAGE", file);
            throw new IOException(msg);
        }
        if (this.m_model != null) {
            try {
                this.m_model.save();
            }
            catch (Exception e) {
                GraphUtils.displayError((Component)Ide.getMainWindow(), (Throwable)e);
            }
        }
        super.saveImpl();
    }

    public void closeImpl() throws IOException {
        if (this.m_model != null) {
            this.m_model.close();
            this.m_model = null;
        }
        super.closeImpl();
    }

    public ParserConfiguration getParserConfiguration(JDevXmlContext p1) {
        return new ParserConfigurationDecorator(super.getParserConfiguration(p1)){

            public TextSyncOptions getTextSyncOptions() {
                return new TSO(super.getTextSyncOptions());
            }
        };
    }

    public void markDirty(boolean b) {
        super.markDirty(b);
    }

    public class TSO
    extends TextSyncOptionsDecorator {
        private TextSyncOptions m_t;

        protected TextSyncOptions getBaseTextSyncOptions() {
            return this.m_t;
        }

        public TSO(TextSyncOptions t) {
            this.m_t = t;
        }

        public boolean prefersWhitespaceInside(Element parent) {
            String name = parent.getNodeName();
            String ns = parent.getNamespaceURI();
            if (name != null) {
                boolean bCheck = false;
                if (ns != null) {
                    if ("from".equals(name) && "http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(ns) || !"http://schemas.xmlsoap.org/ws/2003/03/business-process/".equals(ns)) {
                        bCheck = true;
                    }
                } else {
                    bCheck = true;
                }
                if (bCheck) {
                    NodeList nl = parent.getChildNodes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        Node n = nl.item(i);
                        if (n.getNodeType() != 3) continue;
                        return false;
                    }
                }
            }
            return super.prefersWhitespaceInside(parent);
        }
    }
}

