/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.migrator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.log.Href;
import oracle.ide.log.LogManager;
import oracle.ide.log.MessagePage;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectVersion;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.utils.IdeLogger;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.addin.SCAProjectConfigurator;
import oracle.tip.tools.ide.pm.modules.bam.BAMConnectionPlugin;
import oracle.tip.tools.ide.workflow.taskflow.util.TaskFlowUtil;
import oracle.toplink.workbench.addin.TopLinkAddin;
import oracle.toplink.workbench.addin.application.TopLinkContext;
import oracle.toplink.workbench.addin.application.TopLinkContextAdapter;
import oracle.toplink.workbench.addin.application.TopLinkContextManager;
import oracle.toplink.workbench.addin.application.TopLinkProjectContext;
import oracle.toplink.workbench.addin.migration.Legacy1013TopLinkProjectSettings;
import oracle.toplink.workbench.addin.preference.ProjectPreferences;
import org.apache.tools.ant.ProjectHelper;

public class PMProjectMigrator
extends NodeMigratorHelper {
    public static final String PROJECT_DELIMITER = ";";
    private static final String BPEL_TARGET = "bpel";
    private static final String ESB_TARGET = "mediator";

    public void migrate(MigrationInfo[] info, TraversableContext context) {
        Workspace app = null;
        if (context != null) {
            Object obj = context.get("workspace-node-instance");
            app = obj != null && obj instanceof Workspace ? (Workspace)obj : Ide.getActiveWorkspace();
        }
        int length = info.length;
        for (int i = 0; i < length; ++i) {
            Node node = info[i].getNode();
            if (info[i].getMigrationStatus() != MigrationInfo.MIGRATION_PENDING || !(node instanceof Project)) continue;
            Project project = (Project)node;
            String version = info[i].getVersion();
            if (version.indexOf("1012") != -1) {
                if (!this.isBPELProject1012(project)) continue;
                MessageFormat msgformat = new MessageFormat(MessageBundleUtil.getString((String)"MIGRATION_UNSUPPORTED_ERROR"));
                Object[] obj = new Object[]{version};
                String msg = msgformat.format(obj);
                MultiLineOptionPane.showMessageDialog(null, (Object)msg, (String)MessageBundleUtil.getString((String)"MIGRATION_ERROR_TITLE"), (int)0);
                info[i].setMigrationStatus(MigrationInfo.MIGRATION_ERROR);
                return;
            }
            if (!this.is1013Project(project)) continue;
            if (this.isBPELProject(project)) {
                try {
                    this.migrateTo11(BPEL_TARGET, app, project);
                }
                catch (ProjectConversionException pce) {
                    this.displayProjectConversionError(project, pce);
                    info[i].setMigrationStatus(MigrationInfo.MIGRATION_ERROR);
                    pce.printStackTrace();
                }
                catch (Exception e) {
                    info[i].setMigrationStatus(MigrationInfo.MIGRATION_ERROR);
                    e.printStackTrace();
                }
                this.displayLogFileLink(project);
                this.displayWarningAndErrorCounts(this.getUpgradeLogFile(project));
                continue;
            }
            if (!this.isESBProject(project)) continue;
            try {
                this.migrateTo11(ESB_TARGET, app, project);
            }
            catch (ProjectConversionException pce) {
                this.displayProjectConversionError(project, pce);
                info[i].setMigrationStatus(MigrationInfo.MIGRATION_ERROR);
                pce.printStackTrace();
            }
            catch (Exception e) {
                info[i].setMigrationStatus(MigrationInfo.MIGRATION_ERROR);
                e.printStackTrace();
            }
            this.displayLogFileLink(project);
            this.displayWarningAndErrorCounts(this.getUpgradeLogFile(project));
        }
    }

    public boolean is1013Project(Project project) {
        String version;
        String HELPER_KEY = "oracle.tip.tools.ide.pm.addin.PMProjectMigrator";
        ProjectVersion projectVersion = new ProjectVersion((PropertyStorage)project);
        VersionNumber versionNum = projectVersion.getCurrentVersion("oracle.tip.tools.ide.pm.addin.PMProjectMigrator");
        return versionNum != null && (version = versionNum.toString()) != null && version.indexOf("10.1.3") != -1;
    }

    public boolean isBPELProject(Project project) {
        String projDir = project.getBaseDirectory() + File.separator + BPEL_TARGET;
        return this.fileExists(projDir, ".bpel");
    }

    public boolean isBPELProject1012(Project project) {
        String dir = project.getBaseDirectory();
        if (this.fileExists(dir, ".bpel")) {
            return true;
        }
        return this.fileExists(dir = dir + "/bpel", ".bpel");
    }

    public boolean isESBProject(Project project) {
        String projDir = project.getBaseDirectory();
        return this.fileExists(projDir, ".esb");
    }

    private boolean fileExists(String directory, String extension) {
        if (directory != null && !directory.trim().equals("") && extension != null && !extension.trim().equals("")) {
            try {
                File dir = new File(directory);
                String[] fileList = dir.list();
                for (int i = 0; i < fileList.length; ++i) {
                    String currFilename = fileList[i];
                    if (!currFilename.toLowerCase().endsWith(extension)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private void migrateTo11(String target, Workspace app, Project project) throws ProjectConversionException, Exception {
        if (project != null) {
            String sourcePath;
            BAMConnectionPlugin bamPlugin = new BAMConnectionPlugin();
            bamPlugin.migrateBAMConnection(app, project);
            String SOURCE_PROPERTY = "source";
            String TARGET_PROPERTY = "target";
            String APP_NAME_PROPERTY = "appName";
            String ORACLE_HOME_PROPERTY = "oracle.home";
            String JDEV_MODE_PROPERTY = "jdev.mode";
            String PROJECT_LIST = "project.list";
            String orclHomeDir = Ide.getOracleHomeDirectory();
            String separator = "";
            if (!orclHomeDir.endsWith(File.separator)) {
                separator = File.separator;
            }
            String BUILD_FILE = orclHomeDir + separator + "bin" + File.separator + "ant-sca-upgrade.xml";
            File buildFile = new File(BUILD_FILE);
            String targetPath = sourcePath = project.getBaseDirectory();
            String oracleHomePath = Ide.getOracleHomeDirectory();
            String projDirList = this.getBPELProjects(app, project);
            ArrayList<String> targetList = new ArrayList<String>();
            targetList.add(target);
            Context ctx = Context.newIdeContext();
            ctx.setWorkspace(app);
            ctx.setProject(project);
            String appName = this.getAppName(app);
            if (appName == null || appName.trim().equals("")) {
                appName = "SOA";
            }
            org.apache.tools.ant.Project antProj = new org.apache.tools.ant.Project();
            antProj.init();
            antProj.setProperty(ORACLE_HOME_PROPERTY, oracleHomePath);
            antProj.setProperty(SOURCE_PROPERTY, sourcePath);
            antProj.setProperty(APP_NAME_PROPERTY, appName);
            antProj.setProperty(TARGET_PROPERTY, targetPath);
            antProj.setProperty(JDEV_MODE_PROPERTY, "true");
            antProj.setProperty(PROJECT_LIST, projDirList);
            ProjectHelper.configureProject((org.apache.tools.ant.Project)antProj, (File)buildFile);
            this.removeToplinkPrefs(app, project);
            antProj.executeTarget(target);
            SCAProjectConfigurator.createSOASharedMDSStore((Workspace)app);
            this.convertProjectTo11(app, project);
        }
    }

    private void convertTaskFlowProject(Context jdevCtx) throws Exception {
        Project soaProject = jdevCtx.getProject();
        if (soaProject == null) {
            return;
        }
        String taskFlowTrackingFile = this.getTaskFlowTrackingPath(soaProject);
        List taskFlowProjList = this.getTaskFlowProjectNames(taskFlowTrackingFile);
        if (taskFlowProjList == null) {
            return;
        }
        for (String taskFlowProjDir : taskFlowProjList) {
            String taskFlowProjPath = this.getTaskFlowProjectName(taskFlowProjDir);
            Project taskProj = null;
            URL taskProjURL = URLFactory.newFileURL((String)taskFlowProjPath);
            Workspace workspace = jdevCtx.getWorkspace();
            taskProj = NewEmptyProjectCommand.createProjectInWorkspace((URL)taskProjURL, (Workspace)workspace, null);
            jdevCtx.setProject(taskProj);
            TaskFlowUtil.updateProjectForTaskFlow((Context)jdevCtx);
        }
        File file = new File(taskFlowTrackingFile);
        file.delete();
    }

    private void convertProjectTo11(Workspace app, Project project) throws ProjectConversionException {
        Context jdevCtx = Context.newIdeContext();
        if (app != null) {
            jdevCtx.setWorkspace(app);
        }
        jdevCtx.setProject(project);
        SCAProjectConfigurator.configSCAProject((Context)jdevCtx);
        try {
            this.convertTaskFlowProject(jdevCtx);
        }
        catch (Exception e) {
            throw new ProjectConversionException((Throwable)e);
        }
    }

    private String getAppName(Workspace app) {
        String DOT_JWS = ".jws";
        if (app == null) {
            return null;
        }
        String appName = app.getShortLabel();
        if (appName == null) {
            return null;
        }
        int endIndex = appName.indexOf(".jws");
        if (endIndex > -1) {
            appName = appName.substring(0, endIndex);
            return appName;
        }
        return null;
    }

    private List getTaskFlowProjectNames(String projFilePath) throws Exception {
        String curLine;
        if (projFilePath == null) {
            return null;
        }
        File file = new File(projFilePath);
        if (!file.exists()) {
            return null;
        }
        ArrayList<String> projectNames = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(projFilePath));
        while ((curLine = reader.readLine()) != null) {
            projectNames.add(curLine);
        }
        return projectNames;
    }

    private String getTaskFlowTrackingPath(Project soaProj) {
        String soaProjName = soaProj.getShortLabel();
        soaProjName = soaProjName.substring(0, soaProjName.indexOf(".jpr"));
        String taskFlowFileName = "." + soaProjName + ".jdev.tracking";
        String taskFlowTrackingDir = this.stripEndingSeparator(soaProj.getBaseDirectory());
        int index = taskFlowTrackingDir.lastIndexOf(File.separator);
        if (index < 0) {
            return taskFlowFileName;
        }
        taskFlowTrackingDir = taskFlowTrackingDir.substring(0, index);
        return taskFlowTrackingDir + File.separator + taskFlowFileName;
    }

    private String stripEndingSeparator(String path) {
        if (path == null) {
            return null;
        }
        String lastChar = path.substring(path.length() - 1);
        if (lastChar.equals(File.separator)) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String getTaskFlowProjectName(String taskFlowProjectDir) {
        if (taskFlowProjectDir == null) {
            return null;
        }
        taskFlowProjectDir = this.stripEndingSeparator(taskFlowProjectDir);
        int begin = taskFlowProjectDir.lastIndexOf(File.separator) + 1;
        int end = taskFlowProjectDir.length();
        return taskFlowProjectDir + File.separator + taskFlowProjectDir.substring(begin, end) + ".jpr";
    }

    private String getBPELProjects(Workspace app, Project migProj) {
        String dirList = "";
        if (app == null) {
            return "";
        }
        Collection projectList = app.projects();
        if (projectList == null) {
            return "";
        }
        for (Project currProj : projectList) {
            if (!this.isBPELProject(currProj)) continue;
            String currDir = currProj.getBaseDirectory();
            if (dirList.equals("")) {
                dirList = currDir;
                continue;
            }
            dirList = dirList + PROJECT_DELIMITER + currDir;
        }
        return dirList;
    }

    private void displayProjectConversionError(Project project, ProjectConversionException pce) {
        String projectName = URLFileSystem.getName((URL)project.getURL());
        MessageFormat msgformat = new MessageFormat(MessageBundleUtil.getString((String)"MIGRATION_ERROR_PROJECT"));
        Object[] obj = new Object[]{projectName};
        String msg = msgformat.format(obj);
        IdeLogger.logMessage((String)msg);
        IdeLogger.logMessage((String)pce.getMessage());
    }

    private void removeToplinkPrefs(Workspace app, Project proj) throws Exception {
        if (app == null || proj == null) {
            return;
        }
        File[] toplinkMappingXmls = this.containsTopLink(new File(proj.getBaseDirectory()));
        if (toplinkMappingXmls == null) {
            return;
        }
        File sourceDirectory = new File(proj.getBaseDirectory());
        File toplinkDir = new File(sourceDirectory, "toplink");
        HashSet<String> unownedMwps = new HashSet<String>();
        if (toplinkDir.exists()) {
            File[] mwpDirs = toplinkDir.listFiles();
            for (int i = 0; i < mwpDirs.length; ++i) {
                unownedMwps.add(mwpDirs[i].getName());
            }
        }
        for (int i = 0; i < toplinkMappingXmls.length; ++i) {
            String name = toplinkMappingXmls[i].getName();
            if (name.endsWith("_toplink_mappings.xml")) {
                name = name.substring(0, name.indexOf("_toplink_mappings.xml"));
            }
            unownedMwps.remove(name);
        }
        if (unownedMwps.size() > 0) {
            return;
        }
        TopLinkContextManager contextManager = TopLinkAddin.getAddin().getContextManager();
        Legacy1013TopLinkProjectSettings settings = Legacy1013TopLinkProjectSettings.getInstance((Project)proj);
        Iterator topLinkMapNames = settings.getTopLinkMapNames();
        while (topLinkMapNames.hasNext()) {
            String name = (String)topLinkMapNames.next();
            if (unownedMwps.contains(name)) continue;
            settings.removeTopLinkMapLocation(name);
        }
        ProjectPreferences topLinkPreferences = contextManager.findProjectPreferences(proj);
        if (topLinkPreferences == null) {
            return;
        }
        ProjectPreferences child = topLinkPreferences.getChild("toplink-map-list");
        if (child != null) {
            topLinkPreferences.removeChild("toplink-map-list");
        }
    }

    private File[] containsTopLink(File sourceDirectory) {
        File inDirectory = new File(sourceDirectory, BPEL_TARGET);
        File[] mappingsFiles = inDirectory.listFiles(new TopLinkMappingsFileFilter());
        if (!(mappingsFiles != null && mappingsFiles.length != 0 || (mappingsFiles = (inDirectory = sourceDirectory).listFiles(new TopLinkMappingsFileFilter())) != null && mappingsFiles.length != 0)) {
            return null;
        }
        return mappingsFiles;
    }

    private void displayLogFileLink(Project project) {
        URL url;
        String logFile = this.getUpgradeLogFile(project);
        if (logFile == null) {
            String logDir = this.getUpgradeLogLocation();
            String projectName = URLFileSystem.getName((URL)project.getURL());
            MessageFormat msgformat = new MessageFormat(MessageBundleUtil.getString((String)"MIGRATION_LOG_DIR"));
            Object[] obj = new Object[]{projectName, logDir};
            String msg = msgformat.format(obj);
            IdeLogger.logMessage((String)MessageBundleUtil.getString((String)msg));
            return;
        }
        File file = new File(logFile);
        String str = file.getAbsolutePath();
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            return;
        }
        final LogManager logManager = LogManager.getLogManager();
        Href href = new Href(str, url){

            public void go() {
                try {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    Context context = Context.newIdeContext((Node)node);
                    context.setWorkspace(Ide.getActiveWorkspace());
                    context.setProject(Ide.getActiveProject());
                    EditorManager editorManager = EditorManager.getEditorManager();
                    editorManager.openEditor(new OpenEditorOptions(context, CodeEditor.class));
                }
                catch (Exception e) {
                    logManager.getMsgPage().log((Object)("Error opening '" + url.toExternalForm() + "' :" + e.getLocalizedMessage()));
                }
            }
        };
        logManager.showLog();
        if (logManager.getMsgPage() instanceof MessagePage) {
            String projectName = URLFileSystem.getName((URL)project.getURL());
            MessageFormat msgformat = new MessageFormat(MessageBundleUtil.getString((String)"MIGRATION_LOG_FILE"));
            Object[] obj = new Object[]{projectName};
            String msg = msgformat.format(obj);
            logManager.getMsgPage().log((Object)msg);
            ((MessagePage)logManager.getMsgPage()).log((Object)href);
        }
        logManager.getMsgPage().log((Object)"\n");
    }

    private String getUpgradeLogFile(Project project) {
        try {
            if (project == null) {
                return null;
            }
            String upgradeLogTxt = project.getBaseDirectory() + File.separator + "upgradeLog.txt";
            FileInputStream fis = new FileInputStream(upgradeLogTxt);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            return in.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getUpgradeLogLocation() {
        String logDir = "upgrade" + File.separator + "logs";
        String upgradeLogLoc = Ide.getOracleHomeDirectory();
        if (upgradeLogLoc == null) {
            return null;
        }
        if (!upgradeLogLoc.endsWith(File.separator)) {
            upgradeLogLoc = upgradeLogLoc + File.separator;
        }
        upgradeLogLoc = upgradeLogLoc + logDir;
        return upgradeLogLoc;
    }

    private void displayWarningAndErrorCounts(String logFile) {
        int warningCount = 0;
        int errorCount = 0;
        if (logFile == null) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(logFile);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith(Level.WARNING.getName())) {
                    ++warningCount;
                    continue;
                }
                if (!line.startsWith(Level.SEVERE.getName())) continue;
                ++errorCount;
            }
            String msg = null;
            if (warningCount > 0) {
                String warningCountMsg;
                msg = warningCountMsg = MessageBundleUtil.getString((String)"MIGRATION_WARNINGS") + warningCount;
            }
            if (errorCount > 0) {
                String errorCountMsg = MessageBundleUtil.getString((String)"MIGRATION_ERRORS") + errorCount;
                msg = msg == null ? errorCountMsg : msg + "; " + errorCountMsg;
            }
            if (msg != null) {
                IdeLogger.logMessage(msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public class ProjectConversionException
    extends Exception {
        public ProjectConversionException(String message) {
            super(message);
        }

        public ProjectConversionException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProjectConversionException(Throwable cause) {
            super(cause);
        }
    }

    private class RemoveTopLinkListener
    extends TopLinkContextAdapter {
        private Project project;

        public RemoveTopLinkListener(Project project) {
            this.project = project;
        }

        public void contextsOpened(Context context) {
            TopLinkContextManager contextManager = TopLinkAddin.getAddin().getContextManager();
            Iterator i = contextManager.projectContexts(this.project);
            while (i.hasNext()) {
                TopLinkProjectContext tlpCtx = (TopLinkProjectContext)i.next();
                try {
                    tlpCtx.delete();
                }
                catch (Exception e) {
                    contextManager.remove((TopLinkContext)tlpCtx);
                }
            }
        }
    }

    private class TopLinkMappingsFileFilter
    implements FileFilter {
        private TopLinkMappingsFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.getPath().endsWith("toplink_mappings.xml");
        }
    }
}

