/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.logging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.view.View;
import oracle.tip.tools.ide.pm.addin.logging.BPELLogPage;

public class BPELModelerLogger {
    public static final String BPEL_LOGWINDOW = "BPEL_LOGWINDOW";

    public static void hideLogWindow() {
        LogManager.getLogManager().hideLog();
    }

    public static void showUserError(Exception e) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        e.printStackTrace(ps);
        String msg = e.getMessage();
        System.err.println(msg);
    }

    public static LogPage showLogWindow(String pageID) {
        LogPage page = BPELModelerLogger.getPageForID(pageID);
        View view = page.getLogPageView();
        if (view != null) {
            view.show();
            view.activate();
        }
        return page;
    }

    public static synchronized LogPage getPageForID(String id) {
        for (LogPage p : LogManager.getLogManager().getPages()) {
            String pageID = p.getLogPageView().getId();
            if (!pageID.startsWith(id)) continue;
            return p;
        }
        return BPELModelerLogger.createLogPage(id);
    }

    private static LogPage createLogPage(String id) {
        if (id.equalsIgnoreCase(BPEL_LOGWINDOW)) {
            return BPELLogPage.getInstance();
        }
        return LogManager.getLogManager().getMsgPage();
    }
}

