/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.logging;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.Perspective;

public class BPELLogPage
extends AbstractLogPage {
    private static String NO_LOG = "NO_LOG";
    protected CardPanel m_cardPnl;
    private static BPELLogPage m_instance;

    public static BPELLogPage getInstance() {
        if (m_instance == null) {
            m_instance = new BPELLogPage();
        }
        return m_instance;
    }

    public void loadLogWindow(JDevBPELEditor editor) {
        this.m_cardPnl.removeAll();
        for (Perspective p : editor.getPerspectivesPanel().getPerspectives()) {
            JComponent log = p.getLogWindow();
            this.m_cardPnl.add(p.getID(), (Component)log);
        }
        Perspective p = editor.getPerspectivesPanel().getSelectedPerspective();
        this.m_cardPnl.show(p.getID());
    }

    public void showLogWindow(Perspective p) {
        this.m_cardPnl.show(p.getID());
    }

    private BPELLogPage() {
        super(new ViewId("BPEL_LOGWINDOW", BPELStringTranslator.getString("LOGGING_BPEL_MESSAGES", "BPEL Messages")));
    }

    public Component getGUI() {
        if (this.m_cardPnl == null) {
            this.m_cardPnl = new CardPanel();
            this.m_cardPnl.add(NO_LOG, (Component)this.createNoLogPanel());
        }
        return this.m_cardPnl;
    }

    protected JPanel createNoLogPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        JLabel l = new JLabel("No Log Available", 0);
        l.setForeground(Color.lightGray);
        GraphUtils.addComponent((Container)p, (Component)l, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        return p;
    }
}

