/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.folders.custom;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.net.URLFileSystem;

public class ServiceInfo {
    protected URL m_wsdlURL;
    protected String m_serviceName;
    protected Map m_infoMap;
    private int m_idx;
    protected Object m_paramObj;

    public ServiceInfo(URL wsdlURL, String serviceName) {
        this(wsdlURL, serviceName, true);
    }

    public ServiceInfo(URL wsdlURL, String serviceName, boolean bAddToFileList) {
        this.m_wsdlURL = wsdlURL;
        this.m_serviceName = serviceName;
        this.m_infoMap = new HashMap();
        this.m_infoMap.put("ServiceName", serviceName);
        if (bAddToFileList) {
            this.addServiceFile(wsdlURL);
        }
    }

    public URL getWSDLURL() {
        return this.m_wsdlURL;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public Map getInfoMap() {
        return this.m_infoMap;
    }

    public void addServiceFile(URL fileURL) {
        String file = URLFileSystem.getFileName((URL)fileURL);
        this.m_infoMap.put("ServiceFile" + this.m_idx++, file);
    }

    public void setIconName(String iconName) {
        this.m_infoMap.put("ServiceIcon", iconName);
    }

    public void setParameter(Object obj) {
        this.m_paramObj = obj;
    }

    public Object getParameter() {
        return this.m_paramObj;
    }
}

