/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.folders.custom;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.javatools.data.HashStructure;
import oracle.tip.tools.ide.common.ide.bpel.BPELProject;
import oracle.tip.tools.ide.pm.addin.folders.custom.AbstractCustomFolder;
import oracle.tip.tools.ide.pm.addin.folders.custom.ICustomFolderInBPELProject;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class ServiceCustomFolder
extends AbstractCustomFolder
implements ICustomFolderInBPELProject {
    public static final String SERVICE_NAME_KEY = "ServiceName";
    public static final String SERVICE_ICON_KEY = "ServiceIcon";
    public static final String SERVICE_FILE_PREFIX_KEY = "ServiceFile";
    protected BPELProject m_bpelPrj;
    protected HashStructure m_hashStructure;
    protected List m_allowedList;

    @Override
    public void setBPELProjectData(BPELProject bpelPrj, String key) {
        this.m_bpelPrj = bpelPrj;
        HashStructure mainHash = (HashStructure)bpelPrj.getProjectData("HashStructure");
        this.m_hashStructure = mainHash.getHashStructure(key);
    }

    @Override
    public String getShortLabel() {
        return this.m_hashStructure.getString(SERVICE_NAME_KEY);
    }

    @Override
    public Icon getIcon() {
        String iconName = this.m_hashStructure.getString(SERVICE_ICON_KEY);
        return ImageCache.getIcon(iconName);
    }

    @Override
    public List getListOfChildren() {
        List allowedList = this.getAllowedFilesList();
        ArrayList<URL> list = new ArrayList<URL>();
        if (allowedList != null) {
            for (int i = 0; i < allowedList.size(); ++i) {
                list.add(URLFactory.newURL((URL)this.m_bpelPrj.getBPELDirectoryURL(), (String)((String)allowedList.get(i))));
            }
        }
        return list;
    }

    @Override
    protected List getAllowedFilesList() {
        if (this.m_allowedList == null) {
            this.m_allowedList = new ArrayList();
            int i = 0;
            String file = null;
            do {
                String key;
                if ((file = this.m_hashStructure.getString(key = SERVICE_FILE_PREFIX_KEY + String.valueOf(i++))) == null) continue;
                this.m_allowedList.add(file);
            } while (file != null);
        }
        return this.m_allowedList;
    }
}

