/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.application;

import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLPrintDriver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PMProjectSettings
extends HashStructureAdapter {
    private static PMProjectSettings sProjectSettings = null;
    public static final String PM_SETTINGS_KEY = PMProjectSettings.class.getName();
    public static final String CONTENT_SET_LOCAL_KEY = "Integration_Content";
    public static final String CONTENT_SET_KEY = PM_SETTINGS_KEY + "/" + "Integration_Content";
    public static final String BPEL_PROCESS_NAME = "bpelprocess";
    public static final String CONTENTSET_NAME = BPELStringTranslator.getString("BPEL_MODELER_INT_CON_FOLDER");
    public static final String NAVIGABLE_NAME = BPELStringTranslator.getString("BPEL_MODELER_INT_CON_FOLDER");
    public static final String SCHEMA_NODE = BPELStringTranslator.getString("APPNAVIGATOR_SCHEMAS_TITLE");
    private static final String NAMESPACE = "Namespace";
    private static final String TEMPLATE = "Template";
    private static final String PROCESSNAME = "ProcessName";
    private static final String JPR_SUFFIX = ".jpr";
    private static final String JPR_BAK_SUFFIX = ".jpr.";
    private static final String BPEL_INF = "BPEL-INF";
    private static final String BUILD_XML = "build.xml";

    public ContentSet getContentSet() {
        return new ContentSet(this._hash.getOrCreateHashStructure(CONTENT_SET_LOCAL_KEY));
    }

    private PMProjectSettings(HashStructure hash) {
        super(hash);
    }

    public static File getProjectDirectory(Project project) {
        URL prjDir = URLFileSystem.getParent((URL)project.getURL());
        return new File(URLFileSystem.getPlatformPathName((URL)prjDir));
    }

    public static boolean isBPELProject(Project project) {
        File f = PMProjectSettings.getProjectDirectory(project);
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile() || !files[i].getName().endsWith(".bpel")) continue;
            return true;
        }
        return false;
    }

    public static void addToProject(Project project, Node pNode) {
    }

    private static boolean needsToBeMigrated(Project project) {
        if (project == null) {
            return false;
        }
        File base = new File(project.getBaseDirectory());
        String[] files = base.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".bpel")) continue;
                return true;
            }
        }
        return false;
    }

    private static void write(String pData, Writer pWriter) {
        if (pWriter != null) {
            try {
                pWriter.write(pData);
                pWriter.write("\n");
                pWriter.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void updateLibraries(Project project) {
        String JSP_RUNTIME = "JSP Runtime";
        String WORKFLOW = "BPM Workflow";
        String ORABPEL = "OraBPEL";
        String TOPLINK = "TopLink";
        JProjectLibraries jl = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] libraries = jl.getLibraries();
        if (libraries == null) {
            return;
        }
        for (int i = 0; i < libraries.length; ++i) {
            if ("OraBPEL".equals(libraries[i].getName())) {
                jl.removeLibrary(libraries[i].getID());
                jl.addLibrary((Object)"BPM Workflow", false);
                continue;
            }
            if ("JSP Runtime".equals(libraries[i].getName())) {
                jl.addLibrary((Object)"JSP Runtime", false);
                continue;
            }
            if (!"TopLink".equals(libraries[i].getName())) continue;
            jl.removeLibrary((Object)"TopLink");
            jl.addLibrary((Object)"TopLink", false);
        }
    }

    private static String getTemplatesDirectory() {
        String ideHome = Ide.getHomeDirectory();
        File file = new File(ideHome).getParentFile();
        file = new File(file, "integration");
        file = new File(file, "bpel");
        file = new File(file, "utilities");
        return file.getAbsolutePath();
    }

    private static void handleBuildFileModification(File pFile) throws Exception {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        URL url = URLFactory.newFileURL((File)pFile);
        parser.parse(url);
        XMLDocument document = parser.getDocument();
        NodeList list = document.getElementsByTagName("project");
        Element element = null;
        for (int i = 0; i < list.getLength(); ++i) {
            org.w3c.dom.Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            element = (Element)node;
        }
        element.setAttribute("basedir", "bpel");
        PMProjectSettings.save((Document)document, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(Document pDocument, URL pURL) {
        if (pDocument instanceof XMLDocument) {
            OutputStream outStream = null;
            try {
                outStream = URLFileSystem.openOutputStream((URL)pURL);
                XMLPrintDriver driver = new XMLPrintDriver(outStream);
                driver.setFormatPrettyPrint(true);
                driver.setEOLChars(System.getProperty("line.separator"));
                driver.setEncoding("UTF-8");
                driver.printDocument((XMLDocument)pDocument);
            }
            catch (Exception e) {
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private static boolean isBuildFile(File pFile) {
        return pFile.getName().equalsIgnoreCase(BUILD_XML);
    }

    private static boolean isBPEL_INF(File pFile) {
        return pFile.isDirectory() && pFile.getName().equals(BPEL_INF);
    }

    private static boolean isAProjectFile(File pFile) {
        return pFile.getName().endsWith(JPR_SUFFIX) || pFile.getName().indexOf(JPR_BAK_SUFFIX) != -1;
    }

    private static boolean isABPELProject(Project project) {
        return project.getProperty(NAMESPACE) != null && project.getProperty(TEMPLATE) != null && project.getProperty(PROCESSNAME) != null;
    }

    static class BPELFileFilter
    implements FileFilter,
    BuildFileGetter {
        File mBuildFile = null;

        BPELFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (!file.isDirectory()) {
                if (!PMProjectSettings.isAProjectFile(file)) {
                    if (PMProjectSettings.isBuildFile(file)) {
                        this.mBuildFile = file;
                    }
                    return true;
                }
            } else if (PMProjectSettings.isBPEL_INF(file)) {
                return true;
            }
            return false;
        }

        @Override
        public File getBuildFile() {
            return this.mBuildFile;
        }
    }

    static interface BuildFileGetter {
        public File getBuildFile();
    }
}

