/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oracle.tip.tools.ide.common.generator.instance.InstanceGenerator;
import oracle.tip.tools.ide.common.utils.MapUtils;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolver;
import oracle.tip.tools.ide.common.xsdgrammar.MapperNSResolverImpl;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestUtil {
    public static boolean generateXmlFile(URL wsdlURL, QName element, String xmlFile, int width, int depth) {
        XMLDocument[] elementSchemas = TestUtil.getElementSchemas(wsdlURL, element);
        try {
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            InstanceGenerator.generateInstance((XMLDocument[])elementSchemas, (URL)wsdlURL, (String)element.getNamespaceURI(), (String)element.getLocalPart(), (String)String.valueOf(width), (String)String.valueOf(depth), (Result)result);
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(xmlFile)));
            pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            pw.print(sw.toString());
            pw.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static XMLDocument[] getElementSchemas(URL wsdlURL, QName element) {
        List schemaElements = new ArrayList();
        try {
            schemaElements = MapUtils.getInlineSchemaElements((URL)wsdlURL, (QName)element, null, (MapperNSResolver)new MapperNSResolverImpl());
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLDocument[] schemaDocuments = new XMLDocument[schemaElements.size()];
        for (int i = 0; i < schemaElements.size(); ++i) {
            Element schemaElement = (Element)schemaElements.get(i);
            XMLDocument schemaDocument = new XMLDocument();
            Node newSchemaElement = schemaDocument.importNode((Node)schemaElement, true);
            schemaDocument.appendChild(newSchemaElement);
            schemaDocuments[i] = schemaDocument;
        }
        return schemaDocuments;
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName == null || fileName.trim().length() == 0) {
            return false;
        }
        if (new File(fileName).isFile()) {
            return true;
        }
        if (new File(fileName).isDirectory()) {
            return false;
        }
        try {
            if (new File(fileName).createNewFile()) {
                new File(fileName).delete();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

