/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestDialog;
import oracle.tip.tools.ide.pm.addin.adaptertest.SpringUtilities;

public class PreferencePanel
extends JPanel
implements ActionListener {
    private AdapterWSDLTestDialog testDialog;
    private AdapterWSDLTestContext testContext;
    private Properties endpointProperties;
    private JTable endpointPropertyTable;
    private JButton addButton;
    private JButton removeButton;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel depthLabel;
    private JTextField depthField;
    private JLabel timeoutDescLabel;
    private JLabel timeoutLabel;
    private JTextField timeoutField;
    private JLabel autoLayoutDescLabel;
    private JCheckBox autoLayoutCB;
    private TitledBorder endpointPropertyBorder;
    private TitledBorder documentGenerationBorder;
    private TitledBorder operationTimeoutBorder;
    private TitledBorder autoLayoutBorder;

    protected PreferencePanel(AdapterWSDLTestDialog testDialog) {
        this.testDialog = testDialog;
        this.testContext = testDialog.getTestContext();
        this.endpointProperties = this.testContext.getCurrentOperationTestContext().getEndpointProperties();
        this.initUI();
        this.setName(MessageBundleUtil.getString((String)"PREFERENCES_L"));
    }

    public Properties getEndpointProperties() {
        Properties endpointProperties = new Properties();
        TableModel tableModel = this.endpointPropertyTable.getModel();
        int tableRows = tableModel.getRowCount();
        for (int i = 0; i < tableRows; ++i) {
            String propertyName = (String)tableModel.getValueAt(i, 0);
            String propertyValue = (String)tableModel.getValueAt(i, 1);
            if (propertyName == null || propertyName.trim().length() <= 0) continue;
            endpointProperties.put(propertyName, propertyValue);
        }
        return endpointProperties;
    }

    public int getInputXmlGenerationWidth() {
        return Integer.parseInt(this.widthField.getText());
    }

    public int getInputXmlGenerationDepth() {
        return Integer.parseInt(this.depthField.getText());
    }

    public int getInboundOperationTimeout() {
        return Integer.parseInt(this.timeoutField.getText());
    }

    public boolean isAutoLayout() {
        return this.autoLayoutCB.isSelected();
    }

    public boolean validateInput() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        TableModel tableModel = this.endpointPropertyTable.getModel();
        int tableRows = tableModel.getRowCount();
        for (int i = 0; i < tableRows; ++i) {
            String endpointPropertyName = (String)tableModel.getValueAt(i, 0);
            String endpointPropertyValue = (String)tableModel.getValueAt(i, 1);
            if (endpointPropertyName != null && endpointPropertyName.trim().length() > 0 && (endpointPropertyValue == null || endpointPropertyValue.trim().length() == 0)) {
                String errorMessage = MessageBundleUtil.getString((String)"ENDPOINT_PROPERTY_VALUE_MISSING", (Object[])new String[]{endpointPropertyName});
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), errorMessage, MessageBundleUtil.getString((String)"INVALID_ENDPOINT_PROPERTY_T"), 0);
                return false;
            }
            if (endpointPropertyValue == null || endpointPropertyValue.trim().length() <= 0 || endpointPropertyName != null && endpointPropertyName.trim().length() != 0) continue;
            String errorMessage = MessageBundleUtil.getString((String)"ENDPOINT_PROPERTY_NAME_MISSING", (Object[])new String[]{endpointPropertyValue});
            JOptionPane.showMessageDialog((Component)((Object)this.testDialog), errorMessage, MessageBundleUtil.getString((String)"INVALID_ENDPOINT_PROPERTY_T"), 0);
            return false;
        }
        if (operationTestContext.hasInput()) {
            int width = 0;
            try {
                width = Integer.parseInt(this.widthField.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_NUMBER_OF_REPEATING_ELEMENTS"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
            if (width <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_NUMBER_OF_REPEATING_ELEMENTS"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
            int depth = 0;
            try {
                depth = Integer.parseInt(this.depthField.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_DEPTH_OF_OPTIONAL_ELEMENTS"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
            if (depth <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_DEPTH_OF_OPTIONAL_ELEMENTS"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
        }
        if (!operationTestContext.isOutbound()) {
            int timeout = 0;
            try {
                timeout = Integer.parseInt(this.timeoutField.getText());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_OPERATION_TIMEOUT"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
            if (timeout <= 0) {
                JOptionPane.showMessageDialog((Component)((Object)this.testDialog), MessageBundleUtil.getString((String)"SPECIFY_OPERATION_TIMEOUT"), MessageBundleUtil.getString((String)"INVALID_NUMBER_T"), 0);
                return false;
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.addButton) {
            this.addEndpointProperty();
        } else if (source == this.removeButton) {
            this.removeEndpointProperty();
        }
    }

    private void addEndpointProperty() {
        this.stopCurrentCellEditing();
        DefaultTableModel tableModel = (DefaultTableModel)this.endpointPropertyTable.getModel();
        tableModel.addRow(new String[]{"", ""});
        int rows = this.endpointPropertyTable.getRowCount();
        this.endpointPropertyTable.setRowSelectionInterval(rows - 1, rows - 1);
        this.endpointPropertyTable.changeSelection(rows - 1, 0, false, false);
        this.endpointPropertyTable.editCellAt(rows - 1, 0);
    }

    private void removeEndpointProperty() {
        this.stopCurrentCellEditing();
        int rows = this.endpointPropertyTable.getRowCount();
        int selectedRow = this.endpointPropertyTable.getSelectedRow();
        if (selectedRow >= 0) {
            DefaultTableModel tableModel = (DefaultTableModel)this.endpointPropertyTable.getModel();
            tableModel.removeRow(selectedRow);
            if (this.endpointPropertyTable.getRowCount() > 0) {
                if (selectedRow == rows - 1) {
                    this.endpointPropertyTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    this.endpointPropertyTable.changeSelection(selectedRow - 1, 0, false, false);
                } else {
                    this.endpointPropertyTable.setRowSelectionInterval(selectedRow, selectedRow);
                    this.endpointPropertyTable.changeSelection(selectedRow, 0, false, false);
                }
            }
        }
    }

    private void stopCurrentCellEditing() {
        int row = this.endpointPropertyTable.getSelectedRow();
        if (row >= 0) {
            this.endpointPropertyTable.getCellEditor(row, 0).cancelCellEditing();
            this.endpointPropertyTable.getCellEditor(row, 1).cancelCellEditing();
        }
    }

    private void initUI() {
        this.createUI();
        this.layoutUI();
        this.populateUI();
    }

    private void createUI() {
        DefaultTableModel tableModel = new DefaultTableModel(new String[]{MessageBundleUtil.getString((String)"NAME"), MessageBundleUtil.getString((String)"VALUE")}, 0);
        this.endpointPropertyTable = new JTable(tableModel);
        this.endpointPropertyTable.setRowHeight(20);
        this.addButton = new JButton(MessageBundleUtil.getString((String)"ADD"));
        this.addButton.setMnemonic('A');
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(MessageBundleUtil.getString((String)"REMOVE"));
        this.removeButton.setMnemonic('R');
        this.removeButton.addActionListener(this);
        this.widthLabel = new JLabel(MessageBundleUtil.getString((String)"NUMBER_OF_REPEATING_ELEMENTS_L") + ":");
        this.widthLabel.setDisplayedMnemonic('N');
        this.widthField = new JTextField();
        this.widthLabel.setLabelFor(this.widthField);
        this.depthLabel = new JLabel(MessageBundleUtil.getString((String)"DEPTH_OF_OPTIONAL_ELEMENTS_L") + ":");
        this.depthLabel.setDisplayedMnemonic('M');
        this.depthField = new JTextField();
        this.depthLabel.setLabelFor(this.depthField);
        this.timeoutDescLabel = new JLabel(MessageBundleUtil.getString((String)"OPERATION_TIMEOUT_DESC"));
        this.timeoutLabel = new JLabel(MessageBundleUtil.getString((String)"TIMEOUT_L") + ":");
        this.timeoutLabel.setDisplayedMnemonic('T');
        this.timeoutField = new JTextField();
        this.timeoutLabel.setLabelFor(this.timeoutField);
        this.autoLayoutDescLabel = new JLabel(MessageBundleUtil.getString((String)"AUTO_LAYOUT_INPUT_OUTPUT_DOCUMENT_DESC"));
        this.autoLayoutCB = new JCheckBox(MessageBundleUtil.getString((String)"AUTO_LAYOUT_L"));
        this.autoLayoutCB.setMnemonic('L');
    }

    private void layoutUI() {
        JPanel propertyPanel = new JPanel(new BorderLayout(5, 5));
        this.endpointPropertyBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"ENDPOINT_PROPERTIES_L"));
        propertyPanel.setBorder(this.endpointPropertyBorder);
        int tableWidth = 500;
        int tableHeight = 3 * this.endpointPropertyTable.getRowHeight();
        this.endpointPropertyTable.setPreferredScrollableViewportSize(new Dimension(tableWidth, tableHeight));
        JScrollPane propertyScrollPane = new JScrollPane(this.endpointPropertyTable);
        propertyPanel.add((Component)propertyScrollPane, "Center");
        JPanel actionPanel = new JPanel(new BorderLayout(5, 5));
        propertyPanel.add((Component)actionPanel, "East");
        JPanel buttonPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        actionPanel.add((Component)buttonPanel, "North");
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        JPanel xmlGenerationPanel = new JPanel(new SpringLayout());
        this.documentGenerationBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"INPUT_DOCUMENT_GENERATION_L"));
        xmlGenerationPanel.setBorder(this.documentGenerationBorder);
        xmlGenerationPanel.add(this.widthLabel);
        xmlGenerationPanel.add(this.widthField);
        xmlGenerationPanel.add(this.depthLabel);
        xmlGenerationPanel.add(this.depthField);
        SpringUtilities.makeCompactGrid(xmlGenerationPanel, 2, 2, 5, 5, 5, 5);
        JPanel operationTimeoutPanel = new JPanel(new BorderLayout(5, 5));
        this.operationTimeoutBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"OPERATION_TIMEOUT_L"));
        operationTimeoutPanel.setBorder(this.operationTimeoutBorder);
        operationTimeoutPanel.add((Component)this.timeoutDescLabel, "North");
        JPanel timeoutPanel = new JPanel(new BorderLayout(5, 5));
        operationTimeoutPanel.add((Component)timeoutPanel, "South");
        timeoutPanel.add((Component)this.timeoutLabel, "West");
        timeoutPanel.add((Component)this.timeoutField, "Center");
        JPanel autoLayoutPanel = new JPanel(new GridLayout(2, 1, 5, 5));
        this.autoLayoutBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"AUTO_LAYOUT_INPUT_OUTPUT_DOCUMENT_L"));
        autoLayoutPanel.setBorder(this.autoLayoutBorder);
        autoLayoutPanel.add(this.autoLayoutDescLabel);
        autoLayoutPanel.add(this.autoLayoutCB);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)propertyPanel, "Center");
        JPanel southPanel = new JPanel(new GridLayout(3, 1, 10, 10));
        this.add((Component)southPanel, "South");
        southPanel.add(xmlGenerationPanel);
        southPanel.add(operationTimeoutPanel);
        southPanel.add(autoLayoutPanel);
    }

    private void populateUI() {
        boolean isInbound;
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        DefaultTableModel tableModel = (DefaultTableModel)this.endpointPropertyTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        Enumeration<?> propertyNames = this.endpointProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String propertyValue = this.endpointProperties.getProperty(propertyName);
            tableModel.addRow(new String[]{propertyName, propertyValue});
        }
        this.widthField.setText(String.valueOf(operationTestContext.getInputXmlGenerationWidth()));
        this.depthField.setText(String.valueOf(operationTestContext.getInputXmlGenerationDepth()));
        this.timeoutField.setText(String.valueOf(operationTestContext.getInboundOperationTimeout()));
        this.autoLayoutCB.setSelected(operationTestContext.isAutoLayout());
        Color enabledTitleColor = this.endpointPropertyBorder.getTitleColor();
        Color disabledTitleColor = Color.LIGHT_GRAY;
        boolean hasInput = operationTestContext.hasInput();
        if (hasInput) {
            this.documentGenerationBorder.setTitleColor(enabledTitleColor);
        } else {
            this.documentGenerationBorder.setTitleColor(disabledTitleColor);
        }
        this.widthLabel.setEnabled(hasInput);
        this.widthField.setEnabled(hasInput);
        this.depthLabel.setEnabled(hasInput);
        this.depthField.setEnabled(hasInput);
        boolean bl = isInbound = !operationTestContext.isOutbound();
        if (isInbound) {
            this.operationTimeoutBorder.setTitleColor(enabledTitleColor);
        } else {
            this.operationTimeoutBorder.setTitleColor(disabledTitleColor);
        }
        this.timeoutLabel.setEnabled(isInbound);
        this.timeoutField.setEnabled(isInbound);
    }

    private void updateUIStatus() {
    }

    public void refreshUI() {
        this.populateUI();
    }
}

