/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestDialog;
import oracle.tip.tools.ide.pm.addin.adaptertest.SpringUtilities;

public abstract class ParameterPanel
extends JPanel {
    private AdapterWSDLTestDialog testDialog = null;
    private AdapterWSDLTestContext testContext = null;
    private int parameterType = 1;
    public static final int CONNECTION_PARAMETER = 1;
    public static final int OPERATION_PARAMETER = 2;
    private Properties parameters = null;
    private List components = new ArrayList();

    protected ParameterPanel(AdapterWSDLTestDialog testDialog, int parameterType) {
        this.testDialog = testDialog;
        this.parameterType = parameterType;
        this.testContext = testDialog.getTestContext();
        this.parameters = parameterType == 1 ? this.testContext.getCurrentOperationTestContext().getConnectionParameters() : this.testContext.getCurrentOperationTestContext().getOperationParameters();
        this.initUI();
    }

    public Properties getParameters() {
        Properties parameters = new Properties();
        for (int i = 0; i < this.components.size(); ++i) {
            if (i % 2 != 1) continue;
            JTextField parameterField = (JTextField)this.components.get(i);
            String parameterName = parameterField.getName();
            String parameterValue = parameterField.getText();
            parameters.put(parameterName, parameterValue);
        }
        return parameters;
    }

    public boolean validateInput() {
        Properties parameters = this.getParameters();
        Enumeration<?> parameterNames = parameters.propertyNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = parameters.getProperty(parameterName);
        }
        return true;
    }

    private void initUI() {
        this.createUI();
        this.layoutUI();
        this.populateUI();
    }

    private void createUI() {
        Enumeration<?> parameterNames = this.parameters.propertyNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = this.parameters.getProperty(parameterName);
            JLabel parameterLabel = new JLabel(parameterName + ":");
            parameterLabel.setHorizontalAlignment(4);
            JTextField parameterField = new JTextField(parameterValue);
            parameterLabel.setLabelFor(parameterField);
            parameterField.setName(parameterName);
            this.components.add(parameterLabel);
            this.components.add(parameterField);
        }
    }

    private void layoutUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel paramPanel = new JPanel(new SpringLayout());
        for (int i = 0; i < this.components.size(); ++i) {
            paramPanel.add((JComponent)this.components.get(i));
        }
        SpringUtilities.makeCompactGrid(paramPanel, this.components.size() / 2, 2, 5, 5, 5, 5);
        JPanel paramScrolledPanel = new JPanel(new BorderLayout());
        paramScrolledPanel.add((Component)paramPanel, "North");
        JScrollPane paramScrollPane = new JScrollPane(paramScrolledPanel);
        paramScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)paramScrollPane, "Center");
    }

    private void populateUI() {
    }

    private void updateUIStatus() {
    }

    public void refreshUI() {
        this.removeAll();
        this.components = new ArrayList();
        this.parameters = this.parameterType == 1 ? this.testContext.getCurrentOperationTestContext().getConnectionParameters() : this.testContext.getCurrentOperationTestContext().getOperationParameters();
        this.initUI();
    }
}

