/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestDialog;

public class OperationPanel
extends JPanel
implements ActionListener {
    private AdapterWSDLTestDialog testDialog = null;
    private AdapterWSDLTestContext testContext = null;
    private JLabel operationLabel = null;
    private JComboBox operationCBB = null;

    public OperationPanel(AdapterWSDLTestDialog testDialog) {
        this.testDialog = testDialog;
        this.testContext = testDialog.getTestContext();
        this.initUI();
        this.setName(MessageBundleUtil.getString((String)"OPERATION_L"));
    }

    public String getOperation() {
        return this.testContext.getCurrentOperation();
    }

    public boolean validateInput() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.operationCBB) {
            String operation = (String)this.operationCBB.getSelectedItem();
            this.testContext.setCurrentOperation(operation);
            this.testDialog.refreshUI();
        }
        this.updateUIStatus();
    }

    private void initUI() {
        this.createUI();
        this.layoutUI();
        this.populateUI();
    }

    private void createUI() {
        this.operationLabel = new JLabel(MessageBundleUtil.getString((String)"SELECT_OPERATION_L") + ":");
        this.operationLabel.setDisplayedMnemonic('S');
        this.operationCBB = new JComboBox<String>(this.testContext.getOperations());
        this.operationLabel.setLabelFor(this.operationCBB);
    }

    private void layoutUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(10, 10));
        JPanel operationPanel = new JPanel(new BorderLayout(5, 5));
        this.add((Component)operationPanel, "North");
        operationPanel.add((Component)this.operationLabel, "West");
        operationPanel.add((Component)this.operationCBB, "Center");
    }

    private void populateUI() {
        this.operationCBB.setSelectedItem(this.testContext.getCurrentOperation());
        this.operationCBB.setEditable(false);
        this.operationCBB.addActionListener(this);
    }

    private void updateUIStatus() {
    }
}

