/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;

public class FileSpecifyPanel
extends JPanel
implements ActionListener {
    private Context context;
    private JLabel fileNameLabel;
    private JTextField fileNameField;
    private JButton fileBrowseButton;
    private String defaultFileName = null;
    private String defaultFileExt = null;
    private URLFilter fileFilter = null;
    private static final String XML_EXT = ".xml";

    public FileSpecifyPanel(Context context) {
        this.context = context;
        Project project = context.getProject();
        URL projectURL = project.getURL();
        URL projectDirURL = URLFileSystem.getParent((URL)projectURL);
        String projectDirectoryName = new File(projectDirURL.getFile()).toString();
        this.defaultFileName = new File(projectDirectoryName, MessageBundleUtil.getString((String)"DEFAULT_FILE_NAME")).toString();
        this.defaultFileExt = XML_EXT;
        this.fileFilter = new DefaultURLFilter(MessageBundleUtil.getString((String)"XSL_FILE_L"), new String[]{".xsl", ".xslt"});
        this.init();
    }

    public String getFileName() {
        String fileName = this.fileNameField.getText();
        if (fileName == null || fileName.trim().length() == 0) {
            return null;
        }
        if (!fileName.endsWith(this.defaultFileExt)) {
            fileName = fileName + this.defaultFileExt;
        }
        return fileName;
    }

    public void setDefaultFileName(String defaultFileName) {
        this.defaultFileName = defaultFileName;
        this.fileNameField.setText(defaultFileName + this.defaultFileExt);
    }

    public void setDefaultFileExt(String defaultFileExt) {
        this.defaultFileExt = defaultFileExt;
        this.fileNameField.setText(this.defaultFileName + defaultFileExt);
    }

    public void setFileFilter(URLFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public void setFileLabel(String fileLabel) {
        this.fileNameLabel.setText(fileLabel + ":");
    }

    public void setFileLabelMnemonic(char c) {
        this.fileNameLabel.setDisplayedMnemonic(c);
    }

    public void setFileBrowseButtonMnemonic(char c) {
        this.fileBrowseButton.setMnemonic(c);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.fileBrowseButton) {
            URLChooser urlChooser = DialogUtil.newURLChooser((Context)this.context);
            urlChooser.setSelectionScope(0);
            urlChooser.setURLFilter(this.fileFilter);
            urlChooser.setSelectedURL(URLFactory.newFileURL((String)this.getFileName()));
            int ret = urlChooser.showOpenDialog((Component)this);
            if (ret == 0) {
                URL fileURL = urlChooser.getSelectedURL();
                String fileName = new File(fileURL.getFile()).toString();
                this.fileNameField.setText(fileName);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fileNameField.setEnabled(enabled);
        this.fileBrowseButton.setEnabled(enabled);
    }

    private void init() {
        this.setLayout(new GridLayout(2, 1, 5, 3));
        this.fileNameLabel = new JLabel(MessageBundleUtil.getString((String)"FILE_NAME_L") + ":");
        this.fileNameLabel.setDisplayedMnemonic('F');
        JPanel fileNamePanel = new JPanel(new BorderLayout(10, 10));
        this.fileNameField = new JTextField();
        this.fileNameField.setText(this.defaultFileName + this.defaultFileExt);
        this.fileNameLabel.setLabelFor(this.fileNameField);
        String browseStr = MessageBundleUtil.getString((String)"BROWSE");
        this.fileBrowseButton = new JButton(StringUtils.stripMnemonic((String)browseStr) + "...");
        this.fileBrowseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseStr));
        this.fileBrowseButton.addActionListener(this);
        fileNamePanel.add((Component)this.fileNameField, "Center");
        fileNamePanel.add((Component)this.fileBrowseButton, "East");
        this.add(this.fileNameLabel);
        this.add(fileNamePanel);
    }
}

