/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.xml.namespace.QName;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.validation.XSDValidationService;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestDialog;
import oracle.tip.tools.ide.pm.addin.adaptertest.FileSpecifyPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.TestUtil;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;

public abstract class DocumentPanel
extends JPanel {
    private AdapterWSDLTestDialog testDialog = null;
    private AdapterWSDLTestContext testContext = null;
    private int documentType = 1;
    public static final int INPUT_DOCUMENT = 1;
    public static final int OUTPUT_DOCUMENT = 2;
    private JPanel headerPanel = null;
    private FileSpecifyPanel specifyHeaderPanel = null;
    private JCheckBox generateHeaderCB = null;
    private JCheckBox showHeaderCB = null;
    private FileSpecifyPanel specifyPayloadPanel = null;
    private JCheckBox generatePayloadCB = null;
    private JCheckBox showPayloadCB = null;

    protected DocumentPanel(AdapterWSDLTestDialog testDialog, int documentType) {
        this.testDialog = testDialog;
        this.documentType = documentType;
        this.testContext = testDialog.getTestContext();
        this.initUI();
    }

    public String getHeaderXmlFile() {
        return this.specifyHeaderPanel.getFileName();
    }

    public boolean isGenerateHeaderXmlFile() {
        return this.generateHeaderCB.isSelected();
    }

    public boolean isShowHeaderXmlFile() {
        return this.showHeaderCB.isSelected();
    }

    public String getPayloadXmlFile() {
        return this.specifyPayloadPanel.getFileName();
    }

    public boolean isGeneratePayloadXmlFile() {
        return this.generatePayloadCB.isSelected();
    }

    public boolean isShowPayloadXmlFile() {
        return this.showPayloadCB.isSelected();
    }

    private void initUI() {
        this.createUI();
        this.layoutUI();
        this.populateUI();
    }

    private void createUI() {
        this.specifyHeaderPanel = new FileSpecifyPanel(this.testDialog.getContext());
        this.specifyHeaderPanel.setFileLabel(MessageBundleUtil.getString((String)"HEADER_XML_FILE_L"));
        this.specifyHeaderPanel.setFileLabelMnemonic('E');
        this.specifyHeaderPanel.setFileBrowseButtonMnemonic('B');
        this.specifyHeaderPanel.setDefaultFileExt(".xml");
        this.specifyHeaderPanel.setFileFilter((URLFilter)new DefaultURLFilter(MessageBundleUtil.getString((String)"XML_FILE_L"), ".xml"));
        this.generateHeaderCB = new JCheckBox(MessageBundleUtil.getString((String)"GENERATE_HEADER_XML_FILE_L"));
        this.generateHeaderCB.setMnemonic('G');
        if (this.documentType == 2) {
            this.generateHeaderCB.setVisible(false);
        }
        this.showHeaderCB = new JCheckBox(MessageBundleUtil.getString((String)"SHOW_HEADER_XML_FILE_L"));
        this.showHeaderCB.setMnemonic('S');
        this.specifyPayloadPanel = new FileSpecifyPanel(this.testDialog.getContext());
        this.specifyPayloadPanel.setFileLabel(MessageBundleUtil.getString((String)"PAYLOAD_XML_FILE_L"));
        this.specifyPayloadPanel.setFileLabelMnemonic('P');
        this.specifyPayloadPanel.setFileBrowseButtonMnemonic('R');
        this.specifyPayloadPanel.setDefaultFileExt(".xml");
        this.specifyPayloadPanel.setFileFilter((URLFilter)new DefaultURLFilter(MessageBundleUtil.getString((String)"XML_FILE_L"), ".xml"));
        this.generatePayloadCB = new JCheckBox(MessageBundleUtil.getString((String)"GENERATE_PAYLOAD_XML_FILE_L"));
        this.generatePayloadCB.setMnemonic('N');
        if (this.documentType == 2) {
            this.generatePayloadCB.setVisible(false);
        }
        this.showPayloadCB = new JCheckBox(MessageBundleUtil.getString((String)"SHOW_PAYLOAD_XML_FILE_L"));
        this.showPayloadCB.setMnemonic('O');
    }

    private void layoutUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout(10, 10));
        JPanel headerPayloadPanel = new JPanel(new BorderLayout(10, 10));
        this.add((Component)headerPayloadPanel, "North");
        this.headerPanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"HEADER_DOCUMENT"));
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder headerBorder = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
        this.headerPanel.setBorder(headerBorder);
        headerPayloadPanel.add((Component)this.headerPanel, "North");
        this.headerPanel.add((Component)this.specifyHeaderPanel, "North");
        JPanel headerCheckBoxPanel = new JPanel(new GridLayout(2, 1));
        headerCheckBoxPanel.add(this.generateHeaderCB);
        headerCheckBoxPanel.add(this.showHeaderCB);
        this.headerPanel.add((Component)headerCheckBoxPanel, "South");
        JPanel payloadPanel = new JPanel(new BorderLayout(5, 5));
        titledBorder = BorderFactory.createTitledBorder(MessageBundleUtil.getString((String)"PAYLOAD_DOCUMENT"));
        CompoundBorder payloadBorder = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
        payloadPanel.setBorder(payloadBorder);
        headerPayloadPanel.add((Component)payloadPanel, "South");
        payloadPanel.add((Component)this.specifyPayloadPanel, "North");
        JPanel payloadCheckBoxPanel = new JPanel(new GridLayout(2, 1));
        payloadCheckBoxPanel.add(this.generatePayloadCB);
        payloadCheckBoxPanel.add(this.showPayloadCB);
        payloadPanel.add((Component)payloadCheckBoxPanel, "South");
    }

    private void populateUI() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        String headerXMLFile = null;
        boolean generateHeader = true;
        boolean showHeader = true;
        boolean hasHeader = true;
        if (this.documentType == 1) {
            headerXMLFile = operationTestContext.getInputHeaderXmlFile();
            generateHeader = operationTestContext.isGenerateInputHeaderXmlFile();
            showHeader = operationTestContext.isShowInputHeaderXmlFile();
            hasHeader = operationTestContext.hasInputHeader();
        } else {
            headerXMLFile = operationTestContext.getOutputHeaderXmlFile();
            showHeader = operationTestContext.isShowOutputHeaderXmlFile();
            hasHeader = operationTestContext.hasOutputHeader();
        }
        int idx = headerXMLFile.lastIndexOf(".xml");
        String fileName = headerXMLFile.substring(0, idx);
        this.specifyHeaderPanel.setDefaultFileName(fileName);
        this.generateHeaderCB.setSelected(generateHeader);
        this.showHeaderCB.setSelected(showHeader);
        this.headerPanel.setVisible(hasHeader);
        String payloadXMLFile = null;
        boolean generatePayload = true;
        boolean showPayload = true;
        if (this.documentType == 1) {
            payloadXMLFile = operationTestContext.getInputPayloadXmlFile();
            generatePayload = operationTestContext.isGenerateInputPayloadXmlFile();
            showPayload = operationTestContext.isShowInputPayloadXmlFile();
        } else {
            payloadXMLFile = operationTestContext.getOutputPayloadXmlFile();
            showPayload = operationTestContext.isShowOutputPayloadXmlFile();
        }
        idx = payloadXMLFile.lastIndexOf(".xml");
        fileName = payloadXMLFile.substring(0, idx);
        this.specifyPayloadPanel.setDefaultFileName(fileName);
        this.generatePayloadCB.setSelected(generatePayload);
        this.showPayloadCB.setSelected(showPayload);
    }

    private void updateUIStatus() {
    }

    public void refreshUI() {
        this.populateUI();
    }

    public boolean validateInput() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        boolean hasHeader = this.documentType == 1 ? operationTestContext.hasInputHeader() : operationTestContext.hasOutputHeader();
        return (!hasHeader || this.validateHeaderDocument()) && this.validatePayloadDocument();
    }

    private boolean validateHeaderDocument() {
        String headerXMLFile = this.specifyHeaderPanel.getFileName();
        if (!TestUtil.isValidFileName(headerXMLFile)) {
            String errorMessage = null;
            errorMessage = this.documentType == 1 ? MessageBundleUtil.getString((String)"SPECIFY_VALID_INPUT_HEADER_XML_FILE_NAME") : MessageBundleUtil.getString((String)"SPECIFY_VALID_OUTPUT_HEADER_XML_FILE_NAME");
            JOptionPane.showMessageDialog((Component)((Object)this.testDialog), errorMessage, MessageBundleUtil.getString((String)"FILE_NAME_INVALID_T"), 0);
            return false;
        }
        if (this.documentType == 1) {
            if (this.generateHeaderCB.isSelected()) {
                if (new File(headerXMLFile).exists() || NodeFactory.find((URL)URLFactory.newFileURL((String)headerXMLFile)) != null) {
                    int option = JOptionPane.showConfirmDialog(this, MessageBundleUtil.getString((String)"INPUT_HEADER_XML_FILE_ALREADY_EXIST", (Object[])new Object[]{headerXMLFile}) + "\n" + MessageBundleUtil.getString((String)"OVERWRITE?"), MessageBundleUtil.getString((String)"FILE_ALREADY_EXIST_T"), 0, 2);
                    if (option != 0) {
                        return false;
                    }
                    new File(headerXMLFile).delete();
                }
            } else if (!new File(headerXMLFile).exists()) {
                JOptionPane.showMessageDialog(this, MessageBundleUtil.getString((String)"INPUT_HEADER_XML_FILE_NOT_EXIST", (Object[])new Object[]{headerXMLFile}), MessageBundleUtil.getString((String)"FILE_NOT_EXIST_T"), 0);
                return false;
            }
        } else if (new File(headerXMLFile).exists() || NodeFactory.find((URL)URLFactory.newFileURL((String)headerXMLFile)) != null) {
            int option = JOptionPane.showConfirmDialog(this, MessageBundleUtil.getString((String)"OUTPUT_HEADER_XML_FILE_ALREADY_EXIST", (Object[])new Object[]{headerXMLFile}) + "\n" + MessageBundleUtil.getString((String)"OVERWRITE?"), MessageBundleUtil.getString((String)"FILE_ALREADY_EXIST_T"), 0, 2);
            if (option != 0) {
                return false;
            }
            new File(headerXMLFile).delete();
        }
        return true;
    }

    private boolean validateInputHeaderXML(String inputHeaderXMLFile) {
        QName inputHeaderElement = this.testContext.getCurrentOperationTestContext().getInputHeaderElement();
        XMLDocument[] inputHeaderSchemas = TestUtil.getElementSchemas(this.testContext.getWSDLURL(), inputHeaderElement);
        URL schemaBaseURL = this.testContext.getWSDLURL();
        FileInputStream inputHeaderXMLIS = null;
        try {
            inputHeaderXMLIS = new FileInputStream(inputHeaderXMLFile);
        }
        catch (Exception e) {
            return false;
        }
        try {
            return XSDValidationService.validate((XMLDocument[])inputHeaderSchemas, (URL)schemaBaseURL, (InputStream)inputHeaderXMLIS);
        }
        catch (XMLParseException ex) {
            return false;
        }
    }

    private boolean validatePayloadDocument() {
        String payloadXMLFile = this.specifyPayloadPanel.getFileName();
        if (!TestUtil.isValidFileName(payloadXMLFile)) {
            String errorMessage = null;
            errorMessage = this.documentType == 1 ? MessageBundleUtil.getString((String)"SPECIFY_VALID_INPUT_PAYLOAD_XML_FILE_NAME") : MessageBundleUtil.getString((String)"SPECIFY_VALID_OUTPUT_PAYLOAD_XML_FILE_NAME");
            JOptionPane.showMessageDialog((Component)((Object)this.testDialog), errorMessage, MessageBundleUtil.getString((String)"FILE_NAME_INVALID_T"), 0);
            return false;
        }
        if (this.documentType == 1) {
            if (this.generatePayloadCB.isSelected()) {
                if (new File(payloadXMLFile).exists() || NodeFactory.find((URL)URLFactory.newFileURL((String)payloadXMLFile)) != null) {
                    int option = JOptionPane.showConfirmDialog(this, MessageBundleUtil.getString((String)"INPUT_PAYLOAD_XML_FILE_ALREADY_EXIST", (Object[])new Object[]{payloadXMLFile}) + "\n" + MessageBundleUtil.getString((String)"OVERWRITE?"), MessageBundleUtil.getString((String)"FILE_ALREADY_EXIST_T"), 0, 2);
                    if (option != 0) {
                        return false;
                    }
                    new File(payloadXMLFile).delete();
                }
            } else if (!new File(payloadXMLFile).exists()) {
                JOptionPane.showMessageDialog(this, MessageBundleUtil.getString((String)"INPUT_PAYLOAD_XML_FILE_NOT_EXIST", (Object[])new Object[]{payloadXMLFile}), MessageBundleUtil.getString((String)"FILE_NOT_EXIST_T"), 0);
                return false;
            }
        } else if (new File(payloadXMLFile).exists() || NodeFactory.find((URL)URLFactory.newFileURL((String)payloadXMLFile)) != null) {
            int option = JOptionPane.showConfirmDialog(this, MessageBundleUtil.getString((String)"OUTPUT_PAYLOAD_XML_FILE_ALREADY_EXIST", (Object[])new Object[]{payloadXMLFile}) + "\n" + MessageBundleUtil.getString((String)"OVERWRITE?"), MessageBundleUtil.getString((String)"FILE_ALREADY_EXIST_T"), 0, 2);
            if (option != 0) {
                return false;
            }
            new File(payloadXMLFile).delete();
        }
        return true;
    }

    private boolean validateInputPayloadXML(String inputPayloadXMLFile) {
        QName inputPayloadElement = this.testContext.getCurrentOperationTestContext().getInputPayloadElement();
        XMLDocument[] inputPayloadSchemas = TestUtil.getElementSchemas(this.testContext.getWSDLURL(), inputPayloadElement);
        URL schemaBaseURL = this.testContext.getWSDLURL();
        FileInputStream inputPayloadXMLIS = null;
        try {
            inputPayloadXMLIS = new FileInputStream(inputPayloadXMLFile);
        }
        catch (Exception e) {
            return false;
        }
        try {
            return XSDValidationService.validate((XMLDocument[])inputPayloadSchemas, (URL)schemaBaseURL, (InputStream)inputPayloadXMLIS);
        }
        catch (XMLParseException ex) {
            return false;
        }
    }
}

