/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.webservices.ide.WSDLArtifactNode;
import oracle.tip.adapter.api.test.JcaWsdlTestExecutor;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestDialog;
import oracle.tip.tools.ide.pm.addin.adaptertest.TestUtil;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdapterWSDLTester {
    private Context context = null;
    private WSDLArtifactNode wsdlNode = null;
    private AdapterWSDLTestContext testContext = null;
    private AdapterWSDLTestContext.OperationTestContext operationTestContext = null;
    private static final int INPUT_HEADER = 1;
    private static final int INPUT_PAYLOAD = 2;
    private static final int OUTPUT_HEADER = 3;
    private static final int OUTPUT_PAYLOAD = 4;

    public AdapterWSDLTester(Context context) {
        this.context = context;
        this.wsdlNode = (WSDLArtifactNode)context.getNode();
        this.testContext = AdapterWSDLTestContext.getTestContext(context, this.wsdlNode.getURL());
    }

    public void test() {
        AdapterWSDLTestDialog testDialog = new AdapterWSDLTestDialog((JFrame)Ide.getMainWindow(), this.context, this.testContext);
        if (!WizardLauncher.runDialog((JDialog)((Object)testDialog))) {
            return;
        }
        this.operationTestContext = testDialog.getOperationTestContext();
        this.doTest();
        this.operationTestContext.setGenerateInputHeaderXmlFile(false);
        this.operationTestContext.setGenerateInputPayloadXmlFile(false);
        this.operationTestContext.setAutoLayout(false);
    }

    private void doTest() {
        if (this.operationTestContext.hasInput()) {
            if (this.operationTestContext.hasInputHeader() && this.operationTestContext.isGenerateInputHeaderXmlFile() && !this.generateInputHeader()) {
                return;
            }
            if (this.operationTestContext.isGenerateInputPayloadXmlFile() && !this.generateInputPayload()) {
                return;
            }
            if (this.operationTestContext.isShowInputPayloadXmlFile()) {
                this.openInputPayload();
            } else {
                this.closeInputPayload();
            }
            if (this.operationTestContext.hasInputHeader()) {
                if (this.operationTestContext.isShowInputHeaderXmlFile()) {
                    this.openInputHeader();
                } else {
                    this.closeInputHeader();
                }
            }
        }
        this.testOperation();
        if (this.operationTestContext.hasOutput()) {
            if (this.operationTestContext.isShowOutputPayloadXmlFile()) {
                this.openOutputPayload();
            } else {
                this.closeOutputPayload();
            }
            if (this.operationTestContext.hasOutputHeader()) {
                if (this.operationTestContext.isShowOutputHeaderXmlFile()) {
                    this.openOutputHeader();
                } else {
                    this.closeOutputHeader();
                }
            }
        }
    }

    private boolean generateInputHeader() {
        if (!TestUtil.generateXmlFile(this.testContext.getWSDLURL(), this.operationTestContext.getInputHeaderElement(), this.operationTestContext.getInputHeaderXmlFile(), this.operationTestContext.getInputXmlGenerationWidth(), this.operationTestContext.getInputXmlGenerationDepth())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageBundleUtil.getString((String)"GENERATE_INPUT_HEADER_XML_FAILED"), MessageBundleUtil.getString((String)"ERROR"), 0);
            return false;
        }
        return true;
    }

    private boolean generateInputPayload() {
        if (!TestUtil.generateXmlFile(this.testContext.getWSDLURL(), this.operationTestContext.getInputPayloadElement(), this.operationTestContext.getInputPayloadXmlFile(), this.operationTestContext.getInputXmlGenerationWidth(), this.operationTestContext.getInputXmlGenerationDepth())) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageBundleUtil.getString((String)"GENERATE_INPUT_PAYLOAD_XML_FAILED"), MessageBundleUtil.getString((String)"ERROR"), 0);
            return false;
        }
        return true;
    }

    private void openInputHeader() {
        this.openXmlFile(1);
    }

    private void openInputPayload() {
        this.openXmlFile(2);
    }

    private void openOutputHeader() {
        this.openXmlFile(3);
    }

    private void openOutputPayload() {
        this.openXmlFile(4);
    }

    private void openXmlFile(int xmlFileType) {
        if (this.operationTestContext.isAutoLayout()) {
            this.openXmlFileWithLayout(xmlFileType);
        } else {
            this.openXmlFileWithoutLayout(xmlFileType);
        }
    }

    private void openXmlFileWithLayout(int xmlFileType) {
        String xmlFile = this.getXmlFile(xmlFileType);
        Context xmlContext = Context.newIdeContext();
        XMLSourceNode xmlNode = AdapterWSDLTester.getXmlNode(xmlFile, true);
        xmlContext.setNode((Node)xmlNode);
        EditorManager editorManager = EditorManager.getEditorManager();
        editorManager.closeEditors(editorManager.findEditors(xmlContext));
        EditorPath inputHeaderEditorPath = this.getXmlEditorPath(1);
        EditorPath inputPayloadEditorPath = this.getXmlEditorPath(2);
        EditorPath outputHeaderEditorPath = this.getXmlEditorPath(3);
        EditorPath outputPayloadEditorPath = this.getXmlEditorPath(4);
        EditorPath anyOtherEditorPath = this.getAnyOtherEditorPath();
        OpenEditorOptions xmlEditorOptions = new OpenEditorOptions();
        xmlEditorOptions.setContext(xmlContext);
        xmlEditorOptions.setFlags(3);
        switch (xmlFileType) {
            case 1: {
                if (inputPayloadEditorPath != null) {
                    xmlEditorOptions.setPosition(inputPayloadEditorPath, 2);
                    break;
                }
                if (anyOtherEditorPath == null) break;
                xmlEditorOptions.setPosition(anyOtherEditorPath, 2);
                break;
            }
            case 2: {
                if (anyOtherEditorPath == null) break;
                xmlEditorOptions.setPosition(anyOtherEditorPath, 2);
                break;
            }
            case 3: {
                if (inputHeaderEditorPath != null) {
                    xmlEditorOptions.setPosition(inputHeaderEditorPath, 1);
                    break;
                }
                if (inputPayloadEditorPath != null) {
                    xmlEditorOptions.setPosition(inputPayloadEditorPath, 1);
                    break;
                }
                if (outputPayloadEditorPath != null) {
                    xmlEditorOptions.setPosition(outputPayloadEditorPath, 2);
                    break;
                }
                if (anyOtherEditorPath == null) break;
                xmlEditorOptions.setPosition(anyOtherEditorPath, 2);
                break;
            }
            case 4: {
                if (inputPayloadEditorPath != null) {
                    xmlEditorOptions.setPosition(inputPayloadEditorPath, 1);
                    break;
                }
                if (inputHeaderEditorPath != null) {
                    xmlEditorOptions.setPosition(inputHeaderEditorPath, 1);
                    break;
                }
                if (anyOtherEditorPath == null) break;
                xmlEditorOptions.setPosition(anyOtherEditorPath, 2);
            }
        }
        editorManager.openEditor(xmlEditorOptions);
    }

    private void openXmlFileWithoutLayout(int xmlFileType) {
        String xmlFile = this.getXmlFile(xmlFileType);
        EditorManager.getEditorManager().openDefaultEditorInFrame(URLFactory.newFileURL((String)xmlFile));
        boolean needRefresh = true;
        if (xmlFileType == 1) {
            needRefresh = this.operationTestContext.isGenerateInputHeaderXmlFile();
        }
        if (xmlFileType == 2) {
            needRefresh = this.operationTestContext.isGenerateInputPayloadXmlFile();
        }
        if (needRefresh) {
            RevertNodeCommand.reload((Node)AdapterWSDLTester.getXmlNode(xmlFile, true));
        }
    }

    private String getXmlFile(int xmlFileType) {
        String xmlFile = null;
        switch (xmlFileType) {
            case 1: {
                xmlFile = this.operationTestContext.getInputHeaderXmlFile();
                break;
            }
            case 2: {
                xmlFile = this.operationTestContext.getInputPayloadXmlFile();
                break;
            }
            case 3: {
                xmlFile = this.operationTestContext.getOutputHeaderXmlFile();
                break;
            }
            case 4: {
                xmlFile = this.operationTestContext.getOutputPayloadXmlFile();
            }
        }
        return xmlFile;
    }

    private static XMLSourceNode getXmlNode(String xmlFile, boolean create) {
        XMLSourceNode xmlNode = null;
        try {
            xmlNode = create ? (XMLSourceNode)NodeFactory.findOrCreate(XMLSourceNode.class, (URL)URLFactory.newFileURL((String)xmlFile)) : (XMLSourceNode)NodeFactory.find((URL)URLFactory.newFileURL((String)xmlFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmlNode;
    }

    private EditorPath getXmlEditorPath(int xmlFileType) {
        String xmlFile = this.getXmlFile(xmlFileType);
        EditorManager editorManager = EditorManager.getEditorManager();
        List editors = editorManager.getAllEditors();
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = (Editor)editors.get(i);
            Node node = editor.getContext().getNode();
            URL nodeURL = node.getURL();
            String nodeFile = new File(nodeURL.getFile()).toString();
            if (!nodeFile.equals(xmlFile)) continue;
            return editorManager.searchEditor(node);
        }
        return null;
    }

    private EditorPath getAnyOtherEditorPath() {
        EditorManager editorManager = EditorManager.getEditorManager();
        List editors = editorManager.getAllEditors();
        for (int i = 0; i < editors.size(); ++i) {
            Editor editor = (Editor)editors.get(i);
            Node node = editor.getContext().getNode();
            URL nodeURL = node.getURL();
            String nodeFile = new File(nodeURL.getFile()).toString();
            if (nodeFile.equals(this.getXmlFile(1)) || nodeFile.equals(this.getXmlFile(2)) || nodeFile.equals(this.getXmlFile(3)) || nodeFile.equals(this.getXmlFile(4))) continue;
            return editorManager.searchEditor(node);
        }
        return null;
    }

    private void closeInputHeader() {
        AdapterWSDLTester.closeXmlFile(this.operationTestContext.getInputHeaderXmlFile());
    }

    private void closeInputPayload() {
        AdapterWSDLTester.closeXmlFile(this.operationTestContext.getInputPayloadXmlFile());
    }

    private void closeOutputHeader() {
        AdapterWSDLTester.closeXmlFile(this.operationTestContext.getOutputHeaderXmlFile());
    }

    private void closeOutputPayload() {
        AdapterWSDLTester.closeXmlFile(this.operationTestContext.getOutputPayloadXmlFile());
    }

    private static void closeXmlFile(String xmlFile) {
        XMLSourceNode xmlNode = AdapterWSDLTester.getXmlNode(xmlFile, false);
        if (xmlNode != null) {
            Context context = Context.newIdeContext();
            context.setNode((Node)xmlNode);
            List xmlEditors = EditorManager.getEditorManager().findEditors(context);
            if (xmlEditors != null && xmlEditors.size() > 0) {
                EditorManager.getEditorManager().closeEditors(xmlEditors);
            }
        }
    }

    private void testOperation() {
        if (this.operationTestContext.isOutbound()) {
            this.testOutboundOperation();
        } else {
            this.testInboundOperation();
        }
    }

    private void testOutboundOperation() {
        XMLElement[] input = new XMLElement[2];
        if (this.operationTestContext.hasInput()) {
            if (this.operationTestContext.hasInputHeader()) {
                input[0] = this.getXmlDocument(1).getDocumentElement();
            }
            input[1] = this.getXmlDocument(2).getDocumentElement();
        }
        XMLElement[] output = new XMLElement[2];
        JcaWsdlTestExecutor testExecutor = this.testContext.getTestExecutor();
        String operation = this.testContext.getCurrentOperation();
        try {
            testExecutor.performOutboundTestInteraction(operation, (Element[])input, (Element[])output);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageBundleUtil.getString((String)"OUTBOUND_OPERATION_FAILED", (Object[])new String[]{operation}) + "\n" + e.getMessage(), MessageBundleUtil.getString((String)"ERROR"), 0);
        }
        if (this.operationTestContext.hasOutput()) {
            if (this.operationTestContext.hasOutputHeader()) {
                this.saveXmlDocument(output[0].getOwnerDocument(), 3);
            }
            this.saveXmlDocument(output[1].getOwnerDocument(), 4);
        }
    }

    private void testInboundOperation() {
        Object[] output = new XMLElement[2];
        JcaWsdlTestExecutor testExecutor = this.testContext.getTestExecutor();
        String operation = this.testContext.getCurrentOperation();
        try {
            output = testExecutor.performInboundTestActivation(operation, this.operationTestContext.getInboundOperationTimeout());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageBundleUtil.getString((String)"INBOUND_OPERATION_FAILED", (Object[])new String[]{operation}) + "\n" + e.getMessage(), MessageBundleUtil.getString((String)"ERROR"), 0);
        }
        if (this.operationTestContext.hasOutput()) {
            if (this.operationTestContext.hasOutputHeader()) {
                this.saveXmlDocument(output[0].getOwnerDocument(), 3);
            }
            this.saveXmlDocument(output[1].getOwnerDocument(), 4);
        }
    }

    private Document getXmlDocument(int xmlFileType) {
        Document xmlDocument = null;
        String xmlFile = this.getXmlFile(xmlFileType);
        XMLSourceNode xmlNode = AdapterWSDLTester.getXmlNode(xmlFile, false);
        if (xmlNode != null) {
            XmlModel xmlModel = xmlNode.getModel(this.context.getProject());
            xmlModel.acquireReadLock();
            xmlDocument = xmlModel.getDocument();
            xmlModel.releaseReadLock();
        } else {
            DOMParser parser = new DOMParser();
            try {
                parser.parse(xmlFile);
                xmlDocument = parser.getDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xmlDocument;
    }

    private void saveXmlDocument(Document xmlDocument, int xmlFileType) {
        String xmlFile = this.getXmlFile(xmlFileType);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(xmlFile));
            ((XMLDocument)xmlDocument).print((OutputStream)bos, "UTF-8");
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

