/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTestContext;
import oracle.tip.tools.ide.pm.addin.adaptertest.ConnectionParameterPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.InputDocumentPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.OperationPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.OperationParameterPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.OutputDocumentPanel;
import oracle.tip.tools.ide.pm.addin.adaptertest.PreferencePanel;

public class AdapterWSDLTestDialog
extends JEWTDialog {
    private Context context = null;
    private AdapterWSDLTestContext testContext = null;
    private JTabbedPane tabbedPane = null;
    private OperationPanel operationPanel = null;
    private ConnectionParameterPanel connectionParameterPanel = null;
    private OperationParameterPanel operationParameterPanel = null;
    private InputDocumentPanel inputDocumentPanel = null;
    private OutputDocumentPanel outputDocumentPanel = null;
    private PreferencePanel preferencePanel = null;

    public AdapterWSDLTestDialog(JFrame parent, Context context, AdapterWSDLTestContext testContext) {
        super((Frame)parent, MessageBundleUtil.getString((String)"TEST_WSDL_OPERATION_T"), 7);
        this.setOKButtonText(MessageBundleUtil.getString((String)"TEST"));
        this.context = context;
        this.testContext = testContext;
        this.initUI();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.getContent(), "test_adapter_wsdl_operation");
    }

    public Context getContext() {
        return this.context;
    }

    public AdapterWSDLTestContext getTestContext() {
        return this.testContext;
    }

    public AdapterWSDLTestContext.OperationTestContext getOperationTestContext() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        operationTestContext.setConnectionParameters(this.connectionParameterPanel.getParameters());
        operationTestContext.setOperationParameters(this.operationParameterPanel.getParameters());
        operationTestContext.setInputHeaderXmlFile(this.inputDocumentPanel.getHeaderXmlFile());
        operationTestContext.setGenerateInputHeaderXmlFile(this.inputDocumentPanel.isGenerateHeaderXmlFile());
        operationTestContext.setShowInputHeaderXmlFile(this.inputDocumentPanel.isShowHeaderXmlFile());
        operationTestContext.setInputPayloadXmlFile(this.inputDocumentPanel.getPayloadXmlFile());
        operationTestContext.setGenerateInputPayloadXmlFile(this.inputDocumentPanel.isGeneratePayloadXmlFile());
        operationTestContext.setShowInputPayloadXmlFile(this.inputDocumentPanel.isShowPayloadXmlFile());
        operationTestContext.setOutputHeaderXmlFile(this.outputDocumentPanel.getHeaderXmlFile());
        operationTestContext.setShowOutputHeaderXmlFile(this.outputDocumentPanel.isShowHeaderXmlFile());
        operationTestContext.setOutputPayloadXmlFile(this.outputDocumentPanel.getPayloadXmlFile());
        operationTestContext.setShowOutputPayloadXmlFile(this.outputDocumentPanel.isShowPayloadXmlFile());
        operationTestContext.setEndpointProperties(this.preferencePanel.getEndpointProperties());
        operationTestContext.setInputXmlGenerationWidth(this.preferencePanel.getInputXmlGenerationWidth());
        operationTestContext.setInputXmlGenerationDepth(this.preferencePanel.getInputXmlGenerationDepth());
        operationTestContext.setInboundOperationTimeout(this.preferencePanel.getInboundOperationTimeout());
        operationTestContext.setAutoLayout(this.preferencePanel.isAutoLayout());
        return operationTestContext;
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled && !this.validateInput()) {
            return;
        }
        super.dismissDialog(cancelled);
    }

    private boolean validateInput() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        return !(!this.operationPanel.validateInput() || !this.connectionParameterPanel.validateInput() || !this.operationParameterPanel.validateInput() || operationTestContext.hasInput() && !this.inputDocumentPanel.validateInput() || operationTestContext.hasOutput() && !this.outputDocumentPanel.validateInput() || !this.preferencePanel.validateInput());
    }

    private void initUI() {
        this.createUI();
        this.layoutUI();
        this.populateUI();
    }

    private void createUI() {
        this.operationPanel = new OperationPanel(this);
        this.connectionParameterPanel = new ConnectionParameterPanel(this);
        this.operationParameterPanel = new OperationParameterPanel(this);
        this.inputDocumentPanel = new InputDocumentPanel(this);
        this.outputDocumentPanel = new OutputDocumentPanel(this);
        this.preferencePanel = new PreferencePanel(this);
    }

    private void layoutUI() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        JPanel contentPanel = new JPanel(new BorderLayout(10, 10));
        this.tabbedPane = new JTabbedPane(1, 1);
        this.tabbedPane.add(this.operationPanel);
        this.tabbedPane.add(this.connectionParameterPanel);
        this.tabbedPane.add(this.operationParameterPanel);
        if (operationTestContext.hasInput()) {
            this.tabbedPane.add(this.inputDocumentPanel);
        }
        if (operationTestContext.hasOutput()) {
            this.tabbedPane.add(this.outputDocumentPanel);
        }
        this.tabbedPane.add(this.preferencePanel);
        contentPanel.add((Component)this.tabbedPane, "Center");
        this.setContent(contentPanel);
        this.setPreferredSize(662, 500);
        this.setResizable(true);
    }

    private void populateUI() {
    }

    private void updateUI() {
    }

    public void refreshUI() {
        AdapterWSDLTestContext.OperationTestContext operationTestContext = this.testContext.getCurrentOperationTestContext();
        this.tabbedPane.removeAll();
        this.tabbedPane.add(this.operationPanel);
        this.tabbedPane.add(this.connectionParameterPanel);
        this.tabbedPane.add(this.operationParameterPanel);
        if (operationTestContext.hasInput()) {
            this.tabbedPane.add(this.inputDocumentPanel);
        }
        if (operationTestContext.hasOutput()) {
            this.tabbedPane.add(this.outputDocumentPanel);
        }
        this.tabbedPane.add(this.preferencePanel);
        this.populateUI();
        this.connectionParameterPanel.refreshUI();
        this.operationParameterPanel.refreshUI();
        this.inputDocumentPanel.refreshUI();
        this.outputDocumentPanel.refreshUI();
        this.preferencePanel.refreshUI();
    }
}

