/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.namespace.QName;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.tip.adapter.api.test.JcaWsdlTestExecutor;
import oracle.tip.adapter.fw.test.JcaWsdlTestExecutorImpl;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;

public class AdapterWSDLTestContext {
    private Context context = null;
    private URL wsdlURL = null;
    private JcaWsdlTestExecutor testExecutor = null;
    private String currentOperation = null;
    private HashMap operationTestContexts = new HashMap();
    private static HashMap testContexts = new HashMap();

    private AdapterWSDLTestContext(Context context, URL wsdlURL) {
        this.context = context;
        this.wsdlURL = wsdlURL;
        this.testExecutor = new JcaWsdlTestExecutorImpl(wsdlURL.toString());
    }

    public static AdapterWSDLTestContext getTestContext(Context context, URL wsdlURL) {
        AdapterWSDLTestContext testContext = (AdapterWSDLTestContext)testContexts.get(wsdlURL);
        if (testContext == null || testContext.isOutDated()) {
            testContext = new AdapterWSDLTestContext(context, wsdlURL);
            testContexts.put(wsdlURL, testContext);
        }
        return testContext;
    }

    private boolean isOutDated() {
        return !this.testExecutor.isEqual(this.wsdlURL.toString());
    }

    public Context getContext() {
        return this.context;
    }

    public URL getWSDLURL() {
        return this.wsdlURL;
    }

    public JcaWsdlTestExecutor getTestExecutor() {
        return this.testExecutor;
    }

    public String[] getOperations() {
        try {
            return this.testExecutor.getJCAOperations();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public String getCurrentOperation() {
        String[] operations;
        if (this.currentOperation == null && (operations = this.getOperations()).length > 0) {
            this.currentOperation = operations[0];
        }
        return this.currentOperation;
    }

    public void setCurrentOperation(String currentOperation) {
        this.currentOperation = currentOperation;
    }

    public OperationTestContext getCurrentOperationTestContext() {
        return this.getOperationTestContext(this.getCurrentOperation());
    }

    public OperationTestContext getOperationTestContext(String operation) {
        OperationTestContext operationTestContext = (OperationTestContext)this.operationTestContexts.get(operation);
        if (operationTestContext == null) {
            operationTestContext = new OperationTestContext(operation);
            this.operationTestContexts.put(operation, operationTestContext);
        }
        return operationTestContext;
    }

    public class OperationTestContext {
        private String operation;
        private String inputHeaderXmlFile = null;
        private boolean generateInputHeaderXmlFile = true;
        private boolean showInputHeaderXmlFile = true;
        private String inputPayloadXmlFile = null;
        private boolean generateInputPayloadXmlFile = true;
        private boolean showInputPayloadXmlFile = true;
        private String outputHeaderXmlFile = null;
        private boolean showOutputHeaderXmlFile = true;
        private String outputPayloadXmlFile = null;
        private boolean showOutputPayloadXmlFile = true;
        private int inputXmlGenerationWidth = 1;
        private int inputXmlGenerationDepth = 5;
        private int inboundOperationTimeout = 5;
        private boolean autoLayout = true;
        private static final String XML_EXT = ".xml";

        public OperationTestContext(String operation) {
            this.operation = operation;
            this.init();
        }

        public AdapterWSDLTestContext getWSDLTestContext() {
            return AdapterWSDLTestContext.this;
        }

        public String getOperation() {
            return this.operation;
        }

        public boolean isOutbound() {
            return AdapterWSDLTestContext.this.testExecutor.isOutbound(this.operation);
        }

        public boolean hasInput() {
            return AdapterWSDLTestContext.this.testExecutor.isOutbound(this.operation);
        }

        public boolean hasOutput() {
            if (this.isOutbound()) {
                return !AdapterWSDLTestContext.this.testExecutor.isInputOnly(this.operation);
            }
            return true;
        }

        public boolean hasInputHeader() {
            return this.getInputHeaderElement() != null;
        }

        public boolean hasOutputHeader() {
            if (this.isOutbound()) {
                return AdapterWSDLTestContext.this.testExecutor.getOutboundOperationOutputTypes(this.operation)[0] != null;
            }
            return AdapterWSDLTestContext.this.testExecutor.getOutboundOperationInputTypes(this.operation)[0] != null;
        }

        public QName getInputHeaderElement() {
            if (this.isOutbound()) {
                return AdapterWSDLTestContext.this.testExecutor.getOutboundOperationInputTypes(this.operation)[0];
            }
            return null;
        }

        public QName getInputPayloadElement() {
            if (this.isOutbound()) {
                return AdapterWSDLTestContext.this.testExecutor.getOutboundOperationInputTypes(this.operation)[1];
            }
            return null;
        }

        public Properties getConnectionParameters() {
            try {
                return AdapterWSDLTestContext.this.testExecutor.getJCAConnectionParameters(this.operation);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Properties();
            }
        }

        public void setConnectionParameters(Properties connectionParameters) {
            try {
                AdapterWSDLTestContext.this.testExecutor.setJCAConnectionParameters(this.operation, connectionParameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Properties getOperationParameters() {
            try {
                return AdapterWSDLTestContext.this.testExecutor.getJCAOperationParameters(this.operation);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Properties();
            }
        }

        public void setOperationParameters(Properties operationParameters) {
            try {
                AdapterWSDLTestContext.this.testExecutor.setJCAOperationParameters(this.operation, operationParameters);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String getInputHeaderXmlFile() {
            return this.inputHeaderXmlFile;
        }

        public void setInputHeaderXmlFile(String inputHeaderXmlFile) {
            this.inputHeaderXmlFile = inputHeaderXmlFile;
        }

        public boolean isGenerateInputHeaderXmlFile() {
            return this.generateInputHeaderXmlFile;
        }

        public void setGenerateInputHeaderXmlFile(boolean generateInputHeaderXmlFile) {
            this.generateInputHeaderXmlFile = generateInputHeaderXmlFile;
        }

        public boolean isShowInputHeaderXmlFile() {
            return this.showInputHeaderXmlFile;
        }

        public void setShowInputHeaderXmlFile(boolean showInputHeaderXmlFile) {
            this.showInputHeaderXmlFile = showInputHeaderXmlFile;
        }

        public String getInputPayloadXmlFile() {
            return this.inputPayloadXmlFile;
        }

        public void setInputPayloadXmlFile(String inputPayloadXmlFile) {
            this.inputPayloadXmlFile = inputPayloadXmlFile;
        }

        public boolean isGenerateInputPayloadXmlFile() {
            return this.generateInputPayloadXmlFile;
        }

        public void setGenerateInputPayloadXmlFile(boolean generateInputPayloadXmlFile) {
            this.generateInputPayloadXmlFile = generateInputPayloadXmlFile;
        }

        public boolean isShowInputPayloadXmlFile() {
            return this.showInputPayloadXmlFile;
        }

        public void setShowInputPayloadXmlFile(boolean showInputPayloadXmlFile) {
            this.showInputPayloadXmlFile = showInputPayloadXmlFile;
        }

        public String getOutputHeaderXmlFile() {
            return this.outputHeaderXmlFile;
        }

        public void setOutputHeaderXmlFile(String outputHeaderXmlFile) {
            this.outputHeaderXmlFile = outputHeaderXmlFile;
        }

        public boolean isShowOutputHeaderXmlFile() {
            return this.showOutputHeaderXmlFile;
        }

        public void setShowOutputHeaderXmlFile(boolean showOutputHeaderXmlFile) {
            this.showOutputHeaderXmlFile = showOutputHeaderXmlFile;
        }

        public String getOutputPayloadXmlFile() {
            return this.outputPayloadXmlFile;
        }

        public void setOutputPayloadXmlFile(String outputPayloadXmlFile) {
            this.outputPayloadXmlFile = outputPayloadXmlFile;
        }

        public boolean isShowOutputPayloadXmlFile() {
            return this.showOutputPayloadXmlFile;
        }

        public void setShowOutputPayloadXmlFile(boolean showOutputPayloadXmlFile) {
            this.showOutputPayloadXmlFile = showOutputPayloadXmlFile;
        }

        public Properties getEndpointProperties() {
            try {
                return AdapterWSDLTestContext.this.testExecutor.getJCAEndpointProperties(this.operation);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new Properties();
            }
        }

        public void setEndpointProperties(Properties endpointProperties) {
            try {
                AdapterWSDLTestContext.this.testExecutor.setJCAEndpointProperties(this.operation, endpointProperties);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public int getInputXmlGenerationWidth() {
            return this.inputXmlGenerationWidth;
        }

        public void setInputXmlGenerationWidth(int inputXmlGenerationWidth) {
            this.inputXmlGenerationWidth = inputXmlGenerationWidth;
        }

        public int getInputXmlGenerationDepth() {
            return this.inputXmlGenerationDepth;
        }

        public void setInputXmlGenerationDepth(int inputXmlGenerationDepth) {
            this.inputXmlGenerationDepth = inputXmlGenerationDepth;
        }

        public int getInboundOperationTimeout() {
            return this.inboundOperationTimeout;
        }

        public void setInboundOperationTimeout(int inboundOperationTimeout) {
            this.inboundOperationTimeout = inboundOperationTimeout;
        }

        public boolean isAutoLayout() {
            return this.autoLayout;
        }

        public void setAutoLayout(boolean autoLayout) {
            this.autoLayout = autoLayout;
        }

        private void init() {
            Project project = AdapterWSDLTestContext.this.context.getProject();
            URL htmlRootUrl = J2eeSettings.getInstance((Project)project).getHtmlRootDirectory();
            URLFileSystem.mkdirs((URL)htmlRootUrl);
            String htmlRootDir = new File(htmlRootUrl.getFile()).toString();
            String operationName = this.toFileReadyName(this.operation);
            this.inputHeaderXmlFile = new File(htmlRootDir, operationName + "_" + MessageBundleUtil.getString((String)"INPUT_HEADER_XML_FILE_NAME_SUFFIX") + XML_EXT).toString();
            this.generateInputHeaderXmlFile = true;
            this.showInputHeaderXmlFile = true;
            this.inputPayloadXmlFile = new File(htmlRootDir, operationName + "_" + MessageBundleUtil.getString((String)"INPUT_PAYLOAD_XML_FILE_NAME_SUFFIX") + XML_EXT).toString();
            this.generateInputPayloadXmlFile = true;
            this.showInputPayloadXmlFile = true;
            this.outputHeaderXmlFile = new File(htmlRootDir, operationName + "_" + MessageBundleUtil.getString((String)"OUTPUT_HEADER_XML_FILE_NAME_SUFFIX") + XML_EXT).toString();
            this.showOutputHeaderXmlFile = true;
            this.outputPayloadXmlFile = new File(htmlRootDir, operationName + "_" + MessageBundleUtil.getString((String)"OUTPUT_PAYLOAD_XML_FILE_NAME_SUFFIX") + XML_EXT).toString();
            this.showOutputPayloadXmlFile = true;
            this.inputXmlGenerationWidth = 1;
            this.inputXmlGenerationDepth = 5;
            this.inboundOperationTimeout = 5;
            this.autoLayout = true;
        }

        private String toFileReadyName(String operation) {
            return operation.replaceAll("::", "_");
        }
    }
}

