/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin.adaptertest;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.navigator.NavigatorManager;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.webservices.ide.WSDLArtifactNode;
import oracle.tip.adapter.fw.test.JcaWsdlTestExecutorImpl;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.utils.MapUtils;
import oracle.tip.tools.ide.pm.addin.adaptertest.AdapterWSDLTester;

public class AdapterWSDLContextMenuListener
implements ContextMenuListener,
Controller {
    private Object listenee = null;
    private JMenuItem testMenuItem = null;
    private IdeAction testAction = null;
    private int testCmdId = Ide.findOrCreateCmdID((String)"AdapterWSDLContextMenuListener.TEST");

    public AdapterWSDLContextMenuListener(Object listenee) {
        this.listenee = listenee;
        this.createActions();
    }

    public void menuWillShow(ContextMenu menu) {
        if (!AdapterWSDLContextMenuListener.isAdapterWSDLNode(menu.getContext().getNode())) {
            return;
        }
        if (this.listenee instanceof NavigatorManager || this.listenee instanceof EditorManager) {
            if (this.testMenuItem == null) {
                this.testMenuItem = menu.createMenuItem((ToggleAction)this.testAction, JDeveloperMenuConstants.WEIGHT_FILE_EXIT);
            }
            menu.add((Component)this.testMenuItem, JDeveloperMenuConstants.SECTION_FILE_EXIT);
        }
    }

    public void menuWillHide(ContextMenu menu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action == this.testAction) {
            this.test(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action == this.testAction) {
            this.testAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private static boolean isAdapterWSDLNode(Node node) {
        if (!(node instanceof WSDLArtifactNode)) {
            return false;
        }
        return new JcaWsdlTestExecutorImpl(node.getURL().toString()).hasJCAOperations();
    }

    public void refreshActions(Context context) {
        this.update(this.testAction, context);
    }

    private void createActions() {
        this.testAction = IdeAction.get((int)this.testCmdId, null, (String)MessageBundleUtil.getString((String)"TEST_WSDL_L"), null, (Integer)new Integer(84), (Icon)MapUtils.getDummyIcon((int)16, (int)16), null, (boolean)true);
        this.testAction.addController((Controller)this);
    }

    private void test(Context context) {
        WSDLArtifactNode wsdlNode = (WSDLArtifactNode)context.getNode();
        if (wsdlNode.isDirty()) {
            try {
                wsdlNode.save();
            }
            catch (Exception e) {
                return;
            }
        }
        new AdapterWSDLTester(context).test();
    }
}

