/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.addin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.bali.xml.addin.CheckSyntaxController;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataProvider;
import oracle.diagram.thumbnail.ThumbnailDockable;
import oracle.diagram.thumbnail.ThumbnailViewFactory;
import oracle.ide.AddinManager;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.inspector.InspectorFactory;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.MenuSpec;
import oracle.ide.xml.XMLRecognizer;
import oracle.tip.tools.ide.common.bpeldesigner.util.BPELModelerUtil;
import oracle.tip.tools.ide.common.bpeldesigner.util.Helper;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.i18n.CommonResourceManager;
import oracle.tip.tools.ide.common.ide.IDE;
import oracle.tip.tools.ide.common.ide.IDEResolver;
import oracle.tip.tools.ide.common.ide.jdeveloper.JDevIDE;
import oracle.tip.tools.ide.pm.addin.jdeveloper.PMInspectable;
import oracle.tip.tools.ide.pm.addin.migrator.PMProjectMigrator;
import oracle.tip.tools.ide.pm.addin.model.BPELNode;
import oracle.tip.tools.ide.pm.addin.model.XMLNode;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.AssignBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.CatchAllBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.CatchBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.CompensateBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.CompensationHandlerBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ContainerActivityBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.EmptyBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.FlowBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.InvokeBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.OnAlarmBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.OnMessageBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.PickBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ProcessBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ReceiveBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ReplyBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ScopeBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.SequenceBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.SwitchBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.SwitchCaseBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.SwitchOtherwiseBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.TerminateBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.ThrowBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.TransformationBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.WaitBean;
import oracle.tip.tools.ide.pm.addin.modelbean.generated.WhileBean;
import oracle.tip.tools.ide.pm.addin.preferences.BPELDesignerSettings;
import oracle.tip.tools.ide.pm.addin.thumbnail.BPELThumbnailViewFactory;
import oracle.tip.tools.ide.pm.addin.versions.VersionsFile;
import oracle.tip.tools.ide.pm.addin.view.BPELAddinController;
import oracle.tip.tools.ide.pm.addin.view.BPELAddinShutdownHook;
import oracle.tip.tools.ide.pm.addin.view.BPELExplorer;
import oracle.tip.tools.ide.pm.addin.view.BPELPreferredLayoutListener;
import oracle.tip.tools.ide.pm.addin.view.BPELXmlVisualEditor;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.plugin.BPELModelerPlugin;
import oracle.tip.tools.ide.pm.plugin.BPELPlugInManager;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class BPELAddin
extends EditorAddin {
    public static final String BPEL_METADATA_PROVIDER_ID = "BPEL_METADATA_PROVIDER_ID";
    public static final String BPEL_NAMESPACE = "http://schemas.xmlsoap.org/ws/2003/03/business-process/";
    public static final String BPEL_ROOT = "process";
    public static final String BPEL_EXTENSION = ".bpel";
    public static final String JCA_EXTENSION = ".jca";
    public static final String BPEL_OVERVIEW_ACTION_ID = "BPELOverviewCommandID";
    protected MenuSpec m_menuSpec;

    public static float getVersionNumber(Object obj) {
        return VersionsFile.getInstance().getVersion(obj);
    }

    public static String getExtensionID() {
        try {
            return AddinManager.getAddinManager().getExtensionIDForAddin(Class.forName("oracle.tip.tools.ide.pm.addin.BPELAddin"));
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Class getEditorClass() {
        return BPELXmlVisualEditor.class;
    }

    public void initialize() {
        this.installImageLoader();
        this.installIDEAbstractionLayer();
        this.installBPELParser();
        this.installStringTranslator();
        this.installThumbnail();
        this.installController();
        this.installMigrator();
        this.installBPELNode();
        this.installJCANode();
        this.installStructurePane();
        this.installBeanInspectables();
        this.installIconsDirectory();
        this.installPreferencesPage();
        this.installBPELPlugins();
        BPELAddin.installMetaDataRegistry();
        this.installShutdownHook();
    }

    public boolean isDefault() {
        return true;
    }

    public MenuSpec getMenuSpecification() {
        if (this.m_menuSpec == null) {
            this.m_menuSpec = new MenuSpec(BPELStringTranslator.getString("PM_ADDIN_BPEL_DIAGRAM"), new Integer(77), ImageCache.getIcon("scope_node"));
        }
        return this.m_menuSpec;
    }

    protected void installedPreferredLayoutListener() {
        new BPELPreferredLayoutListener();
    }

    protected void installController() {
        new BPELAddinController().install();
    }

    protected void installIconsDirectory() {
        String[] directories = new String[]{"integration", "bpm", "designer", "integration", "icons"};
        File f = new File(Ide.getHomeDirectory());
        f = f.getParentFile();
        for (String dir : directories) {
            if ((f = new File(f, dir)).exists()) continue;
            f.mkdir();
        }
        URL u = BPELAddin.getUserDocumentationImagesDirectory();
        if (!URLFileSystem.exists((URL)u)) {
            URLFileSystem.mkdirs((URL)u);
        }
    }

    public static URL getUserDocumentationImagesDirectory() {
        String installPath = Ide.getProperty((String)"Ide.InstallPath");
        File jdevHome = new File(installPath).getParentFile().getParentFile();
        try {
            return URLFactory.newDirURL((URL)Helper.getURL((File)jdevHome), (String)"integration/bpm/designer/integration/user_documentation_images");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getPartnerLinkIconsDirectory() {
        String installPath = Ide.getProperty((String)"Ide.InstallPath");
        File jdevHome = new File(installPath).getParentFile().getParentFile();
        try {
            return URLFactory.newDirURL((URL)Helper.getURL((File)jdevHome), (String)"integration/bpm/designer/integration/icons");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void installShutdownHook() {
        ExitCommand.addShutdownHook((ShutdownHook)new BPELAddinShutdownHook());
    }

    protected void installBPELPlugins() {
        BPELPlugInManager.initializePlugins();
    }

    protected void installImageLoader() {
        ImageCache.initialize();
    }

    protected void installIDEAbstractionLayer() {
        IDE ide = IDEResolver.getIDE();
        if (ide == null) {
            IDEResolver.setIDE((IDE)new JDevIDE());
        }
    }

    protected void installPreferencesPage() {
        BPELDesignerSettings.install();
    }

    protected void installStringTranslator() {
        CommonResourceManager.initialize();
        BPELStringTranslator.initialize();
    }

    protected void installBPELParser() {
        BPELParser.setXMLEditingFramework((boolean)BPELModelerUtil.useXMLEditingFramework());
    }

    protected void installThumbnail() {
        ThumbnailDockable.registerThumbnailViewFactory(BPELXmlVisualEditor.class, (ThumbnailViewFactory)BPELThumbnailViewFactory.getInstance());
    }

    protected void installBPELNode() {
        AddinManager manager = AddinManager.getAddinManager();
        XMLEditorAddin xmlAddin = (XMLEditorAddin)manager.getAddin(XMLEditorAddin.class);
        if (xmlAddin != null) {
            XMLEditorAddin.register(BPELNode.class, (String)BPEL_EXTENSION, null, (boolean)true);
        }
        CheckSyntaxController.registerForGrammarValidation(BPELNode.class);
        XMLRecognizer.mapNamespaceElemToClass((String)BPEL_NAMESPACE, (String)BPEL_ROOT, BPELNode.class);
        Recognizer.registerDocumentInfo(BPELNode.class, (DocumentInfo)new DocumentInfo(BPELStringTranslator.getString("BPEL_PROCESS")));
        EditorManager.getEditorManager().register((EditorAddin)this, new Class[]{BPELNode.class});
        BPELPreferredLayoutListener layoutListener = new BPELPreferredLayoutListener();
        EditorManager.getEditorManager().registerPreferredLayoutListener(BPELNode.class, CodeEditor.class, BPELStringTranslator.getString("PM_ADDIN_BPEL_SOURCE_EDITOR"), (PreferredLayoutListener)layoutListener);
        EditorManager.getEditorManager().registerPreferredLayoutListener(BPELNode.class, this.getEditorClass(), BPELStringTranslator.getString("PM_ADDIN_BPEL_EDITOR"), (PreferredLayoutListener)layoutListener);
    }

    protected void installJCANode() {
        AddinManager manager = AddinManager.getAddinManager();
        XMLEditorAddin xmlAddin = (XMLEditorAddin)manager.getAddin(XMLEditorAddin.class);
        if (xmlAddin != null) {
            XMLEditorAddin.register(XMLNode.class, (String)JCA_EXTENSION, null, (boolean)true);
        }
    }

    protected void installStructurePane() {
        ExplorerManager explorerMgr = ExplorerManager.getExplorerManager();
        if (explorerMgr != null) {
            explorerMgr.register(BPELNode.class, BPELExplorer.class, this.getEditorClass(), "BPEL", ImageCache.getIcon("process_node"));
        }
    }

    protected void installMigrator() {
        PMProjectMigrator projectMigrator = new PMProjectMigrator();
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)ProjectMigrator.MIGRATOR_NAME);
        if (migrator != null) {
            migrator.addHelper((NodeMigratorHelper)projectMigrator);
        }
    }

    public static void installMetaDataRegistry() {
        try {
            StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
            for (BPELModelerPlugin plugin : BPELPlugInManager.getPlugins()) {
                plugin.registerMetaDataFiles(registry);
            }
            StandaloneMetadataProvider provider = new StandaloneMetadataProvider(MetadataRegistry.getInstance().getBaseMetadataProvider(), registry);
            MetadataRegistry.getInstance().registerMetadataProvider(BPEL_METADATA_PROVIDER_ID, (MetadataProvider)provider);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void installBeanInspectables() {
        InspectorFactory.getInstance().registerInspectable(AssignBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(CatchAllBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(CatchBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(CompensateBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(CompensationHandlerBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ContainerActivityBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(EmptyBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(FlowBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(InvokeBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(OnAlarmBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(OnMessageBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(PickBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ProcessBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ReceiveBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ReplyBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ScopeBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(SequenceBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(SwitchBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(SwitchCaseBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(SwitchOtherwiseBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(TerminateBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(ThrowBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(TransformationBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(WaitBean.class, PMInspectable.class);
        InspectorFactory.getInstance().registerInspectable(WhileBean.class, PMInspectable.class);
    }
}

