/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.fusion.sca.validator;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.compiler.ProjectCompilationListener;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ModelObject;
import oracle.soa.scac.FaultObject;
import oracle.soa.scac.ValidationFault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompilationListener
implements ProjectCompilationListener {
    private boolean result = true;
    private ValidationFault validationFault;

    public CompilationListener() {
    }

    public CompilationListener(ValidationFault validationFault) {
        this();
        this.validationFault = validationFault;
    }

    public boolean getCompilationResult() {
        return this.result;
    }

    public void onError(ProjectException exception) {
        FaultObject faultObject = this.buildFaultObject(exception);
        if (this.validationFault != null) {
            this.validationFault.addError(faultObject);
        }
        this.result = false;
    }

    public void onInfo(ProjectException exception) {
        FaultObject faultObject = this.buildFaultObject(exception);
        if (this.validationFault != null) {
            this.validationFault.addInfo(faultObject);
        }
    }

    public void onWarning(ProjectException exception) {
        FaultObject faultObject = this.buildFaultObject(exception);
        if (this.validationFault != null) {
            this.validationFault.addWarning(faultObject);
        }
    }

    public void onCheckStarted(ProjectObject projectObject) {
    }

    public void onCheckFinished(ProjectObject projectObject) {
    }

    public boolean onInterruptionCheck() {
        return false;
    }

    private FaultObject buildFaultObject(@NotNull ProjectException exception) {
        if (exception == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/CompilationListener.buildFaultObject must not be null");
        }
        FaultObject faultObject = new FaultObject(exception.getMessage());
        ProjectObject projectObject = exception.getProjectObject();
        String filePath = this.findProjectObjectFile(projectObject);
        if (filePath != null) {
            faultObject.setFileName(filePath);
        }
        return faultObject;
    }

    @Nullable
    private String findProjectObjectFile(@NotNull ProjectObject projectObject) {
        if (projectObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/fusion/sca/validator/CompilationListener.findProjectObjectFile must not be null");
        }
        if (projectObject instanceof ModelObject) {
            projectObject = ((ModelObject)projectObject).getProcess();
        }
        String result = null;
        if (projectObject instanceof CatalogObjectImpl.CorruptedResourceImpl) {
            TypeDescription typeDescription = ((CatalogObjectImpl.CorruptedResourceImpl)projectObject).getDelegate();
            VFile vfile = (VFile)typeDescription.asObject().getTransientProperty("resource_error");
            if (vfile != null) {
                result = vfile.getCanonicalPath();
            }
        } else {
            VFile vfile = (VFile)((Adaptable)projectObject).as(VFile.class);
            if (vfile != null) {
                result = vfile.getCanonicalPath();
            }
        }
        return result;
    }
}

