/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs.protocol;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileInputStream;
import oracle.bpm.io.fs.VFileOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileURLConnection
extends URLConnection {
    private VFile vFile = null;
    private static Map<String, VFile> urlCache = new HashMap<String, VFile>();

    public VFileURLConnection(URL url) {
        super(url);
    }

    public static void register(@NotNull URL url, @NotNull VFile vFile) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/VFileURLConnection.register must not be null");
        }
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/protocol/VFileURLConnection.register must not be null");
        }
        urlCache.put(String.valueOf(url), vFile);
    }

    @Nullable
    public static VFile get(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/VFileURLConnection.get must not be null");
        }
        return urlCache.get(String.valueOf(url));
    }

    @Nullable
    public static VFile get(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/VFileURLConnection.get must not be null");
        }
        return urlCache.get(String.valueOf(uri));
    }

    @Override
    public void connect() throws IOException {
        if (this.vFile == null) {
            this.vFile = urlCache.get(String.valueOf(this.url));
        }
    }

    @Override
    public String getContentType() {
        return super.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.vFile == null ? null : new BufferedInputStream(new VFileInputStream(this.vFile));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.connect();
        return this.vFile == null ? null : new VFileOutputStream(this.vFile);
    }
}

