/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs.protocol;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.regex.Pattern;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.io.fs.protocol.vfile.Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class URLHelper {
    private URLHelper() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static URL resolveURL(@NotNull URL ctx, @NotNull String location) throws IOException {
        URL ret;
        if (ctx == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.resolveURL must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.resolveURL must not be null");
        }
        if (location.startsWith("http:") || location.startsWith("file:")) {
            ret = new URL(location);
        } else if (location.startsWith("oramds:")) {
            ret = new URL(ctx, location);
        } else if ("vfile".equals(ctx.getProtocol())) {
            VFile vFile = VFileURLConnection.get(ctx);
            assert (vFile != null);
            VFileSystem fileSystem = vFile.getFileSystem();
            VFile parentFile = vFile.getParentFile();
            VFile file = fileSystem.createFile(parentFile, location);
            ret = file.getCanonicalFile().toURL();
        } else {
            ret = new URL(ctx, location);
        }
        URL uRL = ret;
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.resolveURL must not return null");
        }
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static URL toUrl(@NotNull URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.toUrl must not be null");
        }
        VFile vFile = URLHelper.getFromURI(uri);
        URL uRL = vFile != null ? vFile.toURL() : uri.toURL();
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.toUrl must not return null");
        }
        return uRL;
    }

    @Nullable
    public static VFile getFromURI(@NotNull URI uri) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.getFromURI must not be null");
        }
        String uriStr = uri.toString();
        VFile ret = null;
        if (uriStr.startsWith("vfile")) {
            ret = VFileURLConnection.get(uri);
        }
        return ret;
    }

    public static String getResourceLocation(@NotNull URI uri) throws IOException {
        String result;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.getResourceLocation must not be null");
        }
        String uriStr = uri.toString();
        if (uriStr.startsWith("vfile")) {
            VFile ret = VFileURLConnection.get(uri);
            assert (ret != null);
            result = ret.getCanonicalPath();
        } else {
            result = uri.toString();
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static URI createFrom(@NotNull URI uri, @NotNull String relativePath) throws IOException, URISyntaxException {
        URI ret;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.createFrom must not be null");
        }
        if (relativePath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.createFrom must not be null");
        }
        if (relativePath.contains(":")) {
            ret = new URI(relativePath);
        } else {
            String uriStr = uri.toString();
            if (uriStr.startsWith("vfile")) {
                VFile vFile = URLHelper.getFromURI(uri);
                assert (vFile != null);
                VFile newVFile = vFile.getFileSystem().createFile(vFile.getParentFile(), relativePath);
                try {
                    ret = newVFile.toURL().toURI();
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            } else {
                ret = uri.resolve(relativePath);
            }
        }
        URI uRI = ret;
        if (uRI == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.createFrom must not return null");
        }
        return uRI;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static String buildRelativeLocation(@NotNull String importer, @NotNull String imported) {
        int i;
        String string;
        block13: {
            block14: {
                block12: {
                    if (importer == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not be null");
                    }
                    if (imported == null) {
                        throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not be null");
                    }
                    if (Pattern.matches("[a-zA-Z]+:/.*", imported)) {
                        string = imported;
                        if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
                        return string;
                    }
                    String sep = "/";
                    if (!imported.startsWith("/")) break block12;
                    imported = imported.substring(1);
                    if (!importer.startsWith("/")) break block13;
                    break block14;
                }
                string = imported;
                if (string == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
                return string;
            }
            importer = importer.substring(1);
        }
        int upLevelCount = 0;
        String[] split1 = importer.split("/");
        String[] split2 = imported.split("/");
        for (int c = 0; c < split1.length - 1; ++c) {
            String s1 = split1[c];
            String s2 = null;
            if (split2.length - 1 > c) {
                s2 = split2[c];
            }
            if (s2 != null && s1.equals(s2)) continue;
            upLevelCount = split1.length - c - 1;
            break;
        }
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < upLevelCount; ++i) {
            builder.append("..");
            builder.append("/");
        }
        for (i = c; i < split2.length; ++i) {
            String s = split2[i];
            builder.append(s);
            if (i == split2.length - 1) continue;
            builder.append("/");
        }
        string = builder.toString();
        if (string != null) return string;
        throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.buildRelativeLocation must not return null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static URL createURL(@NotNull String urlString) throws MalformedURLException {
        URL url;
        if (urlString == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.createURL must not be null");
        }
        if (urlString.startsWith("vfile:")) {
            url = new URL(null, urlString, Handler.getInstance());
        } else if (urlString.startsWith("http:") || urlString.startsWith("file:")) {
            url = new URL(urlString);
        } else if (urlString.startsWith("oramds:")) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                Class<URLHelper> clazz = URLHelper.class;
                // MONITORENTER : oracle.bpm.io.fs.protocol.URLHelper.class
                try {
                    URL.setURLStreamHandlerFactory(new OraMdsURLStreamHandler(null));
                }
                catch (Error e1) {
                    try {
                        Field lockField = URL.class.getDeclaredField("streamHandlerLock");
                        lockField.setAccessible(true);
                        Object lock = lockField.get(null);
                        Field factoryField = URL.class.getDeclaredField("factory");
                        factoryField.setAccessible(true);
                        Object object = lock;
                        // MONITORENTER : object
                        URLStreamHandlerFactory oldFactory = (URLStreamHandlerFactory)factoryField.get(null);
                        OraMdsURLStreamHandler handler = new OraMdsURLStreamHandler(oldFactory);
                        factoryField.set(null, handler);
                        // MONITOREXIT : object
                    }
                    catch (NoSuchFieldException e2) {
                        e2.printStackTrace();
                    }
                    catch (IllegalAccessException e2) {
                        e2.printStackTrace();
                    }
                }
                // MONITOREXIT : clazz
                url = new URL(urlString);
            }
        } else {
            url = new File(urlString).toURI().toURL();
        }
        URL uRL = url;
        if (uRL == null) throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.createURL must not return null");
        return uRL;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String relativePathFromUri(@NotNull URI uri) {
        String result;
        if (uri == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/protocol/URLHelper.relativePathFromUri must not be null");
        }
        try {
            result = URLHelper.getResourceLocation(uri);
        }
        catch (IOException e) {
            result = uri.toString();
        }
        String string = result;
        if (string == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/protocol/URLHelper.relativePathFromUri must not return null");
        }
        return string;
    }

    public static class OraMdsURLStreamHandler
    extends URLStreamHandler
    implements URLStreamHandlerFactory {
        private final URLStreamHandlerFactory oldFactory;

        OraMdsURLStreamHandler(URLStreamHandlerFactory oldFactory) {
            this.oldFactory = oldFactory;
        }

        @Override
        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandler handler = "oramds".equals(protocol) ? this : (this.oldFactory != null ? this.oldFactory.createURLStreamHandler(protocol) : null);
            return handler;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() {
                }
            };
        }
    }
}

