/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.Activity;
import fuego.papi.InstanceInfo;
import fuego.papi.OperationException;
import fuego.papi.Task;
import fuego.papi.VarDefinition;
import fuego.papi.collections.InstanceActivityPair;
import fuego.papi.collections.InstanceInfoList;
import fuego.papi.exception.InvalidVariableIdException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.Time;

public class ProcessInstance
extends InstanceInfo {
    private InstanceInfo instance;
    private Map<Integer, InstanceInfo> threads;
    private static final long serialVersionUID = 3590780998670132023L;

    private ProcessInstance(Collection<InstanceInfo> instances) {
        if (instances == null || instances.size() < 1) {
            throw new IllegalArgumentException("A ProcessInstance must contains at least one InstanceInfo");
        }
        this.threads = new TreeMap<Integer, InstanceInfo>();
        this.addThread(instances);
        this.processIn = this.instance.getProcessIn();
        this.processId = this.instance.getProcessId();
        this.instanceIn = this.instance.getInstanceIn();
        this.threadIn = this.instance.getThreadIn();
        this.authorId = this.instance.getAuthorId();
        this.creationTime_d = this.instance.getCreationTime();
        this.participantId_d = this.instance.getParticipantId();
        this.roleId = this.instance.getRoleId();
    }

    public static ProcessInstance create(InstanceInfo instance) {
        return new ProcessInstance(InstanceInfoList.create(instance));
    }

    public static ProcessInstance create(Collection<InstanceInfo> instances) {
        return new ProcessInstance(instances);
    }

    public ProcessInstance addThread(InstanceInfo instanceInfo) {
        if (!this.instance.getProcessId().equalsIgnoreCase(instanceInfo.getProcessId()) || this.instance.getInstanceIn() != instanceInfo.getInstanceIn()) {
            throw new IllegalArgumentException("The given instance is not a thread of the ProcessInstance.");
        }
        if (this.instance.getThreadIn() > instanceInfo.getThreadIn()) {
            this.threads.put(this.instance.getThreadIn(), this.instance);
            this.threads.remove(instanceInfo.getThreadIn());
            this.instance = instanceInfo;
        } else {
            this.threads.put(instanceInfo.getThreadIn(), instanceInfo);
        }
        return this;
    }

    public ProcessInstance addThread(Collection<InstanceInfo> instances) {
        InstanceInfo parentInstance = this.instance;
        TreeMap<Integer, InstanceInfo> _thread = new TreeMap<Integer, InstanceInfo>();
        for (InstanceInfo info : instances) {
            if (parentInstance == null) {
                parentInstance = info;
            } else {
                if (!parentInstance.getProcessId().equalsIgnoreCase(info.getProcessId()) || parentInstance.getInstanceIn() != info.getInstanceIn()) {
                    throw new IllegalArgumentException("The given instance is not a thread of the ProcessInstance.");
                }
                if (parentInstance.getThreadIn() > info.getThreadIn()) {
                    parentInstance = info;
                }
            }
            _thread.put(info.getThreadIn(), info);
        }
        _thread.remove(parentInstance.getThreadIn());
        this.instance = parentInstance;
        this.threads.putAll(_thread);
        return this;
    }

    public InstanceInfo getRoot() {
        return this.instance;
    }

    public InstanceInfo getThread(int tin) throws OperationException {
        if (tin == this.getThreadIn()) {
            return this.instance;
        }
        return this.threads.get(tin);
    }

    public InstanceInfoList getThreads() {
        if (this.threads.isEmpty()) {
            return InstanceInfoList.create(this.instance);
        }
        return InstanceInfoList.create(this.threads.values());
    }

    public StringList getActivities() {
        TreeSet<String> activities = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.threads.isEmpty()) {
            activities.add(this.instance.getActivityName());
        } else {
            for (InstanceInfo info : this.threads.values()) {
                activities.add(info.getActivityName());
            }
        }
        return StringList.create(activities);
    }

    public StringList getParticipants() {
        TreeSet<String> participants = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.threads.isEmpty()) {
            participants.add(this.instance.getParticipantId());
        } else {
            for (InstanceInfo info : this.threads.values()) {
                participants.add(info.getParticipantId());
            }
        }
        return StringList.create(participants);
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = super.equals(object);
        if (!equals && object instanceof ProcessInstance) {
            ProcessInstance other = (ProcessInstance)object;
            equals = this.getProcessId().equalsIgnoreCase(other.getProcessId()) && this.getInstanceIn() == other.getInstanceIn();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        return (this.getProcessId().hashCode() << 16) + this.getInstanceIn();
    }

    @Override
    public int getPriority() {
        int priority = 1;
        if (this.threads.isEmpty()) {
            return this.instance.getPriority();
        }
        for (InstanceInfo info : this.threads.values()) {
            if (priority >= info.getPriority()) continue;
            priority = info.getPriority();
        }
        return priority;
    }

    @Override
    public Object getVariable(String variableId, Locale locale) {
        return this.getVariable(variableId);
    }

    @Override
    public Object getVariable(String variableId) {
        if (variableId.equals("PREDEFINE_DEADLINE")) {
            return this.getDeadline();
        }
        if (variableId.equals("PREDEFINE_PRIORITY")) {
            return this.getPriority();
        }
        if (variableId.equals("PREDEFINE_STATUS")) {
            return this.getStatus();
        }
        if (variableId.equals("PREDEFINE_RECEIVED TIME")) {
            return this.getCreationTime();
        }
        if (variableId.equals("PREDEFINE_ACTIVITY DEADLINE")) {
            return null;
        }
        if (variableId.equals("PREDEFINE_ACTIVITY")) {
            return this.getActivityId();
        }
        if (variableId.equals("PREDEFINE_AUTHOR") || variableId.equals(VarDefinition.AUTHOR_DISPLAYNAME)) {
            return this.getAuthorId();
        }
        if (variableId.equals("PREDEFINE_CREATION TIME")) {
            return this.getCreationTime();
        }
        if (variableId.equals("PREDEFINE_PARTICIPANT")) {
            StringBuffer string = new StringBuffer();
            boolean addComma = false;
            for (String participant : this.getParticipants()) {
                if (addComma) {
                    string.append(", ");
                } else {
                    addComma = true;
                }
                string.append(participant);
            }
            return string;
        }
        if (variableId.equals(VarDefinition.HAS_NOTES)) {
            for (InstanceInfo info : this.getThreads()) {
                if (!((Boolean)info.getVariable(VarDefinition.HAS_NOTES)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        if (variableId.equals("PREDEFINE_HAS_ATTACHMENTS")) {
            for (InstanceInfo info : this.getThreads()) {
                if (!((Boolean)info.getVariable("PREDEFINE_HAS_ATTACHMENTS")).booleanValue()) continue;
                return true;
            }
            return false;
        }
        return this.instance.getVariable(variableId);
    }

    @Override
    @Deprecated
    public Activity getActivity() {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Override
    public boolean isActivityCompleted() {
        return this.isCompleted();
    }

    @Override
    public Time getActivityDeadline() {
        return this.getDeadline();
    }

    @Override
    public String getActivityId() {
        StringBuilder stringBuffer = new StringBuilder();
        boolean addComma = false;
        for (String activity : this.getActivities()) {
            if (addComma) {
                stringBuffer.append(", ");
            } else {
                addComma = true;
            }
            stringBuffer.append(activity);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getActivityName() {
        return this.getActivityId();
    }

    @Override
    public int getAuthor() {
        return this.instance.getAuthor();
    }

    @Override
    public String getAuthorId() {
        return this.instance.getAuthorId();
    }

    @Override
    public boolean isCompleted() {
        return this.instance.isCompleted();
    }

    @Override
    public Time getDeadline() {
        return this.getProcessDeadline();
    }

    @Override
    public String getDescription() {
        return this.instance.getDescription();
    }

    @Override
    public boolean isException() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isException()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isExecuting() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isExecuting()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isGrabbed() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isGrabbed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getId() {
        return this.instance.getId();
    }

    @Override
    @Exclude
    public int getInternalState() {
        return this.instance.getInternalState();
    }

    @Override
    public int getNumberOfThreads() {
        return this.instance.getNumberOfThreads();
    }

    @Override
    public int getParentThreadIn() {
        return this.instance.getParentThreadIn();
    }

    @Override
    public String getParticipantId() {
        StringBuilder stringBuffer = new StringBuilder();
        boolean addComma = false;
        for (String participant : this.getParticipants()) {
            if (addComma) {
                stringBuffer.append(", ");
            } else {
                addComma = true;
            }
            stringBuffer.append(participant);
        }
        return stringBuffer.toString();
    }

    @Override
    public int getParticipantIn() {
        return -1;
    }

    @Override
    public boolean isPending() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isPending()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPendingTaskIn() {
        return -1;
    }

    @Override
    public Time getProcessDeadline() {
        return this.instance.getProcessDeadline();
    }

    @Override
    public String getProcessId() {
        return this.instance.getProcessId();
    }

    @Override
    public Time getReceptionTime() {
        return this.getCreationTime();
    }

    @Override
    public String getRoleId() {
        return null;
    }

    @Override
    public int getRoleIn() {
        return -1;
    }

    @Override
    public boolean isRunning() {
        return !this.isSuspended();
    }

    @Override
    public boolean isSelected() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InstanceActivityPair getInstanceActivityPair() {
        return this.instance.getInstanceActivityPair();
    }

    @Override
    public int getTaskCount() {
        return 0;
    }

    @Override
    public int getTaskIn(int taskNumber) {
        return -1;
    }

    @Override
    public int getTaskInternalStatus(int taskNumber) {
        return 0;
    }

    @Override
    public String getTaskLastExecutionParticipant(int taskNumber) {
        return null;
    }

    @Override
    public Time getTaskLastExecutionTime(int taskNumber) {
        return null;
    }

    @Override
    public String getTaskParticipantId(int taskNumber) {
        return null;
    }

    @Override
    public int getTaskRetryCounter(int taskNumber) {
        return 0;
    }

    @Override
    public boolean isTaskRunning(int taskNumber) {
        return false;
    }

    @Override
    public boolean isTaskSelected(int taskNumber) {
        return false;
    }

    @Override
    public String getTaskStatusDescription(int taskNumber, Locale locale) {
        return null;
    }

    @Override
    public boolean isTaskValid(int taskNumber) {
        return false;
    }

    @Override
    public Task[] getTasks() {
        return new Task[0];
    }

    @Override
    @Deprecated
    public Object getVar(String variableId, Locale locale) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Override
    public Object getExternalVariable(String variableId, Locale locale) throws InvalidVariableIdException {
        return this.instance.getExternalVariable(variableId);
    }

    @Override
    @Deprecated
    public Object getVar(String variableId) {
        throw new UnsupportedOperationException("Method not supported in this version.");
    }

    @Override
    public Object getExternalVariable(String variableId) throws InvalidVariableIdException {
        return this.instance.getExternalVariable(variableId);
    }

    @Override
    public Object getNormalVariable(String variableId) throws InvalidVariableIdException {
        return this.instance.getNormalVariable(variableId);
    }

    @Override
    public boolean hasPendingTasks() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.hasPendingTasks()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRepeatableTasks() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.hasRepeatableTasks()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAborted() {
        return this.instance.isAborted();
    }

    @Override
    public int getStatus() {
        return this.instance.getStatus();
    }

    @Override
    public String getStatusDescription(Locale locale) {
        return this.instance.getStatusDescription(locale);
    }

    @Override
    public boolean isSuspended() {
        for (InstanceInfo info : this.getThreads()) {
            if (!info.isSuspended()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Task getTask(int taskNumber) {
        return null;
    }

    @Override
    public Task getTask(String taskId) {
        return null;
    }

    @Override
    public boolean isTaskCompleted(int taskNumber) {
        return false;
    }

    @Override
    public void invalidateTask(int taskNumber) {
    }
}

