/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.Activity;
import fuego.papi.Comparison;
import fuego.papi.Filter;
import fuego.papi.FilterAttribute;
import fuego.papi.OperationException;
import fuego.papi.Participant;
import fuego.papi.Priority;
import fuego.papi.Process;
import fuego.papi.ProcessInstanceState;
import fuego.papi.ProcessServiceSession;
import fuego.papi.VarDefinition;
import fuego.papi.msg.PapiMsg;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;

public class FilterDescriptor {
    public static String getAttributesDescription(Filter filter, String[] assignedProcessIds, ProcessServiceSession session) {
        return FilterDescriptor.getAttributesDescription(filter, Arrays.asList(assignedProcessIds), session);
    }

    public static String getAttributesDescription(Filter filter, List<String> assignedProcessIds, ProcessServiceSession session) {
        return FilterDescriptor.getAttributesDescription(filter, assignedProcessIds, new SessionFilterDescriptionInfo(session));
    }

    public static String getAttributesDescription(Filter filter, List<String> assignedProcessIds, FilterDescriptionInformation information) {
        StringBuilder description = new StringBuilder();
        Map<String, List<FilterAttribute>> attributes = filter.getAttributesByVariable();
        if (!attributes.isEmpty()) {
            boolean concatenate = false;
            for (Map.Entry<String, List<FilterAttribute>> entry : attributes.entrySet()) {
                FilterAttribute actualAttribute;
                String variable = entry.getKey();
                VarDefinition varDefinition = information.getVariable(variable);
                if (varDefinition == null) continue;
                if (concatenate) {
                    if (filter.isMatchAll()) {
                        description.append(PapiMsg.AND.getString(information.getLocale()));
                    } else {
                        description.append(PapiMsg.OR.getString(information.getLocale()));
                    }
                }
                concatenate = true;
                List<FilterAttribute> attributeList = entry.getValue();
                int size = attributeList.size() - 1;
                if (size <= -1) continue;
                description.append(" (");
                for (int i = 0; i < size; ++i) {
                    actualAttribute = attributeList.get(i);
                    FilterAttribute nextAttribute = attributeList.get(i + 1);
                    description.append(FilterDescriptor.getAttributeExpresion(actualAttribute, varDefinition, assignedProcessIds, information));
                    description.append(" ");
                    description.append(FilterDescriptor.getSameAttributeConnector(actualAttribute.getComparison(), nextAttribute.getComparison(), information.getLocale()));
                    description.append(" ");
                }
                actualAttribute = attributeList.get(size);
                description.append(FilterDescriptor.getAttributeExpresion(actualAttribute, varDefinition, assignedProcessIds, information));
                description.append(") ");
            }
        }
        for (Filter subfilter : filter.getFilters()) {
            description.append(" ");
            if (filter.isMatchAll()) {
                description.append(PapiMsg.AND.getString(information.getLocale()));
            } else {
                description.append(PapiMsg.OR.getString(information.getLocale()));
            }
            description.append(" (");
            description.append(FilterDescriptor.getAttributesDescription(subfilter, assignedProcessIds, information));
            description.append(")");
        }
        return description.toString();
    }

    private static String getAttributeExpresion(FilterAttribute attribute, VarDefinition varDefinition, List processIds, FilterDescriptionInformation information) {
        StringBuilder expression = new StringBuilder(varDefinition.getLabel(information.getLocale()));
        expression.append(" ");
        expression.append(attribute.getComparison().getString(information.getLocale()));
        expression.append(" ");
        if (varDefinition.getId().equalsIgnoreCase("PREDEFINE_AUTHOR") || varDefinition.getId().equalsIgnoreCase("PREDEFINE_PARTICIPANT")) {
            Participant participant = information.getParticipant((String)attribute.getValue());
            if (participant != null) {
                expression.append(participant.getName());
            } else {
                expression.append(attribute.getValue());
            }
        } else if (varDefinition.getId().equalsIgnoreCase("PREDEFINE_PRIORITY")) {
            int priority = ((Number)attribute.getValue()).intValue();
            if (priority >= 1 && priority <= 5) {
                expression.append(Priority.getDescription(priority, information.getLocale()));
            } else {
                expression.append(Priority.getDescription(1, information.getLocale()));
            }
        } else if (varDefinition.getId().equalsIgnoreCase("PREDEFINE_ACTIVITY")) {
            String label = null;
            int size = processIds.size();
            for (int i = 0; i < size && label == null; ++i) {
                Process process = information.getProcess((String)processIds.get(i));
                if (process != null) {
                    Activity activity = process.getActivity((String)attribute.getValue());
                    if (activity == null) continue;
                    label = activity.getLabel(information.getLocale());
                    continue;
                }
                label = null;
            }
            if (label == null) {
                label = (String)attribute.getValue();
            }
            expression.append(label);
        } else if (varDefinition.getId().equalsIgnoreCase("PREDEFINE_STATUS")) {
            int status = ((Number)attribute.getValue()).intValue();
            expression.append(ProcessInstanceState.getDescription(status, information.getLocale()));
        } else if (attribute.getComparison() == Comparison.BETWEEN || attribute.getComparison() == Comparison.NOT_BETWEEN) {
            if (attribute.getKind() == 6) {
                Time[] time = (Time[])attribute.getValue();
                expression.append(FilterDescriptor.format(time[0], information.getLocale(), information.getTimezone()));
                expression.append(" ");
                expression.append(PapiMsg.AND.getString(information.getLocale()));
                expression.append(" ");
                expression.append(FilterDescriptor.format(time[1], information.getLocale(), information.getTimezone()));
            } else if (attribute.getKind() == 2 || attribute.getKind() == 4 || attribute.getKind() == 3) {
                Number[] number = (Number[])attribute.getValue();
                expression.append(number[0].toString());
                expression.append(" ");
                expression.append(PapiMsg.AND.getString(information.getLocale()));
                expression.append(" ");
                expression.append(number[1].toString());
            }
        } else if (varDefinition.getKind() == 6 && attribute.getValue() instanceof Time) {
            Time time = (Time)attribute.getValue();
            expression.append(FilterDescriptor.format(time, information.getLocale(), information.getTimezone()));
        } else if (varDefinition.getKind() == 7 || varDefinition.getKind() == 6 && attribute.getValue() instanceof Interval) {
            Interval interval = (Interval)attribute.getValue();
            String intervalDescription = "";
            if (interval.getYearsOnly() > 0) {
                intervalDescription = intervalDescription + interval.getYearsOnly() + " " + PapiMsg.YEAR.getString(information.getLocale()) + " ";
            }
            if (interval.getMonthsOnly() > 0) {
                intervalDescription = intervalDescription + interval.getMonthsOnly() + " " + PapiMsg.MONTH.getString(information.getLocale()) + " ";
            }
            if (interval.getDaysOnly() > 0) {
                intervalDescription = intervalDescription + interval.getDaysOnly() + " " + PapiMsg.DATE.getString(information.getLocale()) + " ";
            }
            if (interval.getHoursOnly() > 0) {
                intervalDescription = intervalDescription + interval.getHoursOnly() + " " + PapiMsg.HOUR.getString(information.getLocale()) + " ";
            }
            if (interval.getMinutesOnly() > 0) {
                intervalDescription = intervalDescription + interval.getMinutesOnly() + " " + PapiMsg.MINUTE.getString(information.getLocale());
            }
            expression.append(PapiMsg.NOW.getString(information.getLocale()));
            expression.append(" +/- ");
            expression.append(intervalDescription);
        } else {
            expression.append(attribute.getValue());
        }
        return expression.toString();
    }

    private static String getSameAttributeConnector(Comparison actualOperator, Comparison nextOperator, Locale locale) {
        boolean isAndConnector = true;
        if (actualOperator == Comparison.IS) {
            if (nextOperator == Comparison.IS) {
                isAndConnector = false;
            }
        } else if (actualOperator == Comparison.CONTAINS) {
            if (nextOperator == Comparison.CONTAINS) {
                isAndConnector = false;
            }
        } else if (actualOperator == Comparison.BEGIN_WITH) {
            if (nextOperator == Comparison.BEGIN_WITH) {
                isAndConnector = false;
            }
        } else if (actualOperator == Comparison.END_WITH) {
            if (nextOperator == Comparison.END_WITH) {
                isAndConnector = false;
            }
        } else if (actualOperator == Comparison.BEFORE) {
            if (nextOperator == Comparison.AFTER) {
                isAndConnector = false;
            }
        } else if (!(actualOperator != Comparison.LESS_THAN && actualOperator != Comparison.LESS_OR_EQUALS || nextOperator != Comparison.GREATER_THAN && nextOperator != Comparison.GREATER_OR_EQUALS)) {
            isAndConnector = false;
        }
        if (isAndConnector) {
            return PapiMsg.AND.getString(locale);
        }
        return PapiMsg.OR.getString(locale);
    }

    private static String format(Time time, Locale locale, TimeZone timezone) {
        return FilterDescriptor.format(time.dateValue(), locale, timezone);
    }

    private static String format(Date date, Locale locale, TimeZone timezone) {
        int format = 2;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(format, format, locale);
        dateFormat.setTimeZone(timezone);
        return dateFormat.format(date);
    }

    private static class SessionFilterDescriptionInfo
    implements FilterDescriptionInformation {
        private ProcessServiceSession session;

        public SessionFilterDescriptionInfo(ProcessServiceSession session) {
            this.session = session;
        }

        @Override
        public Locale getLocale() {
            try {
                return this.session.participantLocale();
            }
            catch (OperationException e) {
                return null;
            }
        }

        @Override
        public TimeZone getTimezone() {
            try {
                return this.session.participantTimeZone();
            }
            catch (OperationException e) {
                Log.logWarning(e);
                return TimeZone.getDefault();
            }
        }

        @Override
        public Participant getParticipant(String participantId) {
            try {
                return this.session.participantFind(participantId);
            }
            catch (OperationException exception) {
                return null;
            }
        }

        @Override
        public Process getProcess(String processId) {
            try {
                return this.session.processGet(processId);
            }
            catch (OperationException exception) {
                return null;
            }
        }

        @Override
        public VarDefinition getVariable(String variableId) {
            return this.session.variableGet(variableId);
        }
    }

    public static interface FilterDescriptionInformation {
        public Locale getLocale();

        public Participant getParticipant(String var1);

        public TimeZone getTimezone();

        public Process getProcess(String var1);

        public VarDefinition getVariable(String var1);
    }
}

