/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.utils;

import fuego.papi.Activity;
import fuego.papi.InstanceEvent;
import fuego.papi.InstanceId;
import fuego.papi.InstanceInfo;
import fuego.papi.InstanceItemState;
import fuego.papi.OperationException;
import fuego.papi.ProcessDiagram;
import fuego.papi.ProcessServiceSession;
import fuego.papi.collections.InstanceEventList;
import fuego.papi.msg.PapiMsg;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;

public class AuditTrail {
    protected String instanceId;
    protected ProcessServiceSession session;
    private StringActivityMap activities;
    private Map<String, List<ActivityInOut>> activitiesInOut;
    private int activityLoopIteration = 0;
    private int countNodeId = 0;
    private InstanceEventList events;
    private Map<Integer, CopyEvents> eventsByCopy;
    private Stack<AuditNodeIteration> group;
    private Map<String, AuditNode> hashNode = null;
    private int instanceIn;
    private AuditNode lastScope;
    private Locale locale;
    private StringActivityMap measurements;
    private String organization;
    private String processId;
    private AuditNode rootNode;
    private Map<String, InstanceEvent> startMessureNodes = null;
    private static final String SESSION_CLASS_ADAPTER_11G = "oracle.bpm.papi.ora.ProcessServiceSessionAdapter";
    private static final String AUDIT_TRAIL_FACTORY_11G = "oracle.bpm.papi.ora.util.AuditTrailFactory";
    public static final int ROOT_NODE = 0;
    public static final int THREAD_NODE = 1;
    public static final int ACTIVITY_NODE = 2;
    public static final int EVENT_NODE = 3;
    public static final int MEASUREMENT_START_NODE = 4;
    public static final int MEASUREMENT_STOP_NODE = 5;
    public static final int MEASUREMENT_START_STOP_NODE = 6;

    public AuditTrail(ProcessServiceSession session, String instanceId) throws OperationException {
        InstanceInfo instance = session.processGetInstance(instanceId);
        this.instanceId = instance.getId();
        this.hashNode = new HashMap<String, AuditNode>();
        this.processId = instance.getProcessId();
        this.instanceIn = instance.getInstanceIn();
        this.organization = null;
        this.activities = this.getActivities(session.processGet(this.processId).getActivities());
        this.locale = session.participantLocale();
        this.createRootNode(instance);
        this.measurements = this.getMeasurements(session.processGet(instance.getProcessId()).getMeasurements());
        this.session = session;
    }

    public AuditTrail(String instanceId, Activity[] activities, Locale locale) {
        this.hashNode = new HashMap<String, AuditNode>();
        this.instanceId = instanceId;
        this.processId = InstanceId.getProcessId(instanceId);
        this.organization = InstanceId.getOrganization(instanceId);
        this.instanceIn = InstanceId.getInstanceIn(instanceId);
        this.activities = this.getActivities(activities);
        this.locale = locale;
        this.createRootNode();
    }

    public static AuditTrail create(ProcessServiceSession session, String instanceId) throws OperationException {
        if (SESSION_CLASS_ADAPTER_11G.equalsIgnoreCase(session.getClass().getName())) {
            try {
                Class<?> clazz = Class.forName(AUDIT_TRAIL_FACTORY_11G, true, Thread.currentThread().getContextClassLoader());
                Factory factory = (Factory)clazz.newInstance();
                return factory.create(session, instanceId);
            }
            catch (Exception initCause) {
                throw new OperationException(initCause);
            }
        }
        return AuditTrail.create(session, instanceId);
    }

    public String getProcessId() {
        return this.processId;
    }

    public AuditNode getNode(String id) {
        return this.hashNode.get(id);
    }

    public AuditNode getRootNode() {
        return this.rootNode;
    }

    @Deprecated
    public void load(InstanceEvent[] instanceEvents) {
        ArrayList<InstanceEvent> listEvents = new ArrayList<InstanceEvent>();
        listEvents.addAll(Arrays.asList(instanceEvents));
        this.load(listEvents);
    }

    public void load(List<InstanceEvent> instanceEvents) {
        this.events = InstanceEventList.create(instanceEvents);
        if (instanceEvents != null && !instanceEvents.isEmpty()) {
            this.generateAuxiliars(instanceEvents);
            if (this.eventsByCopy != null && !this.eventsByCopy.isEmpty()) {
                this.generateTree(this.eventsByCopy.get(0), this.rootNode);
            }
            this.cleanAuxiliars();
        }
    }

    public void load(ProcessServiceSession processServiceSession) throws OperationException {
        InstanceInfo instance = processServiceSession.processGetInstance(this.instanceId);
        this.processId = instance.getProcessId();
        this.session = processServiceSession;
        this.createRootNode(instance);
        this.load(processServiceSession.instanceGetEvents(instance));
    }

    public void load() throws OperationException {
        if (this.session != null) {
            this.load(this.session);
        }
    }

    public Iterator iterator() {
        return this.getRootNode().getDescendants().iterator();
    }

    public void print(PrintStream out) {
        this.rootNode.print(out, "+--");
    }

    public String getImage(ProcessDiagram processDiagram) {
        return this.getImage(processDiagram, null);
    }

    public String getImage(ProcessDiagram processDiagram, Locale locale) {
        if (locale != null) {
            processDiagram.setLocale(locale);
        }
        processDiagram.highlightActivityPath(this.events);
        return processDiagram.getImage();
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    private void cleanAuxiliars() {
        this.group = null;
        this.eventsByCopy = null;
        this.activitiesInOut = null;
    }

    private StringActivityMap getActivities(Activity[] actArray) {
        StringActivityMap activityMap = new StringActivityMap();
        for (Activity activity : actArray) {
            activityMap.put(activity.getName(), activity);
        }
        return activityMap;
    }

    private Activity getActivity(String activity) {
        Activity result = (Activity)this.activities.get(activity);
        return result != null ? result : (Activity)this.measurements.get(activity);
    }

    private String getActivityInstanceStatus(Set<InstanceEvent> instanceEvents, String activity) {
        boolean isCompleted = false;
        for (InstanceEvent event : instanceEvents) {
            if (!event.getActivity().equalsIgnoreCase(activity) || event.getType() != 3 && event.getType() != 23 && event.getType() != 24 && event.getType() != 22 && event.getType() != 18 && event.getType() != 0 && event.getType() != 1 && event.getType() != 17 && event.getType() != 15) continue;
            isCompleted = true;
        }
        return isCompleted ? PapiMsg.ACTIVITY_COMPLETED.getString(this.locale) : PapiMsg.AUDIT_TRAIL_PROCESSING.getString(this.locale);
    }

    private Set<CopyEvents> getCreatedCopies(String activity, Time timeStamp) {
        TreeSet<CopyEvents> children = new TreeSet<CopyEvents>();
        ActivityInOut activityInOut = new ActivityInOut(activity);
        activityInOut.inTime = timeStamp;
        activityInOut.outTime = Time.now();
        List<ActivityInOut> listActivityInOut = this.activitiesInOut.get(activity);
        if (listActivityInOut != null) {
            for (ActivityInOut _activityInOut : listActivityInOut) {
                if (_activityInOut.inTime.compareTo(timeStamp) != 0) continue;
                activityInOut.outTime = _activityInOut.outTime;
                break;
            }
        }
        for (CopyEvents copyEvent : this.eventsByCopy.values()) {
            String createdActivity;
            if (copyEvent.getThread() <= 0 || copyEvent.wasProcessed() || (createdActivity = copyEvent.getCreatedActivity()) == null || !createdActivity.equalsIgnoreCase(activity) || copyEvent.getStartedTime().compareTo(activityInOut.inTime) < 0 || copyEvent.getStartedTime().compareTo(activityInOut.outTime) > 0) continue;
            copyEvent.process();
            children.add(copyEvent);
        }
        return children;
    }

    private String getInstanceStatus(Set<InstanceEvent> instanceEvents) {
        boolean isCompleted = false;
        boolean isAborted = false;
        InstanceEvent _event = null;
        for (InstanceEvent event : instanceEvents) {
            if (_event == null) {
                _event = event;
            }
            if (event.getType() == 1) {
                isCompleted = true;
                break;
            }
            if (event.getType() != 17 && event.getType() != 15) continue;
            isAborted = true;
            break;
        }
        return isCompleted ? PapiMsg.COMPLETED.getString(this.locale) : (isAborted ? PapiMsg.ABORTED.getString(this.locale) : PapiMsg.AUDIT_TRAIL_PROCESSING.getString(this.locale));
    }

    private StringActivityMap getMeasurements(Activity[] measurementActivities) {
        StringActivityMap result = new StringActivityMap();
        for (Activity activity : measurementActivities) {
            result.put(activity.getName(), activity);
        }
        return result;
    }

    private void addNodeToMap(AuditNode node) {
        this.hashNode.put(node.getId(), node);
        for (AuditNode auditNode : node.getChildren()) {
            this.addNodeToMap(auditNode);
        }
    }

    private AuditNode createNode(InstanceEvent event, int type, AuditNode parent) {
        String newId = this.processId + this.countNodeId;
        AuditNode ret = this.makeNode(event, type, parent, newId);
        this.hashNode.put(newId, ret);
        ++this.countNodeId;
        return ret;
    }

    private void createRootNode() {
        InstanceEvent event = new InstanceEvent();
        event.id = -1;
        event.processIn = -1;
        event.processId = InstanceId.getProcessId(this.instanceId);
        event.instanceIn = InstanceId.getInstanceIn(this.instanceId);
        event.threadIn = InstanceId.getThreadIn(this.instanceId);
        event.eventData = null;
        event.activity = null;
        event.participantId = null;
        event.participantIn = 0;
        event.timeStamp = null;
        event.type = -1;
        this.rootNode = this.createNode(event, 0, null);
    }

    private void createRootNode(InstanceInfo instance) {
        InstanceEvent event = new InstanceEvent();
        event.id = -1;
        event.processIn = -1;
        event.processId = instance.getProcessId();
        event.instanceIn = instance.getInstanceIn();
        event.threadIn = instance.getThreadIn();
        event.eventData = null;
        event.activity = null;
        event.participantId = null;
        event.participantIn = 0;
        event.timeStamp = null;
        event.type = -1;
        this.rootNode = this.createNode(event, 0, null);
    }

    private void generateCopyTree(CopyEvents copyEvents, AuditNode parent) {
        if (copyEvents != null && !copyEvents.isEmpty()) {
            String copyInstanceId;
            InstanceEvent firstEvent = copyEvents.events().iterator().next();
            InstanceEvent copyEvent = new InstanceEvent();
            copyEvent.type = -1;
            copyEvent.id = firstEvent.getId();
            copyEvent.processId = firstEvent.getProcessId();
            copyEvent.processIn = firstEvent.getProcessIn();
            copyEvent.instanceIn = firstEvent.getInstanceIn();
            copyEvent.threadIn = firstEvent.getThreadIn();
            copyEvent.timeStamp = firstEvent.getTimeStamp();
            copyEvent.activity = firstEvent.getActivity();
            copyEvent.eventData = firstEvent.getEventData();
            AuditNode copyNode = this.createNode(copyEvent, 1, parent);
            copyNode.description = copyInstanceId = InstanceId.makeId(this.processId, firstEvent.getInstanceIn(), firstEvent.getThreadIn());
            if (this.session != null) {
                try {
                    InstanceInfo copyInstance = this.session.processGetInstance(copyInstanceId);
                    copyNode.description = copyInstance.getDescription();
                }
                catch (OperationException ignore) {
                    // empty catch block
                }
            }
            copyNode.description = copyNode.description + this.copyDescription(firstEvent.getThreadIn());
            copyNode.nodeStatus = this.getInstanceStatus(copyEvents.events());
            parent.addChild(copyNode, this);
            this.generateTree(copyEvents, copyNode);
        }
    }

    private AuditNode generateMesureMarkNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
        AuditNode mesureMarkNode = new AuditNode(event, type, parent, idNode);
        InstanceEvent variableEvent = this.createEvent(25, event, event.eventData);
        switch (event.getType()) {
            case 22: {
                if (this.startMessureNodes == null) {
                    this.startMessureNodes = new HashMap<String, InstanceEvent>();
                }
                this.startMessureNodes.put(event.getActivity(), event);
                break;
            }
            case 23: {
                if (this.startMessureNodes == null) break;
                InstanceEvent startParent = this.startMessureNodes.get(event.eventData);
                if (startParent != null) {
                    Interval interval = Interval.valueOf(startParent.getTimeStamp().getMicroSeconds() - event.getTimeStamp().getMicroSeconds());
                    idNode = idNode + "0";
                    mesureMarkNode.addChild(new MeasureVariableNode(variableEvent, type, parent, idNode, PapiMsg.ELAPSED_TIME.getString(this.locale), interval), this);
                    break;
                }
                Log.logWarning(PapiMsg.LOG_0052(event.getEventData(), event.getActivity()));
            }
        }
        for (int i = 0; i < event.getBussinesVariablesIds().length; ++i) {
            idNode = idNode + Integer.toString(i);
            mesureMarkNode.addChild(new MeasureVariableNode(variableEvent, type, parent, idNode, event.getBussinesVariablesIds()[i], event.getBussinesVariablesValues()[i]), this);
        }
        return mesureMarkNode;
    }

    private void generateTree(CopyEvents copyEvents, AuditNode parent) {
        AuditNode groupNode;
        String parentInstanceId;
        if (copyEvents == null) {
            return;
        }
        copyEvents.process();
        if (copyEvents.isEmpty()) {
            return;
        }
        InstanceEvent firstEvent = copyEvents.iterator().next();
        parent.description = parentInstanceId = InstanceId.makeId(this.processId, firstEvent.getInstanceIn(), firstEvent.getThreadIn());
        if (this.session != null) {
            try {
                InstanceInfo parentInstance = this.session.processGetInstance(parentInstanceId);
                parent.description = parentInstance.getDescription();
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        parent.description = parent.description + this.copyDescription(firstEvent.getThreadIn());
        parent.nodeStatus = this.getInstanceStatus(copyEvents.events());
        String lastActivity = null;
        AuditNode activityNode = null;
        AuditNode iterationGroupNode = groupNode = parent;
        AuditNode parentEventNode = null;
        int activityGroupLoopIteration = 1;
        for (InstanceEvent event : copyEvents.events()) {
            String activityName;
            if (copyEvents.getThread() != 0) {
                for (CopyEvents olderEvents : this.getOlderCopyEvents(event.getThreadIn(), event.getTimeStamp())) {
                    this.generateCopyTree(olderEvents, groupNode);
                }
            }
            if (event.type == 27) continue;
            boolean createActivityIterationNode = false;
            Activity activity = this.getActivity(event.getActivity());
            String string = activityName = activity == null ? event.getActivity() : activity.getName();
            if (activity != null && activity.isLoopActivity() && activity.getType() != 65537) {
                if (lastActivity == null || !lastActivity.equals(activityName)) {
                    this.activityLoopIteration = 0;
                }
                if (event.getType() == 2) {
                    ++this.activityLoopIteration;
                    createActivityIterationNode = true;
                }
            }
            if ((activity == null || activity.getType() == 65537) && event.getType() == 3) {
                activityNode = groupNode;
                parentEventNode = activity != null && activity.isLoopActivity() ? (iterationGroupNode = this.group.pop().node) : activityNode;
                AuditNodeIteration auditNodeIteration = this.group.pop();
                groupNode = auditNodeIteration.node;
                activityGroupLoopIteration = auditNodeIteration.iteration + 1;
                this.lastScope = activityNode.parent;
            } else if (lastActivity == null || !lastActivity.equals(activityName)) {
                lastActivity = activityName;
                int activityNodeType = 2;
                if (event.getType() == 22) {
                    activityNodeType = 4;
                } else if (event.getType() == 23) {
                    activityNodeType = 5;
                } else if (event.getType() == 24) {
                    activityNodeType = 6;
                }
                if (this.lastScope == null || !activityName.equals(this.lastScope.getActivityName())) {
                    activityNode = this.createNode(this.createEvent(-1, event, " "), activityNodeType, groupNode);
                    activityNode.description = activity == null ? lastActivity : activity.getLabel(this.locale);
                    activityNode.nodeStatus = this.getActivityInstanceStatus(copyEvents.events(), lastActivity);
                    groupNode.addChild(activityNode, this);
                    parentEventNode = activityNode;
                } else {
                    activityNode = this.lastScope;
                }
                if (activity != null && activity.getType() == 65537 && event.getType() == 2 && activity.isLoopActivity()) {
                    iterationGroupNode = this.createNode(this.createEvent(-1, event, " "), -1, activityNode);
                    iterationGroupNode.setLoopActivity(true);
                    iterationGroupNode.description = PapiMsg.LOOP_ACTIVITY_ITERATION(activityGroupLoopIteration).getString(this.locale);
                    activityNode.addChild(iterationGroupNode, this);
                    parentEventNode = iterationGroupNode;
                }
                if (activity != null && (activity.hasType(129) || activity.hasType(65537)) && event.getType() == 2) {
                    for (CopyEvents _copyEvents : this.getCreatedCopies(activity.getName(), event.getTimeStamp())) {
                        this.generateCopyTree(_copyEvents, activityNode);
                    }
                }
            }
            AuditNode eventNode = this.createNode(event, 3, parentEventNode);
            if (activity != null && activity.getType() != 65537 && activity.isLoopActivity() && createActivityIterationNode) {
                AuditNode activityIterationGroupNode = this.createNode(this.createEvent(-1, event, " "), -1, activityNode);
                activityIterationGroupNode.setLoopActivity(true);
                activityIterationGroupNode.description = PapiMsg.LOOP_ACTIVITY_ITERATION(this.activityLoopIteration).getString(this.locale);
                activityNode.addChild(activityIterationGroupNode, this);
                parentEventNode = activityIterationGroupNode;
            }
            parentEventNode.addChild(eventNode, this);
            if ((activity == null || activity.getType() == 65537) && event.getType() == 2) {
                AuditNodeIteration auditNodeIteration = new AuditNodeIteration(groupNode, activityGroupLoopIteration);
                this.group.push(auditNodeIteration);
                groupNode = activityNode;
                if (activity != null && activity.isLoopActivity()) {
                    this.group.push(new AuditNodeIteration(iterationGroupNode, -1));
                    groupNode = iterationGroupNode;
                }
            }
            if (event.getType() != 2) continue;
            this.lastScope = null;
        }
    }

    private String copyDescription(int threadIn) {
        return threadIn == 0 ? "" : " - " + PapiMsg.COPY.getString() + " " + threadIn;
    }

    private InstanceEvent createEvent(int eventType, InstanceEvent event, String eventData) {
        InstanceEvent result = new InstanceEvent();
        result.id = event.getId();
        result.processId = event.getProcessId();
        result.processIn = event.getProcessIn();
        result.instanceIn = event.getInstanceIn();
        result.threadIn = event.getThreadIn();
        result.timeStamp = event.getTimeStamp();
        result.activity = event.getActivity();
        result.eventData = eventData;
        result.type = eventType;
        return result;
    }

    private AuditNode makeNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
        if (type == 3) {
            switch (event.getType()) {
                case 7: {
                    return new ItemExecutedNode(event, type, parent, idNode);
                }
                case 5: {
                    return new ItemSelectedNode(event, type, parent, idNode);
                }
                case 6: {
                    return new ItemUnselectedNode(event, type, parent, idNode);
                }
                case 14: {
                    return new SubFlowNode(event, type, parent, idNode);
                }
                case 28: {
                    return new ExceptionNode(event, type, parent, idNode);
                }
            }
        }
        if (event.getType() == 22 || event.getType() == 24 || event.getType() == 23) {
            return this.generateMesureMarkNode(event, type, parent, idNode);
        }
        return new AuditNode(event, type, parent, idNode);
    }

    private Set<CopyEvents> getOlderCopyEvents(int parentThread, Time timestamp) {
        TreeSet<CopyEvents> children = new TreeSet<CopyEvents>();
        for (CopyEvents copyEvents : this.eventsByCopy.values()) {
            if (timestamp.compareTo(copyEvents.getStartedTime()) <= 0 || copyEvents.wasProcessed()) continue;
            if (this.session != null) {
                try {
                    InstanceInfo instance = this.session.processGetInstance(InstanceId.makeId(this.processId, this.instanceIn, copyEvents.getThread()));
                    if (instance.getParentThreadIn() == parentThread) {
                        children.add(copyEvents);
                        continue;
                    }
                    CopyEvents parentEvents = this.eventsByCopy.get(instance.getParentThreadIn());
                    if (!parentEvents.wasProcessed()) continue;
                    children.add(copyEvents);
                }
                catch (OperationException operationException) {
                    children.add(copyEvents);
                }
                continue;
            }
            children.add(copyEvents);
        }
        return children;
    }

    private void generateAuxiliars(List<InstanceEvent> instanceEvents) {
        this.group = new Stack();
        this.eventsByCopy = new TreeMap<Integer, CopyEvents>();
        this.activitiesInOut = new TreeMap<String, List<ActivityInOut>>(String.CASE_INSENSITIVE_ORDER);
        for (InstanceEvent event : instanceEvents) {
            List<ActivityInOut> listActivityInOut;
            if (event == null) continue;
            CopyEvents copyEvents = this.eventsByCopy.get(event.getThreadIn());
            if (copyEvents == null) {
                copyEvents = new CopyEvents(event.getThreadIn());
                this.eventsByCopy.put(copyEvents.getThread(), copyEvents);
            }
            copyEvents.add(event);
            if (event.getType() == 2) {
                listActivityInOut = this.activitiesInOut.get(event.getActivity());
                if (listActivityInOut == null) {
                    listActivityInOut = new ArrayList<ActivityInOut>();
                    this.activitiesInOut.put(event.getActivity(), listActivityInOut);
                }
                ActivityInOut activityInOut = new ActivityInOut(event.getActivity());
                activityInOut.inTime = event.getTimeStamp();
                listActivityInOut.add(activityInOut);
                continue;
            }
            if (event.getType() != 3 || (listActivityInOut = this.activitiesInOut.get(event.getActivity())) == null || listActivityInOut.isEmpty()) continue;
            int last = listActivityInOut.size() - 1;
            ActivityInOut activityInOut = listActivityInOut.get(last);
            if (activityInOut.outTime != null) continue;
            activityInOut.outTime = event.getTimeStamp();
        }
    }

    private static class StringActivityMap
    extends HashMap<String, Activity> {
        static final long serialVersionUID = 3341989323230597492L;
        static final long serialCheck = -4966494068518823438L;

        private StringActivityMap() {
        }
    }

    private static class CopyEvents
    implements Iterable<InstanceEvent>,
    Comparable<CopyEvents> {
        private String createdActivity;
        private Set<InstanceEvent> events;
        private int thread;
        private boolean wasProcessed;

        public CopyEvents(int thread) {
            this.thread = thread;
            this.events = new TreeSet<InstanceEvent>(new EventsComparator());
            this.wasProcessed = false;
        }

        public int getThread() {
            return this.thread;
        }

        @Override
        public Iterator<InstanceEvent> iterator() {
            return this.events.iterator();
        }

        public void add(InstanceEvent event) {
            if (event != null) {
                this.events.add(event);
                if (event.type == 0) {
                    this.createdActivity = event.activity;
                }
            }
        }

        public void remove(InstanceEvent event) {
            this.events.remove(event);
        }

        public String getCreatedActivity() {
            return this.createdActivity;
        }

        public Time getStartedTime() {
            if (this.events != null && this.events.iterator().hasNext()) {
                InstanceEvent firstEvent = this.events.iterator().next();
                return firstEvent.timeStamp;
            }
            return Time.now();
        }

        public void process() {
            this.wasProcessed = true;
        }

        public boolean wasProcessed() {
            return this.wasProcessed;
        }

        public boolean isEmpty() {
            return this.events == null || this.events.size() < 1;
        }

        public int size() {
            if (this.events == null) {
                return 0;
            }
            return this.events.size();
        }

        public Set<InstanceEvent> events() {
            return this.events;
        }

        @Override
        public int compareTo(CopyEvents comparator) {
            return this.getThread() - comparator.getThread();
        }

        private static class EventsComparator
        implements Comparator<InstanceEvent> {
            private EventsComparator() {
            }

            @Override
            public int compare(InstanceEvent left, InstanceEvent right) {
                if (left == null && right == null) {
                    return 0;
                }
                if (right == null) {
                    return 1;
                }
                if (left == null) {
                    return -1;
                }
                int compareTime = left.getTimeStamp().compareTo(right.getTimeStamp());
                return compareTime == 0 ? left.id - right.id : compareTime;
            }
        }
    }

    private static class AuditNodeIteration {
        public int iteration;
        public AuditNode node;

        public AuditNodeIteration(AuditNode node, int iteration) {
            this.node = node;
            this.iteration = iteration;
        }
    }

    private static class ActivityInOut
    implements Comparable<ActivityInOut> {
        public Time inTime = null;
        public Time outTime = null;
        private String activity;

        public ActivityInOut(String activity) {
            this.activity = activity;
        }

        public String getActivity() {
            return this.activity;
        }

        @Override
        public int compareTo(ActivityInOut comparator) {
            if (this.inTime == null) {
                return 1;
            }
            if (comparator.inTime == null) {
                return -1;
            }
            return this.inTime.compareTo(comparator.inTime);
        }
    }

    public class TransitionNode
    extends AuditNode {
        private String activityFrom;
        private String activityTo;
        private String rule;
        private String transitionType;

        protected TransitionNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.parseEventData();
        }

        public String getActivityFrom() {
            return this.activityFrom;
        }

        public String getActivityTo() {
            return this.activityTo;
        }

        public String getTransitionType() {
            return this.transitionType;
        }

        public String getRuleName() {
            return this.rule;
        }

        private void parseEventData() {
            this.transitionType = this.event.getEventDataValue("TYPE");
            this.activityFrom = this.event.getEventDataValue("FROM");
            this.activityTo = this.event.getEventDataValue("TO");
            this.rule = this.event.getEventDataValue("RULE");
        }
    }

    public class SubFlowNode
    extends AuditNode {
        private String childInstanceId;

        protected SubFlowNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.getChildInstanceIdFromEvent(event);
            if (AuditTrail.this.session != null) {
                try {
                    InstanceInfo childInstance = AuditTrail.this.session.processGetInstance(this.childInstanceId);
                    this.description = childInstance.getDescription();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        }

        public String getChildInstanceId() {
            return this.childInstanceId;
        }

        private void getChildInstanceIdFromEvent(InstanceEvent _event) {
            this.childInstanceId = _event.getEventData();
            String childOrganization = InstanceId.getOrganization(this.childInstanceId);
            if (childOrganization == null && AuditTrail.this.organization != null) {
                String childProcessId = InstanceId.getProcessId(this.childInstanceId);
                int childInstanceIn = InstanceId.getInstanceIn(this.childInstanceId);
                int childThreadIn = InstanceId.getThreadIn(this.childInstanceId);
                this.childInstanceId = InstanceId.makeGlobalId(AuditTrail.this.organization, childProcessId, childInstanceIn, childThreadIn);
            }
            this.description = this.childInstanceId;
        }
    }

    public class MeasureVariableNode
    extends AuditNode {
        protected String variableName;
        protected Object variableValue;

        public MeasureVariableNode(InstanceEvent event, int type, AuditNode parent, String idNode, String variableName, Object variableValue) {
            super(event, type, parent, idNode);
            this.variableName = variableName;
            this.variableValue = variableValue;
        }

        @Override
        public String getEvent() {
            return this.toString();
        }

        public void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public void setVariableValue(Object variableValue) {
            this.variableValue = variableValue;
        }

        public Object getVariableValue() {
            return this.variableValue;
        }

        public String toString() {
            String varValue = this.variableValue == null ? "" : this.variableValue.toString();
            return "'" + this.variableName + "' = " + varValue;
        }
    }

    public class ItemUnselectedNode
    extends AuditNode {
        private int taskNumber;

        protected ItemUnselectedNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.taskNumber = -1;
            this.parseEventData();
        }

        public int getTaskNumber() {
            return this.taskNumber;
        }

        private void parseEventData() {
            String taskNumberStr = this.event.getEventDataValue("ITEMIN");
            if (taskNumberStr != null && taskNumberStr.trim().length() > 0) {
                try {
                    this.taskNumber = Integer.parseInt(taskNumberStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.taskNumber = -1;
                }
            }
        }
    }

    public class ItemSelectedNode
    extends AuditNode {
        private int taskNumber;

        protected ItemSelectedNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.taskNumber = -1;
            this.parseEventData();
        }

        public int getTaskNumber() {
            return this.taskNumber;
        }

        private void parseEventData() {
            String taskNumberStr = this.event.getEventDataValue("ITEMIN");
            if (taskNumberStr != null && taskNumberStr.trim().length() > 0) {
                try {
                    this.taskNumber = Integer.parseInt(taskNumberStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.taskNumber = -1;
                }
            }
        }
    }

    public class ItemExecutedNode
    extends AuditNode {
        private String taskName;
        private int taskNumber;
        private String taskResult;
        private int taskState;

        protected ItemExecutedNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.taskName = null;
            this.taskNumber = -1;
            this.taskResult = null;
            this.taskState = -1;
            this.parseEventData();
        }

        public int getTaskExecuted() {
            return this.taskNumber;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public String getTaskResult() {
            return this.taskResult;
        }

        public int getTaskState() {
            return this.taskState;
        }

        public boolean taskFailed() {
            return InstanceItemState.is(this.taskState, 2);
        }

        private void parseEventData() {
            String taskStateStr;
            String taskNumberStr = this.event.getEventDataValue("ITEMIN");
            if (taskNumberStr != null && taskNumberStr.trim().length() > 0) {
                try {
                    this.taskNumber = Integer.parseInt(taskNumberStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.taskNumber = -1;
                }
            }
            if ((taskStateStr = this.event.getEventDataValue("STATE")) != null && taskStateStr.trim().length() > 0) {
                try {
                    this.taskState = Integer.parseInt(taskStateStr.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.taskState = 0;
                }
            }
            this.taskName = this.event.getEventDataValue("ITEMID");
            this.taskResult = this.event.getEventDataValue("RESULT");
        }
    }

    public class ExceptionNode
    extends AuditNode {
        private String exception;

        protected ExceptionNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
            this.parseEventData();
        }

        public String getException() {
            return this.exception;
        }

        @Override
        public String getEvent() {
            return this.toString();
        }

        public String toString() {
            return this.event.getDescription(AuditTrail.this.locale) + ": " + this.getException();
        }

        private void parseEventData() {
            this.exception = this.event.getEventDataValue("EXCEPTION");
        }
    }

    public class AuditNode11g
    extends AuditNode {
        public AuditNode11g(InstanceEvent event, int type, AuditNode parent, String idNode) {
            super(event, type, parent, idNode);
        }

        public void addChild(AuditNode node) {
            node.parent = this;
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(node);
        }

        protected Locale getLocale() {
            return AuditTrail.this.locale;
        }
    }

    public class AuditNode {
        protected int activityType;
        protected List<AuditNode> children;
        protected String description;
        protected InstanceEvent event;
        protected String idNode;
        protected String nodeStatus;
        protected AuditNode parent;
        protected int type;
        private boolean expanded;
        private boolean loopActivity;
        private boolean subflowLoaded;
        private boolean visible;

        protected AuditNode(InstanceEvent event, int type, AuditNode parent, String idNode) {
            this.event = event;
            this.type = type;
            this.parent = parent;
            this.visible = false;
            this.expanded = false;
            this.idNode = idNode;
            this.subflowLoaded = false;
        }

        public boolean isLoopActivity() {
            return this.loopActivity;
        }

        public void setLoopActivity(boolean loopActivity) {
            this.loopActivity = loopActivity;
        }

        public String getActivityName() {
            return this.event.getActivity();
        }

        public int getActivityType() {
            Activity activity = (Activity)AuditTrail.this.activities.get(this.event.activity);
            return activity == null ? 65537 : activity.getType();
        }

        public List<AuditNode> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<AuditNode>();
            }
            return this.children;
        }

        public List<AuditNode> getDescendants() {
            ArrayList<AuditNode> descendants = new ArrayList<AuditNode>();
            descendants.add(this);
            for (AuditNode node : this.getChildren()) {
                descendants.addAll(node.getDescendants());
            }
            return descendants;
        }

        public String getDescription() {
            return this.description;
        }

        public String getEvent() {
            if (this.event.getType() == -1) {
                return this.nodeStatus;
            }
            if (this.event.getType() == 20) {
                return this.getEventData();
            }
            if (this.event.getType() >= 0) {
                return this.event.getDescription(AuditTrail.this.locale);
            }
            return " ";
        }

        public String getEventData() {
            return this.event.getEventData() == null ? "" : this.event.getEventData();
        }

        public int getEventType() {
            return this.event.getType();
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public String getId() {
            return this.idNode;
        }

        public int getInstanceCopy() {
            return this.event.getThreadIn();
        }

        public int getInstanceIn() {
            return this.event.getInstanceIn();
        }

        public boolean isLeaf() {
            return this.event.type != 14 && this.getChildren().isEmpty();
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public AuditNode getParent() {
            return this.parent;
        }

        public String getParticipant() {
            return this.event.getParticipantId();
        }

        public String getPath() {
            if (this.getParent() == null) {
                return this.description;
            }
            return this.getParent().getPath() + ";" + this.description;
        }

        public String getProcessId() {
            return this.event.getProcessId();
        }

        public void setSubflowLoaded(boolean subflowLoaded) {
            this.subflowLoaded = subflowLoaded;
        }

        public boolean isSubflowLoaded() {
            return this.subflowLoaded;
        }

        public Time getTimeStamp() {
            return this.event.getTimeStamp();
        }

        public int getType() {
            return this.type;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void addChildren(List<AuditNode> childNodes, AuditTrail auditTrail) {
            for (AuditNode node : childNodes) {
                this.addChild(node, auditTrail);
            }
        }

        public void collapse() {
            this.expanded = false;
            for (AuditNode node : this.getChildren()) {
                node.hide();
                if (!node.isExpanded()) continue;
                node.collapse();
            }
        }

        public void expand() {
            this.expanded = true;
            for (AuditNode node : this.getChildren()) {
                node.show();
            }
        }

        public void expandAll() {
            this.expanded = true;
            for (AuditNode node : this.getChildren()) {
                node.show();
                node.expandAll();
            }
        }

        public void hide() {
            this.visible = false;
        }

        public void print(PrintStream out, String space) {
            out.println(space + " " + this.getDescription() + " -> " + this.getEvent() + " : " + this.getEventData());
            for (AuditNode node : this.getChildren()) {
                node.print(out, space + "+--");
            }
        }

        public void show() {
            this.visible = true;
        }

        protected void addChild(AuditNode node, AuditTrail auditTrail) {
            node.parent = this;
            if (this.children == null) {
                this.children = new ArrayList<AuditNode>();
            }
            this.children.add(node);
            auditTrail.addNodeToMap(node);
        }

        protected void removeChild(AuditNode node) {
            if (this.children != null) {
                this.children.remove(node);
            }
        }
    }

    public static interface Factory {
        public AuditTrail create(ProcessServiceSession var1, String var2) throws OperationException;
    }
}

