/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi.attachment.config;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import oracle.bpm.log.Log;
import oracle.bpm.xml.XmlWriter;
import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class AttachmentConfigMappingInfo {
    private String externalFolderId;
    private String externalFolderName;
    private String externalProjectId;
    private String externalProjectName;
    private static final String ELEMENT_MAPPINGINFO = "processMappingInfo";
    private static final String ELEMENT_EXTERNAL_PROJECTID = "externalProjectId";
    private static final String ELEMENT_EXTERNAL_PROJECTNAME = "externalProjectName";
    private static final String ELEMENT_EXTERNAL_FOLDERID = "externalFolderId";
    private static final String ELEMENT_EXTERNAL_FOLDERNAME = "externalFolderName";

    public AttachmentConfigMappingInfo(String externalProjectId, String externalProjectName, String externalFolderId, String externalFolderName) {
        this.externalProjectName = externalProjectName;
        this.externalProjectId = externalProjectId;
        this.externalFolderName = externalFolderName;
        this.externalFolderId = externalFolderId;
    }

    private AttachmentConfigMappingInfo() {
    }

    public static AttachmentConfigMappingInfo createFromXml(String xml) {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        return builder.loadFromXml(xml);
    }

    public String getExternalProjectId() {
        return this.externalProjectId;
    }

    public String getExternalFolderId() {
        return this.externalFolderId;
    }

    public String getExternalFolderName() {
        return this.externalFolderName;
    }

    public String getExternalProjectName() {
        return this.externalProjectName;
    }

    public String toXml() {
        StringWriter writer = new StringWriter();
        XmlWriter xmlWriter = new XmlWriter(writer, "UTF-8");
        try {
            xmlWriter.startDocument();
            xmlWriter.startElement(ELEMENT_MAPPINGINFO);
            xmlWriter.printValuedElement(ELEMENT_EXTERNAL_PROJECTID, this.externalProjectId);
            xmlWriter.printValuedElement(ELEMENT_EXTERNAL_PROJECTNAME, this.externalProjectName);
            xmlWriter.printValuedElement(ELEMENT_EXTERNAL_FOLDERID, this.externalFolderId);
            xmlWriter.printValuedElement(ELEMENT_EXTERNAL_FOLDERNAME, this.externalFolderName);
            xmlWriter.endElement();
            xmlWriter.flush();
        }
        catch (IOException e) {
            Log.logWarning(e);
            throw new RuntimeException(e);
        }
        return ((Object)writer).toString();
    }

    public String toString() {
        return this.toXml();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentConfigMappingInfo that = (AttachmentConfigMappingInfo)o;
        if (this.externalFolderId != null ? !this.externalFolderId.equals(that.externalFolderId) : that.externalFolderId != null) {
            return false;
        }
        if (this.externalFolderName != null ? !this.externalFolderName.equals(that.externalFolderName) : that.externalFolderName != null) {
            return false;
        }
        if (this.externalProjectId != null ? !this.externalProjectId.equals(that.externalProjectId) : that.externalProjectId != null) {
            return false;
        }
        return !(this.externalProjectName != null ? !this.externalProjectName.equals(that.externalProjectName) : that.externalProjectName != null);
    }

    public int hashCode() {
        int result = this.externalFolderName != null ? this.externalFolderName.hashCode() : 0;
        result = 31 * result + (this.externalFolderId != null ? this.externalFolderId.hashCode() : 0);
        result = 31 * result + (this.externalProjectName != null ? this.externalProjectName.hashCode() : 0);
        result = 31 * result + (this.externalProjectId != null ? this.externalProjectId.hashCode() : 0);
        return result;
    }

    public static class ProcessInfoBuilder {
        private String externalFolderId;
        private String externalFolderName;
        private String externalProjectId;
        private String externalProjectName;

        public AttachmentConfigMappingInfo createInstance() {
            return new AttachmentConfigMappingInfo(this.externalProjectId, this.externalProjectName, this.externalFolderId, this.externalFolderName);
        }

        public void setExternalFolderId(String externalFolderId) {
            this.externalFolderId = externalFolderId;
        }

        public void setExternalProjectId(String externalProjectId) {
            this.externalProjectId = externalProjectId;
        }

        public void setExternalFolderName(String externalFolderName) {
            this.externalFolderName = externalFolderName;
        }

        public void setExternalProjectName(String externalProjectName) {
            this.externalProjectName = externalProjectName;
        }

        public AttachmentConfigMappingInfo loadFromXml(String xml) {
            Digester digester = new Digester();
            digester.setValidating(false);
            this.setRules(digester);
            Object parsedObject = null;
            try {
                StringReader reader = new StringReader(xml);
                parsedObject = digester.parse((Reader)reader);
            }
            catch (IOException e) {
                Log.logWarning(e);
                throw new RuntimeException("Problem parsing ProcessMapping info", e);
            }
            catch (SAXException e) {
                Log.logWarning(e);
                throw new RuntimeException("Problem parsing ProcessMapping info", e);
            }
            AttachmentConfigMappingInfo info = null;
            ProcessInfoBuilder builder = null;
            if (parsedObject != null && parsedObject instanceof ProcessInfoBuilder) {
                builder = (ProcessInfoBuilder)parsedObject;
            }
            info = builder != null ? builder.createInstance() : null;
            return info;
        }

        private void setRules(Digester digester) {
            digester.addObjectCreate(AttachmentConfigMappingInfo.ELEMENT_MAPPINGINFO, ProcessInfoBuilder.class);
            digester.addBeanPropertySetter("processMappingInfo/externalProjectId", AttachmentConfigMappingInfo.ELEMENT_EXTERNAL_PROJECTID);
            digester.addBeanPropertySetter("processMappingInfo/externalProjectName", AttachmentConfigMappingInfo.ELEMENT_EXTERNAL_PROJECTNAME);
            digester.addBeanPropertySetter("processMappingInfo/externalFolderId", AttachmentConfigMappingInfo.ELEMENT_EXTERNAL_FOLDERID);
            digester.addBeanPropertySetter("processMappingInfo/externalFolderName", AttachmentConfigMappingInfo.ELEMENT_EXTERNAL_FOLDERNAME);
        }
    }
}

