/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.msg.PapiMsg;
import java.util.Locale;
import oracle.bpm.component.metadata.Component;
import oracle.bpm.component.metadata.Exclude;
import oracle.bpm.lang.EnumType;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NonNls;

@Component(module="Fuego.Lib")
public class ProcessInstanceState
implements EnumType {
    public static final int NONE = 0;
    public static final int RUNNING = 1;
    public static final int EXCEPTION = 2;
    public static final int SUSPENDED = 3;
    public static final int GRABBED = 4;
    public static final int COMPLETED = 5;
    public static final int ABORTED = 6;
    public static final int ACTIVITY_COMPLETED = 7;
    @NonNls
    private static final String[] names_sd = new String[]{"NONE", "RUNNING", "EXCEPTION", "SUSPENDED", "GRABBED", "COMPLETED", "ABORTED", "ACTIVITY_COMPLETED"};
    private static int[] values_sd = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final Msg[] msgs = new Msg[]{PapiMsg.NONE, PapiMsg.INSTANCE_RUNNING, PapiMsg.EXCEPTION, PapiMsg.SUSPENDED, PapiMsg.GRABBED, PapiMsg.COMPLETED, PapiMsg.ABORTED, PapiMsg.ACTIVITY_COMPLETED};

    public static String getDescription(int state, Locale locale) {
        if (state > -1 && state < names_sd.length) {
            return msgs[state].getString(locale);
        }
        throw new IllegalArgumentException("state: " + state);
    }

    public static String getId(int val) {
        if (val <= -1 || val >= names_sd.length) {
            throw new IllegalArgumentException("val: " + val);
        }
        return names_sd[val];
    }

    @Exclude
    public static int[] getLocaleGrabValues() {
        int[] values = values_sd;
        int[] grabValues = new int[values.length - 3];
        int index = 0;
        for (int value : values) {
            if (value == 5 || value == 6 || value == 4) continue;
            grabValues[index++] = value;
        }
        return grabValues;
    }

    public static int valueOf(String id) {
        if (id != null) {
            for (int i = 0; i < names_sd.length; ++i) {
                if (!names_sd[i].equalsIgnoreCase(id)) continue;
                return i;
            }
        }
        return -1;
    }

    public static int[] getValues() {
        return values_sd;
    }
}

