/*
 * Decompiled with CFR 0.152.
 */
package fuego.papi;

import fuego.papi.InstanceInfo;
import java.io.Serializable;
import oracle.bpm.component.metadata.Exclude;

public class InstanceId
implements Comparable,
Serializable {
    protected int instanceIn;
    protected transient String processId;
    protected int processIn;
    protected int threadIn;
    public static final String NAME_SEPARATOR = "/";
    public static final String ORGANIZATION_SEPARATOR = "@";
    static final long serialCheck = 1162978575814345142L;
    static final long serialVersionUID = 1000001050315543901L;

    @Exclude
    public InstanceId(int processIn, int instanceIn, int threadIn) {
        this.processIn = processIn;
        this.instanceIn = instanceIn;
        this.threadIn = threadIn;
    }

    @Exclude
    protected InstanceId() {
    }

    public static InstanceId getInstanceId(InstanceInfo instanceInfo) {
        return new InstanceId(instanceInfo.getProcessIn(), instanceInfo.getInstanceIn(), instanceInfo.getThreadIn());
    }

    public static int compare(InstanceId leftInstanceId, InstanceId rightInstanceId) {
        if (leftInstanceId == rightInstanceId) {
            return 0;
        }
        if (leftInstanceId == null) {
            return -1;
        }
        if (rightInstanceId == null) {
            return 1;
        }
        return leftInstanceId.processIn > rightInstanceId.processIn ? 1 : (leftInstanceId.processIn < rightInstanceId.processIn ? -1 : (leftInstanceId.instanceIn > rightInstanceId.instanceIn ? 1 : (leftInstanceId.instanceIn < rightInstanceId.instanceIn ? -1 : (leftInstanceId.threadIn > rightInstanceId.threadIn ? 1 : (leftInstanceId.threadIn < rightInstanceId.threadIn ? -1 : 0)))));
    }

    public static boolean equals(InstanceId leftInstanceId, InstanceId rightInstanceId) {
        return leftInstanceId == rightInstanceId || leftInstanceId != null && rightInstanceId != null && leftInstanceId.processIn == rightInstanceId.processIn && leftInstanceId.instanceIn == rightInstanceId.instanceIn && leftInstanceId.threadIn == rightInstanceId.threadIn;
    }

    public static String getInstanceId(String globalInstanceId) {
        int index = globalInstanceId.indexOf(ORGANIZATION_SEPARATOR);
        if (index < 1) {
            return globalInstanceId;
        }
        return globalInstanceId.substring(0, index);
    }

    public static String getLocalInstanceId(String globalInstanceId) {
        int index = globalInstanceId.indexOf(ORGANIZATION_SEPARATOR);
        if (index < 1) {
            return globalInstanceId;
        }
        return globalInstanceId.substring(0, index);
    }

    public static int getInstanceIn(String instanceId) {
        String auxIn = InstanceId.getInstanceId(instanceId);
        int index = auxIn.lastIndexOf(NAME_SEPARATOR);
        if (index < 0) {
            return -1;
        }
        if ((index = (auxIn = auxIn.substring(0, index)).lastIndexOf(NAME_SEPARATOR)) < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(auxIn.substring(index + 1));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getOrganization(String globalInstanceId) {
        if (globalInstanceId == null) {
            return null;
        }
        int index = globalInstanceId.lastIndexOf(ORGANIZATION_SEPARATOR);
        if (index < 0) {
            return null;
        }
        return globalInstanceId.substring(index + 1);
    }

    public static String getProcessId(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        String organization = InstanceId.getOrganization(instanceId);
        String localProcessId = InstanceId.getLocalProcessId(instanceId);
        return organization == null ? localProcessId : localProcessId + ORGANIZATION_SEPARATOR + organization;
    }

    public static String getLocalProcessId(String instanceId) {
        if (instanceId == null) {
            return null;
        }
        String localInstanceId = InstanceId.getLocalInstanceId(instanceId);
        if (InstanceId.isProcessId(localInstanceId)) {
            return localInstanceId;
        }
        int index = localInstanceId.lastIndexOf(NAME_SEPARATOR);
        if (index < 0) {
            return null;
        }
        String localInstanceIdWithoutThread = localInstanceId.substring(0, index);
        if ((index = localInstanceIdWithoutThread.lastIndexOf(NAME_SEPARATOR)) < 0) {
            return null;
        }
        return localInstanceIdWithoutThread.substring(0, index);
    }

    public static boolean isProcessId(String instanceOrProcessId) {
        if (instanceOrProcessId == null) {
            return false;
        }
        String localInstanceOrProcessId = InstanceId.getLocalInstanceId(instanceOrProcessId);
        int index = localInstanceOrProcessId.lastIndexOf(NAME_SEPARATOR);
        if (index != -1) {
            String end = localInstanceOrProcessId.substring(index + 1);
            return end.length() > 0 && !Character.isDigit(end.charAt(0));
        }
        return false;
    }

    public static int getThreadIn(String instanceId) {
        int index = (instanceId = InstanceId.getInstanceId(instanceId)).lastIndexOf(NAME_SEPARATOR);
        if (index < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(instanceId.substring(index + 1));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static boolean isValidInstanceId(String instanceId) {
        return InstanceId.getProcessId(instanceId) != null && InstanceId.getInstanceIn(instanceId) != -1 && InstanceId.getThreadIn(instanceId) != -1;
    }

    public static String makeGlobalId(String organization, String processId, int instanceIn) {
        return InstanceId.makeId(processId, instanceIn) + ORGANIZATION_SEPARATOR + organization;
    }

    public static String makeGlobalId(String organization, String processId, int instanceIn, int threadIn) {
        return InstanceId.makeId(processId, instanceIn, threadIn) + ORGANIZATION_SEPARATOR + organization;
    }

    public static String makeId(String processId, int instanceIn) {
        return InstanceId.makeId(processId, instanceIn, 0);
    }

    public static String makeId(String processId, int instanceIn, int threadIn) {
        String org = null;
        int p = processId.lastIndexOf(ORGANIZATION_SEPARATOR);
        if (p != -1) {
            org = processId.substring(p);
            processId = processId.substring(0, p);
        }
        return processId + NAME_SEPARATOR + instanceIn + NAME_SEPARATOR + threadIn + (org != null ? org : "");
    }

    public final int getInstanceIn() {
        return this.instanceIn;
    }

    public final int getProcessIn() {
        return this.processIn;
    }

    public final int getThreadIn() {
        return this.threadIn;
    }

    public boolean equals(Object obj) {
        return obj instanceof InstanceId && InstanceId.equals(this, (InstanceId)obj);
    }

    public final int compareTo(Object obj) {
        return InstanceId.compare(this, (InstanceId)obj);
    }

    public int hashCode() {
        return this.processIn << 24 ^ this.instanceIn << 8 ^ this.threadIn;
    }

    public String makeId(String _processId) {
        return InstanceId.makeId(_processId, this.instanceIn, this.threadIn);
    }

    public String toString() {
        return "(" + this.getProcessIn() + "," + this.getInstanceIn() + "," + this.getThreadIn() + ")";
    }
}

