/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.util.swing;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.configuration.ConfigurationManager;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.spi.ConfigurationEditorPanel;
import oracle.bpm.configuration.spi.swing.ConfigurationEditorListener;
import oracle.bpm.connector.msg.ConnectorMsg;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;

public abstract class AbstractConfigurationEditor
extends Panel
implements ConfigurationEditorPanel {
    private ConfigurationEditorBean configurationEditorBean;
    private List<ConfigurationEditorListener> listeners;
    private ConfigurationManager<ExternalResource> manager;

    protected AbstractConfigurationEditor(UiContainer parent) {
        super(parent, ConnectorMsg.DETAILS);
    }

    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        this.configurationEditorBean = configurationEditorBean;
    }

    public void setConfigurationManager(ConfigurationManager manager) {
        this.manager = manager;
    }

    public ConfigurationManager<ExternalResource> getConfigurationManager() {
        return this.manager;
    }

    public Panel getEditPanel(UiContainer parent) {
        return this;
    }

    public List<ConfigurationEditorListener> getEditorListeners() {
        return this.listeners;
    }

    public void validateInput() throws InvalidConfigurationException {
    }

    public void validateInputWithBean() throws InvalidConfigurationException {
        this.synchronizeBean();
        this.getEditorBean().validate();
    }

    public void addEditorListener(ConfigurationEditorListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationEditorListener>();
        }
        this.listeners.add(listener);
    }

    public void apply() {
    }

    protected ConfigurationEditorBean getEditorBean() {
        return this.configurationEditorBean;
    }

    protected void firePropertiesChanged() {
        if (this.listeners != null) {
            int listenerCount = this.listeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                ConfigurationEditorListener swingEditorListener = this.listeners.get(i);
                swingEditorListener.configurationChanged();
            }
        }
    }

    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractConfigurationEditor.this.firePropertiesChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractConfigurationEditor.this.firePropertiesChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractConfigurationEditor.this.firePropertiesChanged();
            }
        };
    }

    protected ItemListener createItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AbstractConfigurationEditor.this.firePropertiesChanged();
            }
        };
    }
}

