/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.impl.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.configuration.ConfigType;
import oracle.bpm.configuration.Configuration;
import oracle.bpm.connector.impl.GenericJdbc1ConfigType;
import oracle.bpm.connector.impl.RemoteJdbcConfigType;
import oracle.bpm.geom.Dimension;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;

public final class Utils {
    public static ConfigLabelProvider createConfigLabelProvider() {
        return new ConfigLabelProvider();
    }

    public static ComboBox createConfigurationsCombo(UiContainer parent, Collection configurations) {
        ArrayList list = new ArrayList(configurations);
        ComboBox combo = UiFactory.createComboBox(parent, list);
        combo.setPreferredSize(Dimension.valueOf(150, 20));
        combo.setLabelProvider(Utils.createConfigLabelProvider());
        combo.sortList(list);
        return combo;
    }

    public static ComboBox createEmptySubTypesCombo(UiContainer parent, List list) {
        ComboBox combo = UiFactory.createMutableComboBox(parent, list);
        combo.setLabelProvider(new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                String result;
                if (element instanceof ConfigType) {
                    ConfigType subtype = (ConfigType)element;
                    Msg msg = subtype.getMsg();
                    assert (msg != null) : subtype + " has null message";
                    ConfigType parent = subtype.getParent();
                    result = parent != null && msg.equals(parent.getMsg()) ? subtype.getName() : msg.getDetail();
                } else {
                    result = String.valueOf(element);
                }
                return result;
            }
        });
        return combo;
    }

    public static ComboBox createMutableSubTypesCombo(UiContainer parent, ConfigType type) {
        return Utils.createSubTypesComboImpl(parent, type.getSubTypes(), true);
    }

    public static ComboBox createSubTypesCombo(UiContainer parent, ConfigType type) {
        return Utils.createSubTypesComboImpl(parent, type.getSubTypes(), false);
    }

    public static ComboBox createTypesCombo(UiContainer parent, List<ConfigType> filteredTypesList) {
        Collections.sort(filteredTypesList, new ConfigTypeComparator());
        ComboBox<ConfigType> combo = UiFactory.createComboBox(parent, filteredTypesList);
        combo.setLabelProvider(new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                String result;
                if (element instanceof ConfigType) {
                    ConfigType config = (ConfigType)element;
                    Msg msg = config.getMsg();
                    assert (msg != null) : config.getClass();
                    String descripion = msg.getDetail();
                    if (descripion == null || descripion.length() == 0) {
                        descripion = msg.getString();
                    }
                    result = descripion;
                } else {
                    result = String.valueOf(element);
                }
                return result;
            }
        });
        return combo;
    }

    public static ComboBox createTypesCombo(UiContainer parent) {
        return Utils.createTypesCombo(parent, ConfigType.getAccesibleTypes());
    }

    public static List<ConfigType> getOrganizationTypeList() {
        ArrayList<ConfigType> orgList = new ArrayList<ConfigType>();
        List<ConfigType> configTypes = ConfigType.getTypes();
        for (ConfigType configType : configTypes) {
            if (!configType.hasSubTypes()) {
                if (!configType.supports(0x4000000L)) continue;
                orgList.add(configType);
                continue;
            }
            List<ConfigType> orgSubTypes = configType.getSubTypesThatSupports(0x4000000L);
            for (ConfigType subtype : orgSubTypes) {
                if (subtype.equals(RemoteJdbcConfigType.get()) || subtype.equals(GenericJdbc1ConfigType.get())) continue;
                orgList.add(subtype);
            }
        }
        return orgList;
    }

    private static ComboBox createSubTypesComboImpl(UiContainer parent, List<ConfigType> list, boolean mutable) {
        Collections.sort(list, new ConfigTypeComparator());
        ComboBox<ConfigType> combo = mutable ? UiFactory.createMutableComboBox(parent, list) : UiFactory.createComboBox(parent, list);
        combo.setLabelProvider(new LabelProvider.Default(){

            @Override
            public String getText(Object element) {
                ConfigType subtype;
                Msg msg;
                String result = element instanceof ConfigType ? ((msg = (subtype = (ConfigType)element).getMsg()).equals(subtype.getParent().getMsg()) ? subtype.getName() : subtype.getMsg().getDetail()) : String.valueOf(element);
                return result;
            }
        });
        if (list.size() > 0) {
            combo.setSelectedItem(list.get(0));
        }
        return combo;
    }

    private static class ConfigTypeComparator
    implements Comparator<ConfigType> {
        private ConfigTypeComparator() {
        }

        @Override
        public int compare(ConfigType o1, ConfigType o2) {
            String s1;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String string = o1.getMsg() != null ? (o1.getMsg().getDetail() != null ? o1.getMsg().getDetail() : o1.toString()) : (s1 = o1.toString());
            String s2 = o2.getMsg() != null ? (o2.getMsg().getDetail() != null ? o2.getMsg().getDetail() : o2.toString()) : o2.toString();
            return s1.compareTo(s2);
        }
    }

    private static class ConfigLabelProvider
    extends LabelProvider.Default {
        private ConfigLabelProvider() {
        }

        @Override
        public String getText(Object element) {
            Configuration config = (Configuration)element;
            return config.getName();
        }
    }
}

