/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.connector.impl.ServerConfiguration;
import oracle.bpm.geom.Insets;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Separator;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;

public class ServerConfigurationEditor
extends AbstractConfigurationEditor {
    private CheckBox authRequiredCheck;
    private TextField hostNameField;
    private Label passwordLabel;
    private TextField passwordTextField;
    private TextField pathField;
    private NumericField<Integer> portField;
    private ComboBox protocolComboBox;
    private NumericField<Integer> timeoutField;
    private TextField urlField;
    private Label userLabel;
    private TextField usernameTextField;
    private static final int MAX_TIMEOUT_LIMIT = 600;
    private static final int MIN_TIMEOUT_LIMIT = 0;
    private static final int MAXIMUM_PORT = 65535;
    private static final int MINIMUM_PORT = 1;

    public ServerConfigurationEditor(UiContainer parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        Panel fieldsPanel = new Panel(this);
        fieldsPanel.setLayout(new GridBagLayout());
        Object[] values = ServerConfiguration.getProtocolsList().toArray();
        this.protocolComboBox = UiFactory.createComboBox((UiContainer)fieldsPanel, values);
        this.protocolComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerConfigurationEditor.this.changeDefaultPort();
                ServerConfigurationEditor.this.firePropertiesChanged();
            }
        });
        this.hostNameField = new TextField(fieldsPanel);
        this.portField = NumericField.createIntegerNumericField(fieldsPanel);
        this.portField.setRange(1, 65535);
        this.pathField = new TextField(fieldsPanel);
        this.authRequiredCheck = CheckBox.create((UiContainer)fieldsPanel, new BaseAction(LibMsg.REQUIRES_AUTH){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerConfigurationEditor.this.updateAuthenticationPanel();
                ServerConfigurationEditor.this.firePropertiesChanged();
            }
        });
        this.userLabel = Label.create((UiContainer)fieldsPanel, LibMsg.USER);
        this.passwordLabel = Label.create((UiContainer)fieldsPanel, LibMsg.PASSWORD);
        this.usernameTextField = new TextField(fieldsPanel);
        this.passwordTextField = new PasswordField(fieldsPanel);
        this.userLabel.setEnabled(false);
        this.passwordLabel.setEnabled(false);
        this.urlField = new TextField(fieldsPanel);
        this.urlField.setEditable(false);
        this.urlField.setEnabled(false);
        this.timeoutField = NumericField.createIntegerNumericField(fieldsPanel);
        this.timeoutField.setRange(0, 600);
        this.protocolComboBox.addItemListener(this.createItemListener());
        this.hostNameField.addDocumentListener(this.createDocumentListener());
        this.portField.addDocumentListener(this.createDocumentListener());
        this.pathField.addDocumentListener(this.createDocumentListener());
        this.usernameTextField.addDocumentListener(this.createDocumentListener());
        this.passwordTextField.addDocumentListener(this.createDocumentListener());
        this.timeoutField.addDocumentListener(this.createDocumentListener());
        this.layoutComponents(fieldsPanel);
        this.add(fieldsPanel, "North");
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        ServerConfiguration bean = (ServerConfiguration)configurationEditorBean;
        String protocol = bean.getProtocol();
        String host = bean.getHost();
        int port = bean.getPort();
        String path = bean.getPath();
        String username = bean.getUsername();
        String password = bean.getPassword();
        boolean enabledAuth = false;
        int timeout = bean.getTimeout();
        if (!(username == null || password == null || "".equals(username) && "".equals(password))) {
            enabledAuth = true;
            this.usernameTextField.setText(username);
            this.passwordTextField.setText(password);
        }
        this.authRequiredCheck.setSelected(enabledAuth);
        this.updateAuthenticationPanel();
        this.portField.setValue(port);
        this.pathField.setText(path);
        this.protocolComboBox.setSelectedItem(protocol);
        this.hostNameField.setText(host);
        this.timeoutField.setValue(timeout);
    }

    public void synchronizeBean() {
        ServerConfiguration bean = (ServerConfiguration)this.getEditorBean();
        String protocol = (String)this.protocolComboBox.getSelectedItem();
        String hostName = this.hostNameField.getText();
        int port = this.portField.getValue();
        String path = this.pathField.getText() != null ? this.pathField.getText() : "";
        Integer timeout = this.timeoutField.getValue();
        String username = "";
        String password = "";
        boolean authReq = this.authRequiredCheck.isSelected();
        if (authReq) {
            username = this.usernameTextField.getText();
            password = this.passwordTextField.getText();
        }
        bean.setTimeout(timeout);
        bean.setRequiredHttpBasicAuth(authReq);
        bean.setUsername(username);
        bean.setPassword(password);
        bean.setProtocol(protocol);
        bean.setPort(port);
        bean.setHost(hostName);
        bean.setPath(path);
    }

    @Override
    protected void firePropertiesChanged() {
        super.firePropertiesChanged();
        String fullUrl = this.buildFullUrl();
        this.urlField.setText(fullUrl);
    }

    private void changeDefaultPort() {
        String protocol = (String)this.protocolComboBox.getSelectedItem();
        int port = this.portField.getValue();
        if ("http".equals(protocol) && 443 == port) {
            this.portField.setValue(80);
        }
        if ("https".equals(protocol) && 80 == port) {
            this.portField.setValue(443);
        }
    }

    private String buildFullUrl() {
        String protocol = (String)this.protocolComboBox.getSelectedItem();
        String hostName = this.hostNameField.getText();
        int port = this.portField.getValue();
        String path = this.pathField.getText() != null ? this.pathField.getText() : "";
        path = ServerConfiguration.formatPath(path);
        StringBuilder fullUrl = new StringBuilder();
        fullUrl.append(protocol);
        fullUrl.append("://");
        fullUrl.append(hostName);
        fullUrl.append(":");
        fullUrl.append(port);
        fullUrl.append(path);
        return fullUrl.toString();
    }

    private void layoutComponents(Panel fieldsPanel) {
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.PROTOCOL), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.protocolComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.HOST), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.hostNameField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.PORT), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.portField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.PATH), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.pathField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.URL), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.urlField, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 10, 2, 2), 0, 0));
        fieldsPanel.add(new Separator(fieldsPanel, Separator.HORIZONTAL), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.authRequiredCheck, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.userLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 10, 2, 2), 0, 0));
        fieldsPanel.add(this.usernameTextField, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.passwordLabel, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 10, 2, 2), 0, 0));
        fieldsPanel.add(this.passwordTextField, new GridBagConstraints(1, 9, 1, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create(fieldsPanel), new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.CONNECTION_TIMEOUT), new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(this.timeoutField, new GridBagConstraints(1, 11, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(new Separator(fieldsPanel, Separator.HORIZONTAL), new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
        fieldsPanel.add(Label.create((UiContainer)fieldsPanel, LibMsg.PATH_USE_LABEL), new GridBagConstraints(0, 13, 2, 1, 0.0, 0.0, 18, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void updateAuthenticationPanel() {
        boolean enabled = this.authRequiredCheck.isSelected();
        this.usernameTextField.setEnabled(enabled);
        this.passwordTextField.setEnabled(enabled);
        this.userLabel.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
    }
}

