/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.collections.lists.StringList;
import oracle.bpm.configuration.JarRepository;
import oracle.bpm.configuration.editor.JarLibraryComponent;
import oracle.bpm.configuration.impl.JavaClassLibraryConfiguration;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.spi.swing.ConfigurationEditorListener;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.ExternalResource;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.border.BorderLayout;

public class JavaClassLibraryConfigurationEditor
extends AbstractConfigurationEditor {
    private JarLibraryComponent jarLibraryComponent;
    private StringList jarLibraryModel;
    private CheckBox versionable;

    public JavaClassLibraryConfigurationEditor(UiContainer parent) {
        super(parent);
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        JavaClassLibraryConfiguration bean = (JavaClassLibraryConfiguration)configurationEditorBean;
        JarRepository<ExternalResource> jarRepository = new JarRepository<ExternalResource>(this.getConfigurationManager().getLibDir(), this.getConfigurationManager());
        this.jarLibraryModel = StringList.create(bean.getFileNames());
        this.rebuildViewController(jarRepository);
        this.versionable.setSelected(bean.isVersionable());
    }

    @Override
    public void apply() {
        this.jarLibraryComponent.commit();
    }

    public void synchronizeBean() {
        JavaClassLibraryConfiguration bean = (JavaClassLibraryConfiguration)this.getEditorBean();
        bean.setFileNames(this.jarLibraryModel.clone());
        bean.setVersionable(this.versionable.isSelected());
    }

    private void rebuildViewController(JarRepository jarRepository) {
        this.removeAll();
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.versionable = CheckBox.create((UiContainer)this, LibMsg.JCL_VERSIONABLE);
        this.jarLibraryComponent = new JarLibraryComponent(this, this.jarLibraryModel, jarRepository);
        this.versionable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JavaClassLibraryConfigurationEditor.this.firePropertiesChanged();
            }
        });
        this.jarLibraryComponent.addListener(new ConfigurationEditorListener(){

            @Override
            public void configurationChanged() {
                JavaClassLibraryConfigurationEditor.this.firePropertiesChanged();
            }
        });
        this.add(this.versionable, "North");
        this.add(this.jarLibraryComponent, "Center");
        this.revalidate();
    }
}

