/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.configuration.editor.JarRepositoryModel;
import oracle.bpm.configuration.editor.JarRepositoryRealModel;

public class JarRepositoryWorkingModel
implements JarRepositoryModel {
    private Map<String, File> entries;
    private JarRepositoryRealModel jarRepositoryRealModel;
    private StringList removed;

    public JarRepositoryWorkingModel(JarRepositoryRealModel jarRepositoryRealModel) {
        this.jarRepositoryRealModel = jarRepositoryRealModel;
        this.entries = new HashMap<String, File>();
        this.removed = StringList.create();
    }

    @Override
    public String addJarFile(File newJarFile) {
        String jar = newJarFile.getName();
        this.removed.remove(jar);
        this.entries.put(jar, newJarFile);
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit() {
        boolean applied = true;
        JarRepositoryRealModel jarRepositoryRealModel = this.jarRepositoryRealModel;
        synchronized (jarRepositoryRealModel) {
            for (File file : this.entries.values()) {
                applied &= this.jarRepositoryRealModel.addJarFile(file) != null;
            }
            for (String jar : this.removed) {
                applied &= this.jarRepositoryRealModel.deleteJar(jar);
            }
        }
        if (applied) {
            this.reload();
        }
        return applied;
    }

    @Override
    public boolean deleteJar(String jar) {
        boolean result;
        boolean bl = result = this.entries.remove(jar) == null;
        if (result) {
            this.removed.add(jar);
        }
        return result;
    }

    @Override
    public boolean existsJar(String jar) {
        return this.entries.get(jar) != null || this.jarRepositoryRealModel.existsJar(jar) && !this.removed.contains(jar);
    }

    @Override
    public List<File> listJars() {
        return this.jarRepositoryRealModel.listJars();
    }

    @Override
    public void reload() {
        this.reset();
        for (File file : this.jarRepositoryRealModel.listJarFiles()) {
            this.addJarFile(file);
        }
    }

    private void reset() {
        this.entries.clear();
        this.removed.clear();
    }
}

