/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.io.File;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.configuration.JarRepository;
import oracle.bpm.configuration.editor.JarLibraryComponentModel;
import oracle.bpm.configuration.editor.JarRepositoryModel;
import oracle.bpm.configuration.editor.JarRepositoryRealModel;
import oracle.bpm.configuration.editor.JarRepositoryWorkingModel;
import oracle.bpm.configuration.spi.swing.ConfigurationEditorListener;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.util.CommonPreferences;
import oracle.bpm.util.FileFilter;

public class JarLibraryComponent
extends Panel {
    private JarRepository jarRepository;
    private JarRepositoryModel jarRepositoryModel;
    private JarLibraryComponentModel jclComponentModel;
    private StringList jclModel;
    private ConfigurationEditorListener listener;
    private static FileFilter JAREXTENSIONFILTER = FileFilter.create(UIMsg.JAR_LIBRARIES, ".zip", ".jar");

    protected JarLibraryComponent(UiContainer parent, StringList jclModel, JarRepository jarRepository) {
        super(parent);
        this.jarRepository = jarRepository;
        this.buildModel(jclModel, jarRepository);
        this.buildUI();
    }

    public void addListener(ConfigurationEditorListener configurationEditorListener) {
        this.listener = configurationEditorListener;
    }

    public void commit() {
        this.jarRepositoryModel.commit();
    }

    public void performAdd(File jarFile) {
        String jarName = jarFile.getName();
        if (!this.jarRepository.isValid(jarFile)) {
            throw new IllegalArgumentException(LibMsg.INVALID_JAR(jarFile.getAbsolutePath()).toString());
        }
        if (this.jarRepositoryModel.existsJar(jarName)) {
            if (!this.jclModel.contains(jarName)) {
                throw new RuntimeException(LibMsg.JCLEDITOR_JAR_ALREADY_EXISTS.toString());
            }
            int option = MessageDialog.showQuestion(this.getOwnerWindow(), LibMsg.JCLEDITOR_JAR_ALREADY_EXISTS_TITLE, LibMsg.JCLEDITOR_JAR_ALREADY_EXISTS_REPLACE(jarName), null, 6, null);
            if (option != 2) {
                return;
            }
            this.jarRepositoryModel.deleteJar(jarName);
            this.jclModel.remove(jarName);
            this.jclComponentModel.removeItem(jarName);
        }
        String jar = this.jarRepositoryModel.addJarFile(jarFile);
        if (!this.jclModel.contains(jarName)) {
            this.jclModel.add(jar);
        }
        this.jclComponentModel.addItem(jar, true);
        this.jclComponentModel.setExistence(jar, true);
    }

    protected UiComponent buildTable(UiContainer parent) {
        return new BaseTablePanel(parent, UIMsg.JAR_LIBRARIES, null, this.jclComponentModel){

            @Override
            protected void addAction() {
                Msg title;
                FileChooser jFileChooser = JarLibraryComponent.this.buildFileChooser();
                int result = jFileChooser.showOpenDialog(JarLibraryComponent.this, title = UIMsg.TO_MSG(LibMsg.JCLEDITOR_PROJECT_JAR_REPOSITORY + ": " + LibMsg.JCLEDITOR_SELECT_FILES_TO_ADD), 1);
                if (result == 0) {
                    File[] files = jFileChooser.getSelectedFiles();
                    if (files.length > 0) {
                        CommonPreferences.getInstance().setLastJCLUsedDir(files[0].getParent());
                    }
                    try {
                        for (File file : files) {
                            if (!file.exists()) continue;
                            try {
                                JarLibraryComponent.this.performAdd(file);
                            }
                            catch (RuntimeException e) {
                                MessageDialog.showError(e);
                            }
                        }
                        JarLibraryComponent.this.listener.configurationChanged();
                    }
                    catch (Exception exception) {
                        MessageDialog.showError(LibMsg.JCLEDITOR_PROJECT_JAR_REPOSITORY, LibMsg.JCLEDITOR_ADDING_FILES_TO_PROJECT_REPOSITORY_ERROR, exception);
                    }
                }
            }

            @Override
            protected void deleteAction() {
                int[] selectedRows = this.getTable().getSelectedRows();
                if (selectedRows.length > 0) {
                    Object[] selectedObjects = new Object[selectedRows.length];
                    for (int i = 0; i < selectedRows.length; ++i) {
                        selectedObjects[i] = this.getTable().getValueAt(selectedRows[i], 0);
                    }
                    JarLibraryComponent.this.performRemoveSelected(selectedObjects);
                }
            }
        };
    }

    private void performRemoveSelected(Object[] selectedObjects) {
        if (selectedObjects != null) {
            for (Object element : selectedObjects) {
                String jar = (String)element;
                this.jarRepositoryModel.deleteJar(jar);
                this.jclModel.remove(jar);
                this.jclComponentModel.removeItem(jar);
                this.listener.configurationChanged();
            }
        }
    }

    private FileChooser buildFileChooser() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setName("jar.directory");
        fileChooser.setFileFilter(JAREXTENSIONFILTER);
        fileChooser.setSelectedFiles(new File[0]);
        return fileChooser;
    }

    private void buildModel(StringList jclModel, JarRepository jarRepository) {
        this.jclModel = jclModel;
        this.jarRepositoryModel = new JarRepositoryWorkingModel(new JarRepositoryRealModel(jarRepository));
        this.jclComponentModel = new JarLibraryComponentModel();
        this.reloadComponentModel();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        UiComponent table = this.buildTable(this);
        this.add(table, "Center");
    }

    private void reloadComponentModel() {
        this.jclComponentModel.setEnabled(false);
        this.jclComponentModel.reset();
        for (String jar : this.jclModel) {
            this.jclComponentModel.addItem(jar, false);
        }
        for (File file : this.jarRepositoryModel.listJars()) {
            if (!this.jclComponentModel.hasItem(file.getName())) continue;
            this.jclComponentModel.setExistence(file.getName(), true);
        }
        this.jclComponentModel.setEnabled(true);
    }
}

