/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import oracle.bpm.configuration.editor.AbstractPoolConfigurationEditor;
import oracle.bpm.configuration.exception.InvalidConfigurationException;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.connector.impl.JDBC1Configuration;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.PasswordField;
import oracle.bpm.ui.text.TextField;

public class JDBC1ConfigurationEditor
extends AbstractPoolConfigurationEditor {
    private TextField driverField;
    private PasswordField passwordField;
    private TextField urlField;
    private TextField userField;

    public JDBC1ConfigurationEditor(UiContainer parent) {
        super(parent);
        Panel fieldsPanel = new Panel(this.tabbedPane);
        fieldsPanel.setLayout(new GridBagLayout());
        this.driverField = new TextField(fieldsPanel);
        this.urlField = new TextField(fieldsPanel);
        this.userField = new TextField(fieldsPanel);
        this.passwordField = new PasswordField(fieldsPanel);
        DocumentListener documentListener = this.createDocumentListener();
        this.driverField.addDocumentListener(documentListener);
        this.urlField.addDocumentListener(documentListener);
        this.userField.addDocumentListener(documentListener);
        this.passwordField.addDocumentListener(documentListener);
        this.layoutComponents(fieldsPanel);
        this.addTab(UIMsg.BASIC, fieldsPanel);
        this.addPropertiesPanel();
        this.addRuntimeTab();
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        JDBC1Configuration bean = (JDBC1Configuration)configurationEditorBean;
        this.driverField.setText(bean.getDriverClassName());
        this.urlField.setText(bean.getUrl());
        this.userField.setText(bean.getUser());
        this.passwordField.setText(bean.getPassword());
        this.databasePropertiesPanel.add(bean.getAdditionalProperties());
        this.databasePropertiesPanel.setDefaultProperties(bean.getDefaultConnectionProperties());
    }

    @Override
    public void synchronizeBean() {
        JDBC1Configuration bean = (JDBC1Configuration)this.getEditorBean();
        bean.setDriverClassName(this.driverField.getText());
        bean.setUrl(this.urlField.getText());
        bean.setUser(this.userField.getText());
        bean.setPassword(String.valueOf(this.passwordField.getPassword()));
        bean.getAdditionalProperties().clear();
        bean.setAdditionalProperties(this.databasePropertiesPanel.getVisualProperties());
    }

    @Override
    public void validateInput() throws InvalidConfigurationException {
        if ("".equals(this.driverField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.INITIAL_CONTEXT_FACTORY_EMPTY);
        }
        if ("".equals(this.urlField.getText().trim())) {
            throw InvalidConfigurationException.validationFailed(LibMsg.URL_EMPTY);
        }
    }

    private void layoutComponents(Panel fieldsPanel) {
        String colSpecs = "10dlu,pref,10dlu,60dlu,100dlu";
        String rowSpecs = "10dlu,pref,10dlu,pref,10dlu,pref,10dlu,pref";
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        fieldsPanel.setLayout(layout);
        PanelBuilder builder = layout.createBuilder(fieldsPanel);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)fieldsPanel, LibMsg.JDBC_DRIVER), cc.xy(2, 2));
        builder.add((UiComponent)this.driverField, cc.xyw(4, 2, 2));
        builder.add((UiComponent)Label.create((UiContainer)fieldsPanel, LibMsg.URL), cc.xy(2, 4));
        builder.add((UiComponent)this.urlField, cc.xyw(4, 4, 2));
        builder.add((UiComponent)Label.create((UiContainer)fieldsPanel, LibMsg.USER), cc.xy(2, 6));
        builder.add((UiComponent)this.userField, cc.xy(4, 6));
        builder.add((UiComponent)Label.create((UiContainer)fieldsPanel, LibMsg.PASSWORD), cc.xy(2, 8));
        builder.add((UiComponent)this.passwordField, cc.xy(4, 8));
    }
}

