/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.configuration.editor.AbstractPoolConfigurationEditor;
import oracle.bpm.connector.msg.ConnectorMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.TableModelEvent;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.text.TextField;

public class DatabasePropertiesPanel
extends BaseTablePanel {
    private AbstractPoolConfigurationEditor databaseConfiguration;
    private Properties defaultProperties;

    public DatabasePropertiesPanel(UiContainer parent, Properties defaultProperties, final AbstractPoolConfigurationEditor databaseConfiguration) {
        super(parent, LibMsg.PROPERTIES);
        this.setModel(new TablePropertiesModel());
        this.defaultProperties = defaultProperties;
        this.databaseConfiguration = databaseConfiguration;
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                databaseConfiguration.aditionalPropertiesChanged();
            }
        });
    }

    public void setDefaultProperties(Properties properties) {
        this.defaultProperties = properties;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.updateActions(this.getSelectedObjects().size());
        }
    }

    public Properties getVisualProperties() {
        Properties properties = new Properties();
        TablePropertiesModel model = this.getModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            properties.put(model.getValueAt(i, 0), model.getValueAt(i, 1));
        }
        return properties;
    }

    public void add(Properties properties) {
        String value;
        String key;
        this.getModel().removeAllElements();
        for (Map.Entry<Object, Object> entry1 : this.defaultProperties.entrySet()) {
            key = (String)entry1.getKey();
            value = (String)entry1.getValue();
            if (properties.containsKey(key)) continue;
            properties.put(key, value);
        }
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            key = (String)entry2.getKey();
            value = (String)entry2.getValue();
            Entry newEntry = Entry.create(key, value);
            this.addItem(newEntry);
        }
    }

    @Override
    protected void addAction() {
        Entry entry = this.showInputDialog();
        if (entry == null) {
            return;
        }
        TablePropertiesModel model = this.getModel();
        int rows = model.getRowCount();
        for (int i = 0; i < rows; ++i) {
            Entry e = (Entry)model.getRow(i);
            if (!e.getKey().equals(entry.getKey())) continue;
            MessageDialog.showError(ConnectorMsg.DUPLICATED_PROPERTY, ConnectorMsg.DUPLICATED_PROPERTY);
            return;
        }
        model.insertRow(entry);
    }

    @Override
    protected TablePropertiesModel getModel() {
        return (TablePropertiesModel)super.getModel();
    }

    private Entry showInputDialog() {
        PropertyDialog dialog = new PropertyDialog(this.getOwnerWindow());
        dialog.setVisible(true);
        return dialog.getEntry();
    }

    private boolean isProtectedProperty(Object propertyKey) {
        return this.defaultProperties.containsKey(propertyKey);
    }

    private Entry getSelectedObject() {
        int row = this.getTable().getSelectedRow();
        return row != -1 ? (Entry)this.getModel().getRow(row) : null;
    }

    private List<Entry> getSelectedObjects() {
        return this.getModel().getRows(this.getTable().getSelectedRows());
    }

    private void addItem(Entry entry) {
        int row = this.getTable().getSelectedRow();
        this.getModel().insertRow(entry);
        if (row >= 0) {
            this.getTable().setSelectionInterval(row, row);
        }
    }

    private void updateActions(int rows) {
        boolean isSingleSelection = rows == 1;
        Entry entry = this.getSelectedObject();
        boolean isProtected = false;
        if (entry != null) {
            String key = entry.getKey();
            isProtected = this.isProtectedProperty(key);
        }
        this.getRemoveAction().setEnabled(isSingleSelection && !isProtected);
        this.databaseConfiguration.aditionalPropertiesChanged();
    }

    private class TablePropertiesModel
    extends ProviderTableModel<Entry> {
        private static final int COLUMN_KEY = 0;

        TablePropertiesModel() {
            super(MsgList.create(CoreMsg.NAME, CoreMsg.VALUE));
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            boolean cellEditable = true;
            if (column == 0) {
                Object key = this.getValueAt(row, 0);
                cellEditable = !DatabasePropertiesPanel.this.isProtectedProperty(key);
            }
            return cellEditable;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Entry row1 = (Entry)this.getRow(row);
            if (row1 == null) {
                return null;
            }
            return column == 0 ? row1.getKey() : row1.getValue();
        }

        void insertRow(Entry entry) {
            this.addRow(entry);
        }

        void removeRow(Entry entry) {
            this.removeRow(this.getRowIndex(entry));
        }
    }

    private static class PropertyDialog
    extends OkCancelDialog {
        private Entry entry;
        private TextField nameField;
        private TextField valueField;

        public PropertyDialog(UiWindow parent) {
            super(parent, ConnectorMsg.ADD_PROPERTY, true);
            this.build();
        }

        @Override
        public void ok() {
            this.setUserAccepted(true);
            if (!"".equals(this.nameField.getText().trim())) {
                this.entry = new Entry(this.nameField.getText(), this.valueField.getText());
            }
            this.close();
        }

        public Entry getEntry() {
            return this.entry;
        }

        private void build() {
            this.getContentPane().setLayout(new BorderLayout());
            Panel panel = new Panel(this.getContentPane());
            String colSpecs = "10dlu, pref, 10dlu, pref";
            String rowSpecs = "10dlu,pref,10dlu,pref";
            FormLayout layout = new FormLayout(colSpecs, rowSpecs);
            PanelBuilder builder = layout.createBuilder(panel);
            CellConstraints cc = new CellConstraints();
            Label nameLabel = Label.create((UiContainer)panel, CoreMsg.NAME);
            Label valueLabel = Label.create((UiContainer)panel, CoreMsg.VALUE);
            this.nameField = new TextField((UiContainer)panel, 20);
            this.valueField = new TextField((UiContainer)panel, 20);
            builder.add((UiComponent)nameLabel, cc.xy(2, 2));
            builder.add((UiComponent)this.nameField, cc.xy(4, 2));
            builder.add((UiComponent)valueLabel, cc.xy(2, 4));
            builder.add((UiComponent)this.valueField, cc.xy(4, 4));
            this.getContentPane().add(panel, "Center");
            this.setSize(300, 150);
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private static class Entry {
        private String key;
        private String value;

        private Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public static Entry create(String key, String value) {
            return new Entry(key, value);
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return entry.key.equals(this.key) && entry.value.equals(this.value);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.key.hashCode();
            result = 37 * result + this.value.hashCode();
            return result;
        }
    }
}

