/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.configuration.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.bpm.configuration.editor.DatabasePropertiesPanel;
import oracle.bpm.configuration.editor.PoolAttribute;
import oracle.bpm.configuration.spi.ConfigurationEditorBean;
import oracle.bpm.configuration.util.swing.AbstractConfigurationEditor;
import oracle.bpm.connector.impl.PoolConfigurationBean;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.NumericField;

public abstract class AbstractPoolConfigurationEditor
extends AbstractConfigurationEditor {
    protected DatabasePropertiesPanel databasePropertiesPanel;
    protected TabbedPane tabbedPane;
    private List<PoolAttribute> poolAttributes;
    private NumericField<Integer> poolEntrySize;
    private NumericField<Integer> poolIdleTime;
    private NumericField<Integer> poolMinSize;
    private NumericField<Integer> poolSize;

    protected AbstractPoolConfigurationEditor(UiContainer parent) {
        super(parent);
        this.setLayout(new BorderLayout());
        this.tabbedPane = new TabbedPane(this);
        this.tabbedPane.setHideOneTab(true);
        this.tabbedPane.setTabPlacement(3);
        this.poolAttributes = new ArrayList<PoolAttribute>();
        this.add(this.tabbedPane, "Center");
    }

    @Override
    public void setConfigurationEditorBean(ConfigurationEditorBean configurationEditorBean) {
        super.setConfigurationEditorBean(configurationEditorBean);
        PoolConfigurationBean bean = (PoolConfigurationBean)((Object)configurationEditorBean);
        this.poolIdleTime.setValue(bean.getConnectionIdleTime());
        this.poolSize.setValue(bean.getSize());
        this.poolEntrySize.setValue(bean.getEntrySize());
        this.poolMinSize.setValue(bean.getMinConnections());
    }

    public UiComponent createRuntimePanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        this.createFields(panel);
        String colSpecs = "10dlu, pref, 10dlu, pref";
        String rowSpecs = "10dlu,pref, 10dlu, pref, 10dlu, pref, 10dlu, pref";
        int size = this.poolAttributes.size();
        for (int i = 0; i < size; ++i) {
            rowSpecs = rowSpecs.concat(", 10dlu, pref");
        }
        FormLayout layout = new FormLayout("10dlu, pref, 10dlu, pref", rowSpecs);
        PanelBuilder builder = layout.createBuilder(panel);
        Label poolMaxLabel = Label.create((UiContainer)panel, LibMsg.POOL_MAX);
        Label poolMaxEntryLabel = Label.create((UiContainer)panel, LibMsg.POOL_ENTRY_MAX);
        Label poolMinLabel = Label.create((UiContainer)panel, LibMsg.POOL_MIN);
        Label poolIdleTimeLabel = Label.create((UiContainer)panel, LibMsg.POOL_IDLE_TIME);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)poolMaxLabel, cc.xy(2, 2));
        builder.add(this.poolSize, cc.xy(4, 2));
        builder.add((UiComponent)poolMaxEntryLabel, cc.xy(2, 4));
        builder.add(this.poolEntrySize, cc.xy(4, 4));
        builder.add((UiComponent)poolIdleTimeLabel, cc.xy(2, 6));
        builder.add(this.poolIdleTime, cc.xy(4, 6));
        builder.add((UiComponent)poolMinLabel, cc.xy(2, 8));
        builder.add(this.poolMinSize, cc.xy(4, 8));
        int nextIndex = 10;
        for (PoolAttribute poolAttribute : this.poolAttributes) {
            builder.add((UiComponent)poolAttribute.getAttributeLabel(), cc.xy(2, nextIndex));
            builder.add((UiComponent)poolAttribute.getAttributeComponent(), cc.xy(4, nextIndex));
            nextIndex += 2;
        }
        return panel;
    }

    public void aditionalPropertiesChanged() {
        this.firePropertiesChanged();
    }

    public void synchronizeBean() {
        PoolConfigurationBean bean = (PoolConfigurationBean)((Object)this.getEditorBean());
        bean.setConnectionIdleTime(this.poolIdleTime.getValue());
        bean.setSize(this.poolSize.getValue());
        bean.setEntrySize(this.poolEntrySize.getValue());
        bean.setMinConnections(this.poolMinSize.getValue());
    }

    protected void createFields(Panel panel) {
        this.poolSize = NumericField.createIntegerNumericField(panel);
        this.poolSize.setValue(Integer.valueOf("10"));
        this.poolSize.setColumns(5);
        this.poolSize.setGroupingUsed(false);
        this.poolSize.setRange(1, Integer.MAX_VALUE);
        this.poolEntrySize = NumericField.createIntegerNumericField(panel);
        this.poolEntrySize.setValue(Integer.valueOf("10"));
        this.poolEntrySize.setGroupingUsed(false);
        this.poolSize.setRange(1, Integer.MAX_VALUE);
        this.poolIdleTime = NumericField.createIntegerNumericField(panel);
        this.poolIdleTime.setValue(Integer.valueOf("5"));
        this.poolIdleTime.setGroupingUsed(false);
        this.poolIdleTime.setRange(0, Integer.MAX_VALUE);
        this.poolMinSize = NumericField.createIntegerNumericField(panel);
        this.poolMinSize.setValue(Integer.valueOf("0"));
        this.poolMinSize.setGroupingUsed(false);
        this.poolMinSize.setRange(0, Integer.MAX_VALUE);
        DocumentListener listener = this.createDocumentListener();
        this.poolEntrySize.addDocumentListener(listener);
        this.poolIdleTime.addDocumentListener(listener);
        this.poolMinSize.addDocumentListener(listener);
        this.poolSize.addDocumentListener(listener);
    }

    protected void addPoolAttribute(PoolAttribute attribute) {
        this.poolAttributes.add(attribute);
    }

    protected void addRuntimeTab() {
        this.tabbedPane.addTab(UIMsg.RUNTIME, this.createRuntimePanel(this.tabbedPane));
    }

    protected void addTab(Msg msg, UiComponent component) {
        this.tabbedPane.addTab(msg, component);
    }

    protected void addPropertiesPanel(Properties defaultProperties) {
        this.databasePropertiesPanel = new DatabasePropertiesPanel((UiContainer)this.tabbedPane, defaultProperties, this);
        this.addTab(LibMsg.PROPERTIES, this.databasePropertiesPanel);
    }

    protected void addPropertiesPanel() {
        this.addPropertiesPanel(new Properties());
    }
}

