/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.InvalidExpressionException;
import oracle.bpm.project.compile.exceptions.InvalidProjectObjectExpressionException;
import oracle.bpm.project.compile.exceptions.MissingExpressionException;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConditionalFlow;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.SequenceFlow;

public class SequenceFlowChecker
extends ProjectObjectChecker {
    private final ProcessChecker.CheckContext context;
    private final SequenceFlow sequenceFlow;

    public SequenceFlowChecker(SequenceFlow sequenceFlow, ProcessChecker.CheckContext options) {
        super(options.getListener());
        this.sequenceFlow = sequenceFlow;
        this.context = options;
    }

    public ProcessChecker.CheckContext getContext() {
        return this.context;
    }

    @Override
    public void check() throws ProjectException {
        if (this.getFlow().isConditionalFlow()) {
            ConditionalFlow conditionalFlow = this.getFlow().asConditionalFlow();
            Expression expression = conditionalFlow.getCondition();
            if (expression == null && this.getContext().getOptions().checkScripts()) {
                MissingExpressionException missingExpressionException = new MissingExpressionException(conditionalFlow);
                if (this.getContext().getOptions().isDeploying()) {
                    this.reportError(this.getFlow(), missingExpressionException);
                } else {
                    this.reportWarning(this.getFlow(), missingExpressionException);
                }
            } else {
                NodeContainer container = conditionalFlow.getParentObject();
                DataDeclarationContainer context = container instanceof DataDeclarationContainer ? (DataDeclarationContainer)((Object)container) : conditionalFlow.getProcess();
                try {
                    ExpressionHelper.validateExpression(expression, context, CatalogType.Default.getBool());
                }
                catch (InvalidExpressionException e) {
                    this.reportError(conditionalFlow, InvalidProjectObjectExpressionException.create(conditionalFlow, e.getMessage()));
                }
            }
        }
    }

    private SequenceFlow getFlow() {
        return this.sequenceFlow;
    }
}

