/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.bpm.cil.CilCompiler;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.SequenceBuilder;
import oracle.bpm.data.BusinessVariableData;
import oracle.bpm.lang.Str;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.exceptions.JoinAlreadyMatchedException;
import oracle.bpm.project.compile.exceptions.MultipleStartNotAllowedException;
import oracle.bpm.project.compile.exceptions.NoSplitActivityToMatchException;
import oracle.bpm.project.compile.exceptions.ProcessHasNoBeginActivityException;
import oracle.bpm.project.compile.exceptions.ProcessHasNoEndEventException;
import oracle.bpm.project.compile.exceptions.RoleNotFoundException;
import oracle.bpm.project.compile.exceptions.TransitionBetweenDifferentLevelsException;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.compile.process.FlowNodeChecker;
import oracle.bpm.project.compile.process.MeasurementChecker;
import oracle.bpm.project.compile.process.SequenceFlowChecker;
import oracle.bpm.project.model.ProjectDataObject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.DataObject;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Gateway;
import oracle.bpm.project.model.processes.GatewayDirection;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.processes.activities.ActivityLevelFeature;
import oracle.bpm.project.model.processes.activities.NodeAssociationFeature;
import oracle.bpm.project.model.util.ModelUtils;
import org.jetbrains.annotations.Nullable;

public class ProcessChecker {
    private CilCompiler compiler;
    private Process content;
    private CheckContext context;

    public ProcessChecker(Process content) {
        this(content, new CheckOptions());
    }

    public ProcessChecker(Process pc, CheckOptions options) {
        this.content = pc;
        this.context = new CheckContext();
        this.context.setOptions(options);
        this.context.setProcess(pc);
        assert (options != null) : "Process Checker options cannot be null";
    }

    public CheckContext getContext() {
        return this.context;
    }

    public void check() throws ProjectException {
        if (this.getContext().getListener() == null) {
            this.getContext().setListener(new ProjectMessageListener(){

                @Override
                public void reportError(ProjectObject object, ProjectException exception) {
                    throw new RuntimeException(exception);
                }

                @Override
                public void reportWarning(ProjectObject object, ProjectException exception) {
                }
            });
        }
        this.checkProcess();
        this.checkDataObjects();
        if (this.getContext().getOptions().checkLanes()) {
            this.checkRoles();
        }
        this.clearActivities();
        if (this.getContext().getOptions().checkFlow()) {
            this.checkFlow();
        }
        this.checkEvents();
        this.checkActivities();
        this.checkTransitionProperties();
        this.checkMeasurements();
    }

    public String getLevelMsg(String level) {
        if (level.equals("Begin Level")) {
            return ProjectCompileMsg.MAIN_FLOW.getString();
        }
        if (level.equals("Fault Handler Level")) {
            return ProjectCompileMsg.EXCEPTION_HANDLING_FLOW.getString();
        }
        if (level.equals("Compensate Level")) {
            return ProjectCompileMsg.COMPENSATION_FLOW.getString();
        }
        Activity activityFor = this.content.findActivity(level);
        if (activityFor != null && activityFor.isGateway()) {
            return ProjectCompileMsg.SPLIT_FLOW(level).getString();
        }
        return level;
    }

    public Process getProcessContent() {
        return this.content;
    }

    public void setCompiler(CilCompiler compiler) {
        this.compiler = compiler;
    }

    public void setListener(ProjectMessageListener l) {
        this.getContext().setListener(l);
    }

    protected void reportError(ProjectObject component, ModelException exception) throws ModelException {
        if (this.getContext().getListener() == null) {
            throw exception;
        }
        this.getContext().getListener().reportError(component, exception);
    }

    protected void reportWarning(ProjectObject component, ModelException exception) {
        if (this.getContext().getListener() != null) {
            this.getContext().getListener().reportWarning(component, exception);
        }
    }

    private void checkDataObjects() throws ProjectException {
        Sequence<DataObject> dataObjects = this.getProcessContent().getDescendants(DataObject.class);
        Sequence<ProjectDataObject> projectDataObjects = this.getProcessContent().getProject().getDescendants(ProjectDataObject.class);
        for (final DataObject dataObject : dataObjects) {
            if (dataObject instanceof ProjectDataObject) {
                this.checkProjectDataObject((ProjectDataObject)dataObject);
                continue;
            }
            if (projectDataObjects.select(new Predicate<ProjectDataObject>(){

                @Override
                public boolean check(@Nullable ProjectDataObject value) {
                    return value.getName().equals(dataObject.getName());
                }
            }).isEmpty()) continue;
            this.reportError(dataObject, new ModelException((ProjectObject)dataObject, ProjectCompileMsg.DUPLICATE_DATAOBJECT_NAME(dataObject.getName())));
        }
    }

    private void checkProjectDataObject(ProjectDataObject dataObject) throws ModelException {
        BusinessVariableData.Range[] ranges;
        BusinessVariableData data = dataObject.getBusinessVariableData();
        for (BusinessVariableData.Range range : ranges = data.getRange()) {
            if (!Str.isEmpty(range.getName())) continue;
            this.reportError(dataObject, new ModelException((ProjectObject)dataObject, ProjectCompileMsg.RANGE_NAME_IS_EMPTY));
        }
    }

    private void checkEvents() throws ModelException {
        if (this.content.getEvents(StartEvent.class).isEmpty()) {
            this.reportError(this.content, new ProcessHasNoBeginActivityException(this.content));
        }
        if (this.content.getEvents(EndEvent.class).isEmpty()) {
            this.reportError(this.content, new ProcessHasNoEndEventException(this.content));
        }
    }

    private void checkActivities() throws ProjectException {
        new FlowNodeChecker(this.getContext()).check();
    }

    private void checkFlow() throws ModelException {
        this.setMainFlowActivityLevels();
        this.fixNullLevelActivities();
    }

    private void checkMeasurements() throws ProjectException {
        for (Measurement measurement : this.getProcessContent().getDescendants(Measurement.class)) {
            new MeasurementChecker(measurement, this.getContext()).check();
        }
    }

    private void checkProcess() throws ModelException {
        if (this.getProcessContent().getEvents(StartEvent.class).toArray().length > 1 && this.getProcessContent().isCallableSubprocess()) {
            StartEvent startEvent = ModelUtils.getStartEvent(this.getProcessContent());
            this.reportError(startEvent, new ModelException((ProjectObject)startEvent, ProjectCompileMsg.CALLABLE_SUBPROCESS_WITH_MULTIPLE_STARTS));
        }
        this.checkLanes();
    }

    private void checkLanes() throws ModelException {
        ArrayList<Lane> checkedLanes = new ArrayList<Lane>();
        for (final Lane lane : this.getProcessContent().getLanes()) {
            if (!lane.isParametric() || checkedLanes.contains(lane)) continue;
            Predicate<Lane> laneEqualsId = new Predicate<Lane>(){

                @Override
                public boolean check(Lane value) {
                    return lane.getId().equals(value.getId());
                }
            };
            for (Lane aliasLane : this.getProcessContent().getLanes().select(laneEqualsId)) {
                if (aliasLane == lane) continue;
                if (!aliasLane.getParamName().equals(lane.getParamName())) {
                    this.reportError(this.getProcessContent(), new ModelException((ProjectObject)this.getProcessContent(), ProjectCompileMsg.ALIAS_LANES_WITH_DIFFERENT_PARAM_VAR(lane.getId(), lane.getParamName(), aliasLane.getId(), aliasLane.getParamName())));
                }
                checkedLanes.add(aliasLane);
            }
            checkedLanes.add(lane);
        }
    }

    private void checkRoles() throws ModelException {
        for (Lane lane : this.getProcessContent().getLanes()) {
            Role role;
            if (lane.isAutomatic() || (role = lane.getRole()) != null) continue;
            this.reportError(lane, new RoleNotFoundException(lane));
        }
    }

    private void checkTransitionProperties() throws ProjectException {
        for (SequenceFlow transition : this.getProcessContent().getDescendants(SequenceFlow.class)) {
            SequenceFlowChecker checker = new SequenceFlowChecker(transition, this.getContext());
            checker.check();
        }
    }

    private void clearActivities() {
        for (Activity node : this.getProcessContent().getDescendants(Activity.class)) {
            this.ensureSplitPathEntry(node);
            this.getContext().getSplitPathsByActivity().get(node).clear();
        }
        this.getContext().getNodeLevelsThatAreSet().clear();
        this.getContext().getAssociatedActivitiesThatAreSet().clear();
    }

    private void fixNullLevelActivities() {
        for (FlowNode node : this.getProcessContent().getDescendants(FlowNode.class)) {
            ActivityLevelFeature levelFeature = node.getFeature(ActivityLevelFeature.class);
            if (levelFeature != null) continue;
            this.setActivityLevelFor(node, "Begin Level");
        }
    }

    private String getActivityLevelFor(FlowNode node) {
        return this.getContext().getNodeLevelsThatAreSet().contains(node) ? ModelUtils.getActivityLevel(node) : null;
    }

    private String getAssociatedActivityFor(Gateway node) {
        NodeAssociationFeature associationFeature = node.getFeature(NodeAssociationFeature.class);
        return this.getContext().getAssociatedActivitiesThatAreSet().contains(node) ? associationFeature.getAssociatedNodeId() : null;
    }

    private Sequence<FlowNode> getMainFlowStartActivities(NodeContainer container) {
        return ModelUtils.getStartNodes(container);
    }

    private void setActivityLevel(FlowNode from, FlowNode a, String levelFrom) throws ModelException {
        String levelTo = this.getActivityLevelFor(a);
        if (levelTo == null) {
            this.setActivityLevelFor(a, levelFrom);
            return;
        }
        if (levelTo.equals(levelFrom)) {
            return;
        }
        if (a.isGateway() && a.asAnyNode(Gateway.class).getDirection() == GatewayDirection.CONVERGING) {
            return;
        }
        if (!ModelUtils.isEndEvent(a)) {
            TransitionBetweenDifferentLevelsException exec = new TransitionBetweenDifferentLevelsException(a, this.getLevelMsg(levelTo), from, this.getLevelMsg(levelFrom), this.getContext().getActivityCircuitStack());
            this.reportError(a, exec);
        }
    }

    private void setActivityLevelFor(FlowNode node, String level) {
        ActivityLevelFeature levelFeature = node.getFeature(ActivityLevelFeature.class);
        levelFeature.setValue(level);
        this.getContext().getNodeLevelsThatAreSet().add(node);
        Sequence<BoundaryEvent> sourceBoundaryEvents = ModelUtils.getSourceBoundaryEvents(node);
        Sequence<BoundaryEvent> list = this.getContext().getSourceBoundaryByFlowNode().get(node);
        if (list == null) {
            this.getContext().getSourceBoundaryByFlowNode().put(node, sourceBoundaryEvents);
        }
    }

    private void setAssociatedActivityFor(Gateway node, String associatedActivity) {
        if (node.getBpmnType() != BpmnType.EXCLUSIVE_GATEWAY) {
            node.getFeature(NodeAssociationFeature.class).setAssociatedNode(associatedActivity);
            this.getContext().getAssociatedActivitiesThatAreSet().add(node);
        }
    }

    private void setLevelForFlow(FlowNode a) throws ModelException {
        Stack allSplits = new Stack();
        this.setActivityLevelFor(a, "Begin Level");
        this.updateNextActivityLevel(null, a, allSplits);
        allSplits.clear();
        this.getContext().getActivityCircuitStack().clear();
        this.getContext().getCheckedTransitions().clear();
    }

    private void setMainFlowActivityLevels() throws ModelException {
        this.setNodeContainerActivityLevels(this.getProcessContent());
    }

    private void setNodeContainerActivityLevels(NodeContainer container) throws ModelException {
        Sequence<FlowNode> startActivities = this.getMainFlowStartActivities(container);
        if (startActivities.toArray().length > 1 && container != this.getProcessContent()) {
            this.reportError(container, new MultipleStartNotAllowedException(container));
        }
        this.updateLevels(startActivities);
        for (Subprocess subprocess : container.getActivities(Subprocess.class)) {
            this.setNodeContainerActivityLevels(subprocess);
        }
    }

    private void startNewFlow(FlowNode a) throws ModelException {
        this.setLevelForFlow(a);
    }

    private void updateLevels(Sequence<? extends FlowNode> startNodes) throws ModelException {
        this.getContext().setActivityCircuitStack(new Stack<FlowNode>());
        this.getContext().getCheckedTransitions().clear();
        for (FlowNode flowNode : startNodes) {
            this.startNewFlow(flowNode);
        }
    }

    private void updateNextActivityLevel(FlowNode from, FlowNode to, Stack splits) throws ModelException {
        Stack<String> splitBranches = new Stack<String>();
        for (int i = 0; i < splits.size(); ++i) {
            String label = (String)splits.elementAt(i);
            splitBranches.push(label);
        }
        boolean isASplit = false;
        boolean isAJoin = false;
        if (to.isGateway()) {
            Gateway gateway = to.asAnyNode(Gateway.class);
            switch (gateway.getDirection()) {
                case CONVERGING: {
                    isASplit = false;
                    isAJoin = true;
                    break;
                }
                case DIVERGING: {
                    isASplit = true;
                    isAJoin = false;
                    break;
                }
                case MIXED: {
                    break;
                }
            }
        }
        this.getContext().getActivityCircuitStack().push(to);
        if (isASplit) {
            String currentLevel = splitBranches.isEmpty() ? "Begin Level" : (String)splitBranches.peek();
            splitBranches.push(to.getId());
            this.setActivityLevel(from, to, currentLevel);
        } else if (isAJoin) {
            if (splitBranches.empty()) {
                NoSplitActivityToMatchException exe = new NoSplitActivityToMatchException(to, this.getContext().getActivityCircuitStack());
                this.reportError(to, exe);
                this.setActivityLevel(from, to, "Begin Level");
            } else {
                String splitLevel = (String)splitBranches.pop();
                String currentLevel = splitBranches.isEmpty() ? "Begin Level" : (String)splitBranches.peek();
                this.setActivityLevel(from, to, currentLevel);
                Gateway split = to.getParentObject().findGateway(splitLevel);
                this.setAssociatedActivityFor(split, to.getId());
                if (this.getAssociatedActivityFor(to.asAnyNode(Gateway.class)) == null || this.getAssociatedActivityFor(to.asAnyNode(Gateway.class)).equals(splitLevel)) {
                    this.setAssociatedActivityFor(to.asAnyNode(Gateway.class), splitLevel);
                } else {
                    NodeAssociationFeature associationFeature = to.getFeature(NodeAssociationFeature.class);
                    JoinAlreadyMatchedException joinEx = new JoinAlreadyMatchedException(associationFeature);
                    this.reportError(to, joinEx);
                }
            }
        } else {
            this.updateNextDefault(splitBranches, from, to);
        }
        Sequence<SequenceFlow> flows = to.getOutgoingSequenceFlows();
        if (to.isActivity()) {
            Activity activity = to.asAnyNode(Activity.class);
            Sequence<BoundaryEvent> boundaries = activity.getActivityBoundaryEvents();
            SequenceBuilder<SequenceFlow> builder = SequenceBuilder.create(flows);
            for (BoundaryEvent boundary : boundaries) {
                this.setActivityLevelFor(boundary, (String)activity.getFeatureValue(ActivityLevelFeature.class));
                builder.append(boundary.getOutgoingSequenceFlows());
            }
            flows = builder.build();
        }
        for (SequenceFlow sequenceFlow : flows) {
            if (this.getContext().getCheckedTransitions().contains(sequenceFlow)) continue;
            this.getContext().getCheckedTransitions().add(sequenceFlow);
            FlowNode targetNode = sequenceFlow.getTarget();
            if (ModelUtils.isAnySplit(to)) {
                this.addSplitPaths(targetNode, targetNode.getId());
            } else {
                this.ensureSplitPathEntry(targetNode);
                this.addSplitPaths(targetNode, this.getContext().getSplitPathsByActivity().get(targetNode));
            }
            this.updateNextActivityLevel(sequenceFlow.getSource(), targetNode, splitBranches);
        }
        if (!this.getContext().getActivityCircuitStack().isEmpty()) {
            this.getContext().getActivityCircuitStack().pop();
        }
    }

    private void addSplitPaths(FlowNode fuegoActivityTo, Set<String> s) {
        this.ensureSplitPathEntry(fuegoActivityTo).addAll(s);
    }

    private void addSplitPaths(FlowNode fuegoActivityTo, String id) {
        this.ensureSplitPathEntry(fuegoActivityTo).add(id);
    }

    private Set<String> ensureSplitPathEntry(FlowNode fuegoActivityTo) {
        Set<String> strings = this.getContext().getSplitPathsByActivity().get(fuegoActivityTo);
        if (strings == null) {
            strings = new HashSet<String>();
            this.getContext().getSplitPathsByActivity().put(fuegoActivityTo, strings);
        }
        return strings;
    }

    private void updateNextDefault(Stack splitsCopy, FlowNode from, FlowNode to) throws ModelException {
        if (splitsCopy.empty()) {
            this.setActivityLevel(from, to, "Begin Level");
        } else {
            String level = (String)splitsCopy.peek();
            this.setActivityLevel(from, to, level);
        }
    }

    class CheckContext {
        private Stack<FlowNode> activityCircuitStack;
        private Set<Gateway> associatedActivitiesThatAreSet = new HashSet<Gateway>();
        private Set<SequenceFlow> checkedTransitions = new HashSet<SequenceFlow>();
        private ProjectMessageListener listener;
        private Set<FlowNode> nodeLevelsThatAreSet = new HashSet<FlowNode>();
        private CheckOptions options = new CheckOptions();
        private Process process;
        private HashMap<FlowNode, Sequence<BoundaryEvent>> sourceBoundaryByFlowNode = new HashMap();
        private Map<FlowNode, Set<String>> splitPathsByActivity = new HashMap<FlowNode, Set<String>>();

        CheckContext() {
        }

        public Map<FlowNode, Set<String>> getSplitPathsByActivity() {
            return this.splitPathsByActivity;
        }

        public Set<Gateway> getAssociatedActivitiesThatAreSet() {
            return this.associatedActivitiesThatAreSet;
        }

        public Set<FlowNode> getNodeLevelsThatAreSet() {
            return this.nodeLevelsThatAreSet;
        }

        public Process getProcess() {
            return this.process;
        }

        public ProjectMessageListener getListener() {
            return this.listener;
        }

        public HashMap<FlowNode, Sequence<BoundaryEvent>> getSourceBoundaryByFlowNode() {
            return this.sourceBoundaryByFlowNode;
        }

        public CheckOptions getOptions() {
            return this.options;
        }

        public Stack<FlowNode> getActivityCircuitStack() {
            return this.activityCircuitStack;
        }

        public void setActivityCircuitStack(Stack<FlowNode> activityCircuitStack) {
            this.activityCircuitStack = activityCircuitStack;
        }

        public Set<SequenceFlow> getCheckedTransitions() {
            return this.checkedTransitions;
        }

        public void setProcess(Process process) {
            this.process = process;
        }

        public void setListener(ProjectMessageListener listener) {
            this.listener = listener;
        }

        public void setOptions(CheckOptions options) {
            this.options = options;
        }
    }
}

