/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.process;

import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.lib.ExpressionMode;
import oracle.bpm.project.compile.ProjectObjectChecker;
import oracle.bpm.project.compile.exceptions.DataAssociationException;
import oracle.bpm.project.compile.exceptions.DataTransformationException;
import oracle.bpm.project.compile.exceptions.InvalidExpressionException;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.XSLTransformationsContainer;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.features.IncomingDataAssociationFeature;
import oracle.bpm.project.model.features.OutgoingDataAssociationFeature;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociation;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItem;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationItemEndpoint;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSetType;
import oracle.bpm.project.model.processes.dataassociations.DataTransformation;
import oracle.bpm.project.model.processes.dataassociations.XSLTransformation;
import org.jetbrains.annotations.NotNull;

public class DataAssociationChecker
extends ProjectObjectChecker {
    private final FlowNode node;

    public DataAssociationChecker(@NotNull ProjectMessageListener listener, FlowNode node) {
        super(listener);
        this.node = node;
    }

    @Override
    public void check() {
        OutgoingDataAssociationFeature outFeature;
        IncomingDataAssociationFeature inFeature = this.node.getFeature(IncomingDataAssociationFeature.class);
        if (inFeature != null) {
            this.checkSet(inFeature.getDataAssociationSet());
        }
        if ((outFeature = this.node.getFeature(OutgoingDataAssociationFeature.class)) != null) {
            this.checkSet(outFeature.getDataAssociationSet());
        }
    }

    private void checkSet(DataAssociationSet set) {
        for (DataAssociation dataAssociation : set.getDataAssociations()) {
            if (this.checkItemExpression(dataAssociation.getTarget(), null)) {
                CatalogType targetType = this.getTargetDataAssociationItemType(dataAssociation.getTarget());
                if (targetType != null) {
                    this.checkItemExpression(dataAssociation.getSource(), targetType);
                } else {
                    this.reportError(this.node, DataAssociationException.createCannotResolveTargetType(this.node));
                }
            }
            this.checkItemRefs(dataAssociation.getTarget());
        }
        for (DataTransformation dataTransformation : set.getDataTransformations()) {
            XSLTransformation selectedTransformation;
            XSLTransformationsContainer xslTransformationsContainer = this.node.getProject().getResourceFilesContainer().getXSLTransformationsContainer();
            if (xslTransformationsContainer != null && (selectedTransformation = xslTransformationsContainer.findChild(XSLTransformation.class, dataTransformation.getTransformationName())) == null) {
                this.reportError(this.node, DataTransformationException.createTransformationNotExists(this.node, dataTransformation.getTransformationName()));
            }
            DataAssociationItemEndpoint sourcesEndpoint = set.getType() == DataAssociationSetType.OUTPUT ? DataAssociationItemEndpoint.CUSTOM_SOURCE : DataAssociationItemEndpoint.SOURCE;
            DataDeclarationContainer sourcesContainer = set.getContextProvider(sourcesEndpoint).getDataDeclarationContainer();
            for (String sourceRef : dataTransformation.getSourceRefs()) {
                if (this.isValidTransformationRef(sourcesContainer, sourceRef)) continue;
                this.reportError(this.node, DataTransformationException.createInvalidSource(this.node, sourceRef));
            }
            DataAssociationItemEndpoint targetEndpoint = set.getType() == DataAssociationSetType.OUTPUT ? DataAssociationItemEndpoint.CUSTOM_TARGET : DataAssociationItemEndpoint.TARGET;
            DataDeclarationContainer targetContainer = set.getContextProvider(targetEndpoint).getDataDeclarationContainer();
            String targetRef = dataTransformation.getTargetRef();
            if (Str.isEmpty(targetRef)) {
                this.reportError(this.node, DataTransformationException.createNullTarget(this.node));
                continue;
            }
            if (this.isValidTransformationRef(targetContainer, targetRef)) continue;
            this.reportError(this.node, DataTransformationException.createInvalidTarget(this.node, targetRef));
        }
    }

    private CatalogType getTargetDataAssociationItemType(DataAssociationItem item) {
        return ExpressionHelper.getExpressionType(item.getExpression(), item.getContext(), null);
    }

    private boolean checkItemExpression(DataAssociationItem item, CatalogType typeToValidate) {
        if (Str.isEmpty(item.getExpression().getExpressionValue())) {
            this.reportError(this.node, DataAssociationException.createNullOrEmptyExpression(this.node));
            return false;
        }
        if (item.isQuery() || item.getExpression().getMode() == ExpressionMode.SIMPLE) {
            Expression expression = item.getExpression();
            try {
                ExpressionHelper.validateExpression(expression, item.getContext(), typeToValidate);
            }
            catch (InvalidExpressionException e) {
                this.reportError(this.node, DataAssociationException.createInvalidExpression(this.node, e.getMessage()));
                return false;
            }
        }
        return true;
    }

    private void checkItemRefs(DataAssociationItem item) {
        if (item.getRefs().isEmpty()) {
            this.reportError(this.node, DataAssociationException.createNullTargetRef(this.node));
        }
    }

    private boolean isValidTransformationRef(@NotNull DataDeclarationContainer container, @NotNull String ref) {
        boolean result = false;
        DataDeclaration dataDeclaration = container.findDeclaration(ref);
        if (dataDeclaration != null) {
            SchemaObject schemaObject = dataDeclaration.getType().getDelegate().asSchemaObject();
            result = this.isComplexElement(schemaObject);
        }
        return result;
    }

    private boolean isComplexElement(@NotNull SchemaObject schemaObject) {
        return !schemaObject.isBasicType() && schemaObject.isElement();
    }
}

