/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.msg;

import oracle.bpm.log.ErrorRange;
import oracle.bpm.log.LogComponent;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.resources.ErrorMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.resources.MsgBundle;
import oracle.bpm.resources.TErrorMsg;
import oracle.bpm.resources.TMsg;
import org.jetbrains.annotations.NotNull;

public class ProjectCompileMsg
extends MsgBundle {
    private static final TMsg DUPLICATE_DATAOBJECT_NAME = ProjectCompileMsg.tmsg("Can not have a process data object named the same as a project data object: %0");
    private static final TMsg BUSINESS_INDICATOR_NOT_A_COUNTER = ProjectCompileMsg.tmsg("Flow node (%0) contains a business indicator that is not a counter (%1)");
    public static final TMsg MORE_THAN_ONE_INTERRUPTING_TIMER = ProjectCompileMsg.tmsg("Flow node %0 has more than one interrupting timer event");
    private static final TMsg MESSAGE_ALREADY_HANDLED = ProjectCompileMsg.tmsg("Service/Operation (%0/%1) already handled in boundary event from activity (%2)");
    public static final Msg BOUNDARY_EVENT_NOT_ALLOWED_IN_EBG_PATHS = ProjectCompileMsg.msg("Boundary Events are not allowed in tasks that are part of an Event-based Gateway");
    public static final Msg EBG_SHOULD_HAVE_AT_LEAST_2_OUTFLOWS = ProjectCompileMsg.msg("Event-based Gateway should have at least 2 outgoing Sequence Flows");
    public static final TMsg ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE = ProjectCompileMsg.tmsg("There is a possible path between a Message-based Start Event (%0) and an Initiator Receive Task (%1)");
    public static final TMsg INITIATE_RECEIVE_MUST_BE_THE_FIRST = ProjectCompileMsg.tmsg("An Initiator Receive Task (%0) must be the first task after a None Event");
    public static final Msg CALLABLE_SUBPROCESS_ALLOWS_NONE_ONLY = ProjectCompileMsg.msg("Start Event can only be of type None in Callable Subprocesses");
    public static final Msg CALLABLE_SUBPROCESS_WITH_MULTIPLE_STARTS = ProjectCompileMsg.msg("Callable Subprocess allow only one Start Event of type None");
    public static final Msg RANGE_NAME_IS_EMPTY = ProjectCompileMsg.msg("Range name must not be empty");
    public static final Msg EMPTY_EXPRESSION_NOT_ALLOWED = ProjectCompileMsg.msg("Expression should not be empty");
    private static final TMsg BI_MUST_BE_MEASURE = ProjectCompileMsg.tmsg("Business Indicator (%0) used in Measurement Mark should be of type Measure");
    public static final Msg SUBPROCESS_HAS_NO_START_OR_END_EVENT = ProjectCompileMsg.msg("Subprcess should have at least a Start and an End Event");
    public static final Msg NO_INITIATOR_TASK_ALLOWED_IN_CALLABLE_SUBPROCESS = ProjectCompileMsg.msg("Initiator tasks are not allowed in Callable Subprocesses");
    public static final Msg MEASUREMENT_HAS_NO_BI = ProjectCompileMsg.msg("Measurement should have at least one Business Indicator defined");
    public static final Msg INVALID_TRIGGER_TYPE_FOR_BOUNDARY = ProjectCompileMsg.msg("Invalid trigger type for Boundary Event");
    public static final Msg INVALID_BOUNDARY = ProjectCompileMsg.msg("This construct does not allow Boundary Events");
    public static final Msg THROW_EVENTS_NOT_ALLOWED_IN_EBG = ProjectCompileMsg.msg("Throw Events are not allowed as target of Event-based Gateways, only Catch Events are");
    public static final Msg INVALID_EVENT_TYPE_FOR_EBG = ProjectCompileMsg.msg("Invalid event type for Event-based Gateway");
    public static final Msg EVENT_BASED_SHOULD_CONNECT_TO_EVENTS = ProjectCompileMsg.msg("Event-based Gateways cannot combine Message-catch Events and Receive Tasks as triggers.");
    public static final Msg NESTED_EVENT_SUBPROCESS_NOT_ALLOWED = ProjectCompileMsg.msg("An Event-triggered Subprocess cannot be inside an Event-triggered Subprocess");
    public static final Msg INTEMEDIATE_ERROR_EVENTS_SHOULD_NOT_BE_INTERMEDIATE = ProjectCompileMsg.msg("Error-catch Events must start a flow. They cannot be intermediate nodes.");
    private static final TMsg BOUNDARY_ALREADY_HANDLED = ProjectCompileMsg.tmsg("%0 already defined in boundary event %1 of task %2");
    private static final TMsg ERROR_NOT_DEFINED = ProjectCompileMsg.tmsg("Error not defined in Event '%0'");
    private static final TMsg MULTIPLE_START_NOT_ALLOWED = ProjectCompileMsg.tmsg("Multiple Start nodes are not allowed in this context (%0)");
    private static final TMsg CALL_ACTIVITY_HAS_NO_CALLABLE = ProjectCompileMsg.tmsg("Call activity '%0' has no reusable process defined");
    private static final TMsg CONVERSATION_HAS_NO_RELATED_NODE = ProjectCompileMsg.tmsg("Node %0 has no Initiator to continue");
    private static final TMsg CONVERSATION_HAS_AN_INVALID_IMPLEMENTATION = ProjectCompileMsg.tmsg("The node %0 has an invalid conversation implementation");
    private static final TMsg CONVERSATION_OVER_IMPLEMENTED = ProjectCompileMsg.tmsg("Node %0 has more than one conversation implementation in model");
    private static final TMsg CONVERSATION_HAS_NO_INITIATOR_IMPLEMENTATION = ProjectCompileMsg.tmsg("Initiator of node %0 has no implementation defined");
    private static final TMsg MUST_CONTINUE_INITIATOR_NODE = ProjectCompileMsg.tmsg("Node %0 must continue an Initiator Node ");
    private static final TMsg CONVERSATION_OPERATION_NULL = ProjectCompileMsg.tmsg("Operation name in node %0 cannot be null");
    private static final TMsg CONVERSATION_OPERATION_DUPLICATED = ProjectCompileMsg.tmsg("The operation name selected in node %0 already exists in the project");
    private static final TMsg ARGUMENT_INVALID_TYPE = ProjectCompileMsg.tmsg("Argument %1 has an invalid type in node %0");
    private static final TMsg CONVERSATION_INVALID_THROWER_INTERFACE = ProjectCompileMsg.tmsg("Invalid arguments interface in node %0. All nodes that continues the same Initiator must implement the same arguments");
    private static final TMsg SERVICE_INVALID = ProjectCompileMsg.tmsg("The selected service in node %0 is invalid");
    private static final TMsg SERVICE_NULL = ProjectCompileMsg.tmsg("The selected service in node %0 cannot be null");
    private static final TMsg OPERATION_INVALID = ProjectCompileMsg.tmsg("The selected operation in node %0 is invalid");
    private static final TMsg OPERATION_NULL = ProjectCompileMsg.tmsg("The selected operation in node %0 cannot be null");
    private static final TMsg PROCESS_INVALID = ProjectCompileMsg.tmsg("The associated process in node %0 is invalid");
    private static final TMsg PROCESS_NULL = ProjectCompileMsg.tmsg("The associated process in node %0 cannot be null");
    private static final TMsg NODE_INVALID = ProjectCompileMsg.tmsg("The associated node in node %0 is invalid");
    private static final TMsg NODE_NULL = ProjectCompileMsg.tmsg("The associated node in node %0 cannot be null");
    private static final TMsg EXCEPTION_INVALID = ProjectCompileMsg.tmsg("The selected exception in node %0 is invalid");
    private static final TMsg EXCEPTION_VALID_PATH_MISSING = ProjectCompileMsg.tmsg("There should be at least one valid thrower which continues the sync initiator node %0");
    private static final TMsg INVALID_CONDITIONAL_FLOW = ProjectCompileMsg.tmsg("Node %0 cannot have outgoing Conditional Flows");
    private static final TMsg MEASUREMENT_MARK_STOP_WITHOUT_START = ProjectCompileMsg.tmsg("Measurement Mark '%0' of type 'Interval Stop' should have a Measurement Mark of type 'Interval Start' associated.");
    private static final TMsg MEASUREMENT_MARK_START_WITHOUT_STOP = ProjectCompileMsg.tmsg("Measurement Mark '%0' of type 'Interval Start' should have at least a Measurement Mark of type 'Interval Stop' associated.");
    public static final TMsg COMPONENT_NOT_FOUND_IN_CATALOG = ProjectCompileMsg.tmsg("Service '%0' was not found in Business Catalog");
    public static final TMsg PRJ_00046 = ProjectCompileMsg.tmsg("Activity %0 is an exception handler but also belongs to Flow %1. All Exception Handling Flows must be isolated from other Flows (Exception Handling, Compensation, or Main).");
    private static final TMsg PRJ_00048 = ProjectCompileMsg.tmsg("Converging Gateway '%0' was already matched with the Diverging Gateway '%1'. Each Diverging Gateway activity must have their own corresponding Converging Gateway.");
    private static final TMsg PRJ_00049 = ProjectCompileMsg.tmsg("Data Association expression is not valid in node '%0':  %1");
    public static final TMsg MTM_02012 = ProjectCompileMsg.tmsg("The Gateway Circuit is not complete. The reason this has occurred is most likely because activity ('%0') is a Converging Gateway with no corresponding Diverging Gateway or because there is a sequence flow from a node outside the Gateway Circuit to a node inside the Gateway Circuit.");
    public static final Msg MTM_02001 = ProjectCompileMsg.msg("Process should have at least one Start Event");
    public static final Msg MTM_02002 = ProjectCompileMsg.msg("Process should have at least one End Event");
    public static final TMsg MTM_02044 = ProjectCompileMsg.tmsg("Node ('%0') belongs to flow ('%1') and has an incoming Sequence Flow from another flow type ('%2') that comes from node ('%3'). This is probably occurring because: 1) You are adding a sequence flow from a node inside a Gateway Circuit to a node outside of a Gateway Circuit or 2) You are connecting an Exception or Compensate flow to the Main flow.");
    public static final TMsg MOVED_FROM_TO = ProjectCompileMsg.tmsg("Moved from %0 to %1");
    public static final TMsg DSG_00004 = ProjectCompileMsg.tmsg("The name of artifacts of type '%0' cannot be empty and must start with an alphabetic character.");
    public static final TMsg DSG_01003 = ProjectCompileMsg.tmsg("Error in method: '%0'");
    public static final TMsg MTM_02005 = ProjectCompileMsg.tmsg("Node '%0' does not have any incoming Sequence Flows.");
    public static final TMsg MTM_02024 = ProjectCompileMsg.tmsg("Node '%0' does not have an outgoing Default Sequence Flow");
    public static final TMsg MTM_02026 = ProjectCompileMsg.tmsg("Node '%0' has more than one outgoing Unconditional Sequence Flow.");
    public static final TMsg MTM_02027 = ProjectCompileMsg.tmsg("Node '%0' has more than one outgoing Sequence Flow going to the same destination node.");
    public static final TMsg MTM_02037 = ProjectCompileMsg.tmsg("Node '%0' cannot be moved to that position. There is no Role available.");
    public static final TMsg MTM_02054 = ProjectCompileMsg.tmsg("('%0') is a Diverging Gateway and has Sequence Flows that came out from it but never passed through a Converging Gateway.");
    public static final TMsg MTM_02058 = ProjectCompileMsg.tmsg("Name ('%0') already exists in the design.");
    public static final TMsg MTM_02061 = ProjectCompileMsg.tmsg("Node ('%0') cannot be placed in an anonymous role.");
    public static final TMsg MTM_02064 = ProjectCompileMsg.tmsg("Node name '%0' contains invalid characters.");
    public static final TMsg MTM_02065 = ProjectCompileMsg.tmsg("Node name '%0' cannot start with a number.");
    public static final TMsg MTM_02097 = ProjectCompileMsg.tmsg("Node '%0' does not match with any Converging Gateway.");
    public static final TMsg MTM_02112 = ProjectCompileMsg.tmsg("Sequence Flows from node '%0' outside group '%1' to node '%2' inside the group are not allowed.");
    public static final TMsg MTM_02113 = ProjectCompileMsg.tmsg("Sequence Flows from node '%0' inside group '%1' to node '%2' outside the group are not allowed.");
    public static final TMsg MTM_02121 = ProjectCompileMsg.tmsg("Diverging Gateway '%0' and Converging Gateway '%1' must belong to the same Group");
    public static final TMsg MTM_03002 = ProjectCompileMsg.tmsg("An I/O exception occurred while reading process file [%0].");
    public static final TMsg MTM_03003 = ProjectCompileMsg.tmsg("The process source is not a well formed file [%0].");
    public static final TMsg MTM_03006 = ProjectCompileMsg.tmsg("A general exception occurred while parsing process file [%0].");
    public static final TMsg PRJ_00001 = ProjectCompileMsg.tmsg("Node '%0' has incoming Sequence Flows when it should not.");
    public static final TMsg PRJ_00002 = ProjectCompileMsg.tmsg("Node '%0' does not have any outgoing Sequence Flows.");
    public static final TMsg PRJ_00003 = ProjectCompileMsg.tmsg("Node '%0' has outgoing Sequence Flows when it should not");
    public static final TMsg PRJ_00011 = ProjectCompileMsg.tmsg("%0 '%1' has more than one default outgoing sequence flow.");
    public static final TMsg PRJ_00025 = ProjectCompileMsg.tmsg("Role %0 is Parametric but it does not have a Data Object defined as a parameter.");
    public static final TMsg PRJ_00058 = ProjectCompileMsg.tmsg("Variable %0 was not found in the model.");
    public static final TMsg PRJ_00066 = ProjectCompileMsg.tmsg("Measurement '%0' is marked as 'Interval End' but does not have a Interval Start Measurement configured.");
    public static final TMsg PRJ_00080 = ProjectCompileMsg.tmsg("Event-triggered Subprocess (%0) with more than one Start Event.");
    public static final TMsg PRJ_00081 = ProjectCompileMsg.tmsg("Event-triggered Subprocess (%0) with Start Event with a trigger of type None.");
    public static final TMsg PRJ_00082 = ProjectCompileMsg.tmsg("The %0 expression from node (%1) is empty.");
    public static final TMsg EMPTY_EXPRESSION_IN_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("The condition in Sequence Flow (%0) is empty.");
    public static final Msg MTM_02063 = ProjectCompileMsg.msg("This node does not have a name.");
    public static final Msg MTM_03001 = ProjectCompileMsg.msg("A general exception occurred while parsing the process source.");
    public static final TMsg MTM_03008 = ProjectCompileMsg.tmsg("File cannot be parsed. Caused by: %0");
    public static final Msg PRJ_00090 = ProjectCompileMsg.msg("Crimson parser bug: Character ']' in a possition multiple of 8192. Add or remove a space in a previous position (inside CDATA) to avoid it.");
    private static final TMsg PRJ_00112 = ProjectCompileMsg.tmsg("Role '%0' associated to a model must exist.");
    private static final TMsg ROLE_NOT_FOUND = ProjectCompileMsg.tmsg("Role '%0' does not exist in organization");
    public static final TMsg ERROR = ProjectCompileMsg.tmsg("Error: %0");
    private static final TMsg INVALID_LOCATION = ProjectCompileMsg.tmsg("Invalid location to place node %0");
    public static final Msg MAIN_FLOW = ProjectCompileMsg.msg("Main Flow");
    public static final Msg EXCEPTION_HANDLING_FLOW = ProjectCompileMsg.msg("Exception Handling Flow");
    public static final Msg EXPRESSION_IS_NOT_QUERY = ProjectCompileMsg.msg("Expression is not a query");
    public static final TMsg EXPRESSION_HAS_INVALID_RESULT_TYPE = ProjectCompileMsg.tmsg("Expression has an invalid result type (expected %0 but was %1)");
    private static final TMsg XPATH_EXPRESSION_IS_INVALID = ProjectCompileMsg.tmsg("XPath expression '%0' is invalid. Cause: '%1'");
    private static final TMsg XPATH_UNDEFINED_PREFIXES = ProjectCompileMsg.tmsg("XPath expression '%0' use undefined prefixes: '%1'");
    public static final Msg COMPENSATION_FLOW = ProjectCompileMsg.msg("Compensation Flow");
    public static final TMsg SPLIT_FLOW = ProjectCompileMsg.tmsg("Diverging Gateway flow originated by node '%0'");
    public static final TMsg ALIAS_LANES_WITH_DIFFERENT_PARAM_VAR = ProjectCompileMsg.tmsg("Lane '%0(%1)' must have the same parameter variable as '%2(%3)'.");
    public static final TMsg FLOWNODE_HAS_NO_IMPLEMENTATION = ProjectCompileMsg.tmsg("Node '%0' has no implementation defined");
    private static final TMsg NO_ROLES_FOR_SIMULATION_RESOURCE = ProjectCompileMsg.tmsg("No roles selected for simulation resource %0");
    private static final TMsg SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR = ProjectCompileMsg.tmsg("Efficiency value for simulation resource %0 should be between 0%% and 100%%");
    private static final TMsg SIMULATION_INVALID_RESOURCE_NAME = ProjectCompileMsg.tmsg("Invalid ID '%0' for resource.");
    private static final TMsg SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR = ProjectCompileMsg.tmsg("Availability value for simulation resource %0 should be between 0%% and 100%%");
    private static final TMsg SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR = ProjectCompileMsg.tmsg("Category probabilities for project simulation %0 exceed 100%%");
    public static final TErrorMsg CATALOG_OBJECT_INVALID_ATTRIBUTE = ProjectCompileMsg.tErrorMsg("Business Catalog object '%0' is not valid. The attribute name '%1' is referencing an XML Schema %2 '%3' that cannot be found in the project.\".", "This can happen if the XML Schema element or complex type is removed", "Check the project XML Schemas files");
    public static final TErrorMsg CATALOG_OBJECT_INVALID_METHOD_PARAMETER = ProjectCompileMsg.tErrorMsg("Business Catalog object '%0' is not valid. The parameter '%1' of the method '%2' is referencing an XML Schema %3 '%4' that cannot be found in the project.", "This can happen if the XML Schema element or complex type is removed", "Check the project XML Schemas files");
    public static final Msg PARALLEL_GATEWAY_HAS_CONDITIONAL_FLOWS = ProjectCompileMsg.msg("Parallel Gateway cannot have outgoing Conditional Sequence Flows");
    private static final TMsg EVENT_HAS_NO_SIGNAL_DEFINED = ProjectCompileMsg.tmsg("Event %0 has no Signal defined");
    private static final TMsg INITIATE_HAS_INVALID_PREDECESSORS = ProjectCompileMsg.tmsg("There might be an invalid path between Initiator Task node %0 and node %1.");
    private static final TMsg INVALID_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid sequence flow. Source %0, Target %1");
    private static final TMsg MAIN_TO_BOUNDARY_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid Sequence Flow: it connects a node located in the Main flow (%0) to a node located in a Boundary Event flow (%1)");
    private static final TMsg BOUNDARY_TO_MAIN_SEQUENCE_FLOW = ProjectCompileMsg.tmsg("Invalid Sequence Flow connects a node located in a non-interrupting Boundary flow (%0) to a node located in Main flow (%1)");
    public static final Msg INVALID_SIGNAL_LOCATION = ProjectCompileMsg.msg("Signal Events cannot be set as Boundary, only as Start Events");
    public static final TMsg DATA_ASSOCIATION_CANNOT_RESOLVE_TARGET_TYPE = ProjectCompileMsg.tmsg("Cannot resolve the type for data association in node %0");
    private static final TMsg DATA_ASSOCIATION_NULL_EMPTY_EXP = ProjectCompileMsg.tmsg("One or more Data Associations in node %0 cannot have an empty or null expression");
    private static final TMsg DATA_ASSOCIATION_TARGET_REF_NULL = ProjectCompileMsg.tmsg("One or more Data Associations in node %0 cannot have a 'null' target reference");
    private static final TMsg DATA_TRANSFORMATION_NOT_EXISTS = ProjectCompileMsg.tmsg("The selected Transformation (%1) in node %0 does not exists");
    private static final TMsg INVALID_USER_TASK_REINITIATE_SOURCE = ProjectCompileMsg.tmsg("The reinitiate source in user task %0 is null or invalid");
    private static final TMsg INVALID_DATA_TRANSFORMATION_SOURCE = ProjectCompileMsg.tmsg("The transformation in node %0 has an invalid source reference: %1");
    private static final TMsg NULL_DATA_TRANSFORMATION_TARGET = ProjectCompileMsg.tmsg("The transformation in node %0 has an null target reference");
    private static final TMsg INVALID_DATA_TRANSFORMATION_TARGET = ProjectCompileMsg.tmsg("The transformation in node %0 has an invalid target reference: %1");
    private static final TMsg INVALID_ATTRIBUTE_EXPRESSION = ProjectCompileMsg.tmsg("The expression in attribute %1 of node %0 is invalid: %2");
    private static final TMsg INVALID_FLOWNODE_EXPRESSION = ProjectCompileMsg.tmsg("The expression in node %0 is invalid: %1");
    private static final TMsg INVALID_SEQUENCEFLOW_EXPRESSION = ProjectCompileMsg.tmsg("The expression in sequence flow (%0 to %1) is invalid: %2");
    private static final TMsg NO_VALID_PATH_FOR_MEASUREMENTS = ProjectCompileMsg.tmsg("There is no valid path between Interval Start (%0) and Interval Stop (%1)");

    public static Msg ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE(String label, String label2) {
        return ROUTE_BETWEEN_MESSAGE_START_AND_INITIATE_RECEIVE.args(label, label2);
    }

    public static Msg INITIATE_RECEIVE_MUST_BE_THE_FIRST(String label) {
        return INITIATE_RECEIVE_MUST_BE_THE_FIRST.args(label);
    }

    public static Msg NO_VALID_PATH_FOR_MEASUREMENTS(String defaultLabel, String defaultLabel1) {
        return NO_VALID_PATH_FOR_MEASUREMENTS.args(defaultLabel, defaultLabel1);
    }

    public static Msg MEASUREMENT_MARK_STOP_WITHOUT_START(String measurementMark) {
        return MEASUREMENT_MARK_STOP_WITHOUT_START.args(measurementMark);
    }

    public static Msg XPATH_UNDEFINED_PREFIXES(String expression, String prefixes) {
        return XPATH_UNDEFINED_PREFIXES.args(expression, prefixes);
    }

    public static Msg MEASUREMENT_MARK_START_WITHOUT_STOP(String measurementMark) {
        return MEASUREMENT_MARK_START_WITHOUT_STOP.args(measurementMark);
    }

    public static Msg FLOWNODE_HAS_NO_IMPLEMENTATION(String node) {
        return FLOWNODE_HAS_NO_IMPLEMENTATION.args(node);
    }

    public static Msg NO_ROLES_FOR_SIMULATION_RESOURCE(String simulationResourceId) {
        return NO_ROLES_FOR_SIMULATION_RESOURCE.args(simulationResourceId);
    }

    public static Msg SIMULATION_INVALID_RESOURCE_NAME(String id) {
        return SIMULATION_INVALID_RESOURCE_NAME.args(id);
    }

    public static Msg SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_RESOURCE_EFFICIENCY_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_RESOURCE_AVAILABILITY_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR(String simulationResourceId) {
        return SIMULATION_CATEGORY_PROBABILITIES_VALUE_ERROR.args(simulationResourceId);
    }

    public static Msg PRJ_00046(String arg0, String arg1) {
        return PRJ_00046.args(arg0, arg1);
    }

    public static Msg PRJ_00048(String arg0, String arg1) {
        return PRJ_00048.args(arg0, arg1);
    }

    public static Msg PRJ_00049(String activity, String error) {
        return PRJ_00049.args(activity, error);
    }

    public static Msg MTM_02012(String arg0) {
        return MTM_02012.args(arg0);
    }

    public static Msg MTM_02044(String arg0, String arg1, String arg2, String arg3) {
        return MTM_02044.args(arg0, arg1, arg2, arg3);
    }

    public static Msg MOVED_FROM_TO(String from, String to) {
        return MOVED_FROM_TO.args(from, to);
    }

    public static Msg MTM_03008(String arg0) {
        return MTM_03008.args(arg0);
    }

    public static Msg MTM_02005(String arg0) {
        return MTM_02005.args(arg0);
    }

    public static Msg MTM_02024(String arg0) {
        return MTM_02024.args(arg0);
    }

    public static Msg MTM_02026(String arg0) {
        return MTM_02026.args(arg0);
    }

    public static Msg MTM_02027(String arg0) {
        return MTM_02027.args(arg0);
    }

    public static Msg MTM_02037(String arg0) {
        return MTM_02037.args(arg0);
    }

    public static Msg MTM_02054(String arg0) {
        return MTM_02054.args(arg0);
    }

    public static Msg MTM_02058(String arg0) {
        return MTM_02058.args(arg0);
    }

    public static Msg MTM_02061(String arg0) {
        return MTM_02061.args(arg0);
    }

    public static Msg MTM_02064(String arg0) {
        return MTM_02064.args(arg0);
    }

    public static Msg MTM_02065(String arg0) {
        return MTM_02065.args(arg0);
    }

    public static Msg MTM_02097(String arg0) {
        return MTM_02097.args(arg0);
    }

    public static Msg MTM_02112(String arg0, String arg1, String arg2) {
        return MTM_02112.args(arg0, arg1, arg2);
    }

    public static Msg MTM_02113(String arg0, String arg1, String arg2) {
        return MTM_02113.args(arg0, arg1, arg2);
    }

    public static Msg MTM_02121(String arg0, String arg1) {
        return MTM_02121.args(arg0, arg1);
    }

    public static Msg MTM_03002(String fileName) {
        return MTM_03002.args(fileName);
    }

    public static Msg MTM_03003(String fileName) {
        return MTM_03003.args(fileName);
    }

    public static Msg MTM_03006(String fileName) {
        return MTM_03006.args(fileName);
    }

    public static Msg PRJ_00001(String arg0) {
        return PRJ_00001.args(arg0);
    }

    public static Msg PRJ_00002(String arg0) {
        return PRJ_00002.args(arg0);
    }

    public static Msg PRJ_00003(String arg0) {
        return PRJ_00003.args(arg0);
    }

    public static Msg PRJ_00011(String gatewayType, String gatewayName) {
        return PRJ_00011.args(gatewayType, gatewayName);
    }

    public static Msg PRJ_00025(String arg0) {
        return PRJ_00025.args(arg0);
    }

    public static Msg PRJ_00058(String arg0) {
        return PRJ_00058.args(arg0);
    }

    public static Msg PRJ_00066(String measureName) {
        return PRJ_00066.args(measureName);
    }

    public static Msg PRJ_00080(String processName) {
        return PRJ_00080.args(processName);
    }

    public static Msg PRJ_00081(String processName) {
        return PRJ_00081.args(processName);
    }

    public static Msg PRJ_00082(String expressionName, String flowName) {
        return PRJ_00082.args(expressionName, flowName);
    }

    public static Msg EMPTY_EXPRESSION_IN_SEQUENCE_FLOW(String flowName) {
        return EMPTY_EXPRESSION_IN_SEQUENCE_FLOW.args(flowName);
    }

    public static Msg PRJ_00112(Lane lane) {
        return PRJ_00112.args(lane.getId());
    }

    public static Msg DSG_00004(String arg0) {
        return DSG_00004.args(arg0);
    }

    public static Msg ROLE_NOT_FOUND(String roleName) {
        return ROLE_NOT_FOUND.args(roleName);
    }

    public static ErrorMsg CATALOG_OBJECT_INVALID_ATTRIBUTE(@NotNull String typeName, @NotNull String attributeName, @NotNull String elementDescription, @NotNull String name) {
        return CATALOG_OBJECT_INVALID_ATTRIBUTE.args(typeName, attributeName, elementDescription, name);
    }

    public static ErrorMsg CATALOG_OBJECT_INVALID_METHOD_PARAMETER(@NotNull String typeName, @NotNull String method, @NotNull String param, @NotNull String elementDescription, @NotNull String name) {
        return CATALOG_OBJECT_INVALID_METHOD_PARAMETER.args(typeName, param, method, elementDescription, name);
    }

    public static Msg INVALID_LOCATION(String id) {
        return INVALID_LOCATION.args(id);
    }

    public static Msg SPLIT_FLOW(String splitName) {
        return SPLIT_FLOW.args(splitName);
    }

    public static Msg ALIAS_LANES_WITH_DIFFERENT_PARAM_VAR(String laneId, String laneParamName, String aliasLaneId, String aliasLaneParamName) {
        return ALIAS_LANES_WITH_DIFFERENT_PARAM_VAR.args(laneId, laneParamName, aliasLaneId, aliasLaneParamName);
    }

    public static Msg DSG_01003(String arg0) {
        return DSG_01003.args(arg0);
    }

    public static Msg ERROR(String cause) {
        return ERROR.args(cause);
    }

    public static Msg COMPONENT_NOT_FOUND_IN_CATALOG(String component) {
        return COMPONENT_NOT_FOUND_IN_CATALOG.args(component);
    }

    public static Msg INVALID_CONDITIONAL_FLOW(String flowNode) {
        return INVALID_CONDITIONAL_FLOW.args(flowNode);
    }

    public static Msg EVENT_HAS_NO_SIGNAL_DEFINED(String eventName) {
        return EVENT_HAS_NO_SIGNAL_DEFINED.args(eventName);
    }

    public static Msg INITIATE_HAS_INVALID_PREDECESSORS(String defaultLabel, String predecessor) {
        return INITIATE_HAS_INVALID_PREDECESSORS.args(defaultLabel, predecessor);
    }

    public static Msg INVALID_SEQUENCE_FLOW(String source, String target) {
        return INVALID_SEQUENCE_FLOW.args(source, target);
    }

    public static Msg MAIN_TO_BOUNDARY_SEQUENCE_FLOW(String sourceNode, String node) {
        return MAIN_TO_BOUNDARY_SEQUENCE_FLOW.args(sourceNode, node);
    }

    public static Msg BOUNDARY_TO_MAIN_SEQUENCE_FLOW(String sourceNode, String node) {
        return BOUNDARY_TO_MAIN_SEQUENCE_FLOW.args(sourceNode, node);
    }

    public static Msg CONVERSATION_HAS_NO_RELATED_NODE(String defaultLabel) {
        return CONVERSATION_HAS_NO_RELATED_NODE.args(defaultLabel);
    }

    public static Msg CONVERSATION_HAS_AN_INVALID_IMPLEMENTATION(String node) {
        return CONVERSATION_HAS_AN_INVALID_IMPLEMENTATION.args(node);
    }

    public static Msg CONVERSATION_HAS_NO_INITIATOR_IMPLEMENTATION(String defaultLabel) {
        return CONVERSATION_HAS_NO_INITIATOR_IMPLEMENTATION.args(defaultLabel);
    }

    public static Msg CONVERSATION_OVER_IMPLEMENTED(String defaultLabel) {
        return CONVERSATION_OVER_IMPLEMENTED.args(defaultLabel);
    }

    public static Msg MUST_CONTINUE_INITIATOR_NODE(String defaultLabel) {
        return MUST_CONTINUE_INITIATOR_NODE.args(defaultLabel);
    }

    public static Msg CONVERSATION_OPERATION_NULL(String defaultLabel) {
        return CONVERSATION_OPERATION_NULL.args(defaultLabel);
    }

    public static Msg CONVERSATION_OPERATION_DUPLICATED(String defaultLabel) {
        return CONVERSATION_OPERATION_DUPLICATED.args(defaultLabel);
    }

    public static Msg CONVERSATION_INVALID_THROWER_INTERFACE(String defaultLabel) {
        return CONVERSATION_INVALID_THROWER_INTERFACE.args(defaultLabel);
    }

    public static Msg ARGUMENT_INVALID_TYPE(String node, String argumentName) {
        return ARGUMENT_INVALID_TYPE.args(node, argumentName);
    }

    public static Msg CALL_ACTIVITY_HAS_NO_CALLABLE(String defaultLabel) {
        return CALL_ACTIVITY_HAS_NO_CALLABLE.args(defaultLabel);
    }

    public static Msg MULTIPLE_START_NOT_ALLOWED(String defaultLabel) {
        return MULTIPLE_START_NOT_ALLOWED.args(defaultLabel);
    }

    public static Msg ERROR_NOT_DEFINED(String defaultLabel) {
        return ERROR_NOT_DEFINED.args(defaultLabel);
    }

    public static Msg BOUNDARY_ALREADY_HANDLED(String defaultLabel, String boundedTo, String label) {
        return BOUNDARY_ALREADY_HANDLED.args(label, defaultLabel, boundedTo);
    }

    public static Msg SERVICE_INVALID(String defaultLabel) {
        return SERVICE_INVALID.args(defaultLabel);
    }

    public static Msg SERVICE_NULL(String defaultLabel) {
        return SERVICE_NULL.args(defaultLabel);
    }

    public static Msg OPERATION_INVALID(String defaultLabel) {
        return OPERATION_INVALID.args(defaultLabel);
    }

    public static Msg OPERATION_NULL(String defaultLabel) {
        return OPERATION_NULL.args(defaultLabel);
    }

    public static Msg PROCESS_INVALID(String defaultLabel) {
        return PROCESS_INVALID.args(defaultLabel);
    }

    public static Msg PROCESS_NULL(String defaultLabel) {
        return PROCESS_NULL.args(defaultLabel);
    }

    public static Msg NODE_INVALID(String defaultLabel) {
        return NODE_INVALID.args(defaultLabel);
    }

    public static Msg NODE_NULL(String defaultLabel) {
        return NODE_NULL.args(defaultLabel);
    }

    public static Msg EXCEPTION_INVALID(String defaultLabel) {
        return EXCEPTION_INVALID.args(defaultLabel);
    }

    public static Msg EXPRESSION_HAS_INVALID_RESULT_TYPE(String expectedType, String resultType) {
        return EXPRESSION_HAS_INVALID_RESULT_TYPE.args(expectedType, resultType);
    }

    public static Msg EXCEPTION_VALID_PATH_MISSING(String defaultLabel) {
        return EXCEPTION_VALID_PATH_MISSING.args(defaultLabel);
    }

    public static Msg DATA_ASSOCIATION_NULL_EMPTY_EXP(String defaultLabel) {
        return DATA_ASSOCIATION_NULL_EMPTY_EXP.args(defaultLabel);
    }

    public static Msg DATA_ASSOCIATION_TARGET_REF_NULL(String defaultLabel) {
        return DATA_ASSOCIATION_TARGET_REF_NULL.args(defaultLabel);
    }

    public static Msg DATA_ASSOCIATION_CANNOT_RESOLVE_TARGET_TYPE(String node) {
        return DATA_ASSOCIATION_CANNOT_RESOLVE_TARGET_TYPE.args(node);
    }

    public static Msg DATA_TRANSFORMATION_NOT_EXISTS(String node, String transformationName) {
        return DATA_TRANSFORMATION_NOT_EXISTS.args(node, transformationName);
    }

    public static Msg INVALID_USER_TASK_REINITIATE_SOURCE(String userTaskName) {
        return INVALID_USER_TASK_REINITIATE_SOURCE.args(userTaskName);
    }

    public static Msg INVALID_DATA_TRANSFORMATION_SOURCE(String node, String ref) {
        return INVALID_DATA_TRANSFORMATION_SOURCE.args(node, ref);
    }

    public static Msg INVALID_DATA_TRANSFORMATION_TARGET(String node, String ref) {
        return INVALID_DATA_TRANSFORMATION_TARGET.args(node, ref);
    }

    public static Msg NULL_DATA_TRANSFORMATION_TARGET(String node) {
        return NULL_DATA_TRANSFORMATION_TARGET.args(node);
    }

    public static Msg INVALID_SEQUENCEFLOW_EXPRESSION(String fromNode, String toNode, String message) {
        return INVALID_SEQUENCEFLOW_EXPRESSION.args(fromNode, toNode, message);
    }

    public static Msg INVALID_FLOWNODE_EXPRESSION(String flowNode, String message) {
        return INVALID_FLOWNODE_EXPRESSION.args(flowNode, message);
    }

    public static Msg INVALID_ATTRIBUTE_EXPRESSION(String node, String attribute, String message) {
        return INVALID_ATTRIBUTE_EXPRESSION.args(node, attribute, message);
    }

    public static Msg BI_MUST_BE_MEASURE(String name) {
        return BI_MUST_BE_MEASURE.args(name);
    }

    public static Msg MESSAGE_ALREADY_HANDLED(String componentName, String operationName, String activityName) {
        return MESSAGE_ALREADY_HANDLED.args(componentName, operationName, activityName);
    }

    public static Msg BUSINESS_INDICATOR_NOT_A_COUNTER(String defaultLabel, String biLabel) {
        return BUSINESS_INDICATOR_NOT_A_COUNTER.args(defaultLabel, biLabel);
    }

    public static Msg DUPLICATE_DATAOBJECT_NAME(String name) {
        return DUPLICATE_DATAOBJECT_NAME.args(name);
    }

    public static Msg MORE_THAN_ONE_INTERRUPTING_TIMER(String node) {
        return MORE_THAN_ONE_INTERRUPTING_TIMER.args(node);
    }

    public static Msg XPATH_EXPRESSION_IS_INVALID(String expression, String message) {
        return XPATH_EXPRESSION_IS_INVALID.args(expression, message);
    }

    static {
        ProjectCompileMsg.init(ProjectCompileMsg.class, LogComponent.DEFAULT, ErrorRange.PROJECT_COMPILER);
    }
}

