/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.exceptions;

import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class InvalidProjectObjectExpressionException
extends ProjectException {
    static final long serialVersionUID = 2658700351653880316L;

    private InvalidProjectObjectExpressionException(ProjectObject object, Msg message) {
        super(object);
        this.setKey(message);
    }

    public static InvalidProjectObjectExpressionException create(@NotNull SequenceFlow sequenceFlow, @NotNull String message) {
        String source = sequenceFlow.getSource().getDefaultLabel();
        String target = sequenceFlow.getTarget().getDefaultLabel();
        return new InvalidProjectObjectExpressionException(sequenceFlow, ProjectCompileMsg.INVALID_SEQUENCEFLOW_EXPRESSION(source, target, message));
    }

    public static InvalidProjectObjectExpressionException create(@NotNull FlowNode node, @NotNull String message) {
        String nodeName = node.getDefaultLabel();
        return new InvalidProjectObjectExpressionException(node, ProjectCompileMsg.INVALID_FLOWNODE_EXPRESSION(nodeName, message));
    }

    public static InvalidProjectObjectExpressionException createInvalidAttribute(@NotNull FlowNode node, @NotNull String attribute, @NotNull String message) {
        String nodeName = node.getDefaultLabel();
        return new InvalidProjectObjectExpressionException(node, ProjectCompileMsg.INVALID_ATTRIBUTE_EXPRESSION(nodeName, attribute, message));
    }
}

