/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile.exceptions;

import oracle.bpm.lang.DefaultException;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.catalog.CatalogType;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class InvalidExpressionException
extends DefaultException {
    static final long serialVersionUID = 2658700351653880316L;

    private InvalidExpressionException(Msg message) {
        super(message);
    }

    public static InvalidExpressionException createExpressionIsInvalid(@NotNull Msg message) {
        return new ExpressionIsInvalidException(message);
    }

    public static InvalidExpressionException createXPathExpressionIsInvalid(@NotNull String expression, @NotNull Exception exception) {
        return new ExpressionIsInvalidException(ProjectCompileMsg.XPATH_EXPRESSION_IS_INVALID(expression, exception.getLocalizedMessage()));
    }

    public static InvalidExpressionException undefinedPrefixes(@NotNull String expression, @NotNull Iterable<String> prefixes) {
        return new ExpressionIsInvalidException(ProjectCompileMsg.XPATH_UNDEFINED_PREFIXES(expression, prefixes.toString()));
    }

    public static InvalidExpressionException createExpressionIsNotQuery() {
        return new ExpressionIsNotQueryException();
    }

    public static InvalidExpressionException createExpressionHasInvalidResultType(CatalogType expected, CatalogType result) {
        return new ExpressionHasInvalidResultTypeException(expected, result);
    }

    private static class ExpressionIsNotQueryException
    extends InvalidExpressionException {
        static final long serialVersionUID = 2658700351653880316L;

        private ExpressionIsNotQueryException() {
            super(ProjectCompileMsg.EXPRESSION_IS_NOT_QUERY);
        }
    }

    private static class ExpressionIsInvalidException
    extends InvalidExpressionException {
        static final long serialVersionUID = 2658700351653880316L;

        private ExpressionIsInvalidException(Msg message) {
            super(message);
        }
    }

    private static class ExpressionHasInvalidResultTypeException
    extends InvalidExpressionException {
        static final long serialVersionUID = 2658700351653880316L;

        private ExpressionHasInvalidResultTypeException(CatalogType expected, CatalogType result) {
            super(ProjectCompileMsg.EXPRESSION_HAS_INVALID_RESULT_TYPE(expected.getText() != null ? expected.getText() : "null", result.getText() != null ? result.getText() : "null"));
        }
    }
}

