/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import java.util.Set;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.xpath.DataReferenceParser;
import oracle.bpm.compiler.xpath.DataReferenceResult;
import oracle.bpm.compiler.xpath.NamespaceResolver;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.compile.ExpressionCompiler;
import oracle.bpm.project.compile.XPathReferenceResult;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import org.jetbrains.annotations.NotNull;

public class XPathReferencesParser {
    @NotNull
    private final DataDeclarationContainer context;
    @NotNull
    private final DataReferenceParser generator;

    public XPathReferencesParser(@NotNull DataDeclarationContainer contextProvider) {
        this.context = contextProvider;
        this.generator = new DataReferenceParser(ExpressionCompiler.buildScope(contextProvider));
    }

    @NotNull
    public XPathReferenceResult generate(@NotNull String expression, @NotNull NamespaceResolver resolver) throws CilException {
        return this.buildResult(this.generator.generate(expression, resolver));
    }

    @NotNull
    public XPathReferenceResult generate(@NotNull XPathExpression expression) throws CilException {
        return this.buildResult(this.generator.generate(expression));
    }

    private XPathReferenceResult buildResult(DataReferenceResult references) {
        Set<DataDeclaration> variables = ExpressionCompiler.asDataDeclarations(this.context, references.references);
        return new XPathReferenceResult(variables, references.prefixes);
    }
}

