/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.compile;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.maps.BiMap;
import oracle.bpm.collections.maps.HashBiMap;
import oracle.bpm.compiler.xpath.XPathUsageType;
import oracle.bpm.compiler.xpath.XPathVariable;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationType;
import oracle.bpm.type.TypeRef;
import org.jetbrains.annotations.Nullable;

public class CatalogUtils {
    private CatalogUtils() {
    }

    public static XPathVariable asXPathVariable(final DataDeclaration declaration) {
        return new XPathVariable(){

            public String getName() {
                return declaration.getName();
            }

            public String getNativeName() {
                return declaration.getNativeName();
            }

            public String getContainerName() {
                return declaration.getDeclarationContainer().getName();
            }

            public TypeRef getType() {
                return declaration.getType().getDelegate().getRef();
            }

            public XPathUsageType getUsageType() {
                DataDeclarationType type = declaration.getDeclarationType();
                assert (type != null && type != DataDeclarationType.DATA_DECLARATION);
                return CatalogUtils.asXPathUsageType(type);
            }

            public boolean isReadOnly() {
                return declaration.isReadOnly();
            }
        };
    }

    public static DataDeclarationType asDataDeclarationType(@Nullable XPathUsageType type) {
        DataDeclarationType result = (DataDeclarationType)TypeMapHolder.TYPE_MAP.inverse().get(type);
        if (result == null && type != null) {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    private static XPathUsageType asXPathUsageType(@Nullable DataDeclarationType type) {
        XPathUsageType result = (XPathUsageType)TypeMapHolder.TYPE_MAP.get(type);
        if (result == null && type != null) {
            throw new IllegalArgumentException(type.toString());
        }
        return result;
    }

    private static class TypeMapHolder {
        static final BiMap<DataDeclarationType, XPathUsageType> TYPE_MAP;

        private TypeMapHolder() {
        }

        static {
            HashBiMap<DataDeclarationType, XPathUsageType> typeMap = new HashBiMap<DataDeclarationType, XPathUsageType>(XPathUsageType.values().length);
            typeMap.put(DataDeclarationType.DATA_INPUT, XPathUsageType.DATA_INPUT);
            typeMap.put(DataDeclarationType.DATA_OUTPUT, XPathUsageType.DATA_OUTPUT);
            typeMap.put(DataDeclarationType.DATA_OBJECT, XPathUsageType.DATA_OBJECT);
            typeMap.put(DataDeclarationType.ACTIVITY_PREDEFINED_VARIABLE, XPathUsageType.ACTIVITY_INSTANCE_ATTRIBUTE);
            typeMap.put(DataDeclarationType.PROCESS_PREDEFINED_VARIABLE, XPathUsageType.PROCESS_INSTANCE_ATTRIBUTE);
            typeMap.put(DataDeclarationType.GATEWAY_PREDEFINED_VARIABLE, XPathUsageType.GATEWAY_INSTANCE_ATTRIBUTE);
            TYPE_MAP = CollectionUtils.unmodifiableBiMap(typeMap);
        }
    }
}

