/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.command.design.TranslateLaneCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import org.jetbrains.annotations.NotNull;

public class ResizeLaneCommand
extends MultipleCommand {
    public ResizeLaneCommand(@NotNull Lane lane, int size) {
        this(lane, size, false);
    }

    public ResizeLaneCommand(@NotNull Lane lane, int size, boolean force) {
        super(lane);
        this.build(size, force);
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.MOVE_OBJECT(this.getAffectedObject().getId()).getString();
    }

    @Override
    public Lane getAffectedObject() {
        return (Lane)super.getAffectedObject();
    }

    private void build(int size, boolean force) {
        int newSize = force ? size : LaneUtils.calculateMinimunLaneSize(this.getAffectedObject(), size);
        int offset = 0;
        for (Lane affected : this.getProcess().getLanes()) {
            if (affected.getOffset() != offset) {
                this.addCommand(new TranslateLaneCommand(affected, offset));
            }
            if (affected.equals(this.getAffectedObject())) {
                this.addCommand(new ChangeLaneSizeCommand(affected, newSize));
                offset += newSize;
                continue;
            }
            offset += affected.getSize();
        }
    }

    private Process getProcess() {
        return this.getAffectedObject().getProcess();
    }

    static class ChangeLaneSizeCommand
    extends ProjectCommand {
        private Lane lane;
        private int newSize;
        private int oldSize;

        public ChangeLaneSizeCommand(@NotNull Lane lane, int newSize) {
            super(new ProjectObject[0]);
            this.lane = lane;
            this.oldSize = lane.getSize();
            this.newSize = newSize;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Object execute() throws ExecutionException {
            this.lane.asMutable().setSize(this.newSize);
            return null;
        }

        @Override
        public void undo() {
            this.lane.asMutable().setSize(this.oldSize);
        }
    }
}

