/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.execution.ExecutionException;
import oracle.bpm.project.command.ProjectCommand;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.InOutDataAssociationFeature;
import oracle.bpm.project.model.features.ParticipantFeature;
import oracle.bpm.project.model.features.ScriptTaskFeature;
import oracle.bpm.project.model.features.SingleDataAssociationFeature;
import oracle.bpm.project.model.features.UserTaskFeature;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.dataassociations.DataAssociationSet;
import org.jetbrains.annotations.NotNull;

public class ResetActivityImplementationCommand
extends ProjectCommand {
    private FlowNode node;

    public ResetActivityImplementationCommand(@NotNull FlowNode activity) {
        super(activity);
        this.node = activity;
    }

    public static void reset(FlowNode activity) {
        new ResetActivityImplementationCommand(activity).execute();
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public Object execute() throws ExecutionException {
        try {
            this.reset();
        }
        catch (ProjectException e) {
            throw new ExecutionException(e);
        }
        return null;
    }

    public void reset() throws ProjectException {
        SingleDataAssociationFeature single;
        ScriptTaskFeature scriptTask;
        InOutDataAssociationFeature inOutFeature;
        ParticipantFeature participantFeature;
        UserTaskFeature userTaskFeature;
        if (this.node.isConversationMember()) {
            this.resetConversationEnabled((ConversationEnabled)this.node);
        }
        if ((userTaskFeature = this.node.getFeature(UserTaskFeature.class)) != null) {
            this.resetUserTask(userTaskFeature);
        }
        if ((participantFeature = this.node.getFeature(ParticipantFeature.class)) != null) {
            this.resetParticipantFeature(participantFeature);
        }
        if ((inOutFeature = this.node.getFeature(InOutDataAssociationFeature.class)) != null) {
            this.resetInOut(inOutFeature);
        }
        if ((scriptTask = this.node.getFeature(ScriptTaskFeature.class)) != null) {
            this.resetScript(scriptTask);
        }
        if ((single = this.node.getFeature(SingleDataAssociationFeature.class)) != null) {
            this.resetSingle(single);
        }
    }

    private void resetConversationEnabled(ConversationEnabled conversationEnabled) throws ProjectException {
        conversationEnabled.setDefinedOperationName(null);
        conversationEnabled.setAssociatedNode(null);
        conversationEnabled.setAssociatedError(null);
        conversationEnabled.setOperation(null);
    }

    private void resetUserTask(UserTaskFeature userTaskFeature) throws ProjectException {
        userTaskFeature.setHumanTask(null);
    }

    private void resetParticipantFeature(ParticipantFeature userTaskFeature) throws ProjectException {
        userTaskFeature.setOperation(null);
    }

    private void resetInOut(InOutDataAssociationFeature inOutFeature) throws ProjectException {
        this.clearSet(inOutFeature.getInputDataAssociationSet());
        this.clearSet(inOutFeature.getOutputDataAssociationSet());
    }

    private void resetScript(ScriptTaskFeature scriptTask) throws ProjectException {
        scriptTask.setScript(null);
    }

    private void resetSingle(SingleDataAssociationFeature single) throws ProjectException {
        this.clearSet(single.getDataAssociationSet());
    }

    private void clearSet(DataAssociationSet dataAssociationSet) {
        dataAssociationSet.clearDataAssociations();
        dataAssociationSet.clearDataTransformations();
    }
}

