/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.project.command.design;

import oracle.bpm.project.command.MultipleCommand;
import oracle.bpm.project.command.design.RemoveActivityCommand;
import oracle.bpm.project.command.design.RemoveLaneCommand;
import oracle.bpm.project.command.design.RemoveMeasurementCommand;
import oracle.bpm.project.command.design.RemoveNoteCommand;
import oracle.bpm.project.command.design.RemoveTransitionCommand;
import oracle.bpm.project.command.msg.ProjectCommandMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Measurement;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.project.ui.ModelObjectSelection;
import org.jetbrains.annotations.NotNull;

public class RemoveObjectsCommand
extends MultipleCommand {
    @NotNull
    private final ModelObjectSelection modelObjects;

    public RemoveObjectsCommand(@NotNull ModelObjectSelection modelObjects) {
        super((ProjectObject)modelObjects.as(ProjectObject.class));
        this.modelObjects = modelObjects;
        this.build();
    }

    @Override
    public String getName() {
        return ProjectCommandMsg.REMOVE.getString();
    }

    private void build() {
        this.modelObjects.removeBoundedEvents();
        for (FlowElement flowElement : this.modelObjects) {
            if (flowElement instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)flowElement;
                this.addCommand(new RemoveActivityCommand(flowNode));
                continue;
            }
            if (flowElement instanceof SequenceFlow) {
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                this.addCommand(new RemoveTransitionCommand(sequenceFlow));
                continue;
            }
            if (flowElement instanceof Lane) {
                Lane lane = (Lane)flowElement;
                this.addCommand(new RemoveLaneCommand(lane));
                continue;
            }
            if (flowElement instanceof Measurement) {
                Measurement measurement = (Measurement)flowElement;
                this.addCommand(new RemoveMeasurementCommand(measurement));
                continue;
            }
            if (!(flowElement instanceof TextAnnotation)) continue;
            TextAnnotation textAnnotation = (TextAnnotation)flowElement;
            this.addCommand(new RemoveNoteCommand(textAnnotation));
        }
    }
}

